package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.LayoutComponentTypeEnum;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>功能描述：项目卡标准页面模板</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DesignerProjectPageTemplate.java
 * @Author: wangjwc
 * @Date: created at 2024/12/4 15:13
 */
@Service
public class DesignerProjectPageTemplate extends CommonStandardChargeGeneralPageTemplate {
    public static final String SUPPORT_KEY = "webplatform-project-charge";

    /**
     * 返回支持的模板
     *
     * @return
     */
    @Override
    public String supportKey() {
        return SUPPORT_KEY;
    }

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    @Autowired
    protected BusinessProcessPerformerImpl businessProcessPerformer;

    @Override
    public UiBotModel createPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        // 页面内容
        this.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, 2, null);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext,
                                     PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        int type = this.useTabComponentRender(pageDefines) ? 2 : 1;
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
//        if (TaskStringUtil.isBizSmartAdjust(executeContext.getTmActivityId())) {
//            // 随心控(人工型：code+_task_manual;审核型：code+_task_approve) 根据PCsubmitAction构建底部按钮
//            uiBotDesignerRenderService.buildSmartAdjustBottomButton(apiRequest, uiBotModel);
//        }
//        // 处理单身新增功能--ZtbViewList卡片列表组件与表单组件
//        UiBotDesignerRenderService.handleRawPageData(apiRequest, uiBotModel);
//        // titleBody
//        uiBotDesignerRenderService.buildProjectTitleBody(apiRequest, uiBotModel);
//        // 构建机制参数和交付设计器参数
//        uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);

        // 构建单头
        this.buildSingleHead(apiRequest, executeContext, uiBotModel, mainAction);
        // 页面内容
        this.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, type, null);
        //由于构建交付设计器的方法先执行，后面参数可能会被覆盖掉
        UiBotPageData rawUiBotPageData = uiBotModel.getRawUiBotPageData();
        uiBotModel.getPageData().putAll(rawUiBotPageData);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));

        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    private Boolean useTabComponentRender(List<PcUiBotTaskPageDefine> pageDefines) {
        if (CollectionUtils.isEmpty(pageDefines)) {
            return false;
        }
        return pageDefines.stream().anyMatch(r -> BooleanUtils.isTrue(r.getShowTitle()));
    }

    private void buildSingleHead(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, PcUiBotTaskPageDefine mainAction) {
        if (BooleanUtils.isTrue(mainAction.getShowSingleHeadFrom())) {
            this.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, 1, LayoutComponentTypeEnum.SINGLE_HEAD.getValue());
        }
    }

    private void bulidRanderData(ApiRequest apiRequest, PcUiBotTaskPageDefine mainAction, PcUiBotExecuteContext executeContext,
                                 UiBotModel uiBotModel, int type, String componentType) {
        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        cmptContext.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
        cmptContext.setExecuteContext(executeContext);
        cmptContext.setPageDefine(mainAction);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.PROJECT.name());

        businessProcessPerformer.handleRanderData(executeContext, uiBotModel, type, componentType, mobilePageRawData, cmptContext);
    }

}