package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.DesignerBusinessDataEntryDrivenTaskBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * DSL手动发起项目模板类
 *
 * @Author xujinc
 * @Version 1.0
 * @Date 2023/12/22 09:16
 */
@Component
public class DesignerStartProjectPageTemplate extends StartProjectGeneralPageTemplate {

    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformer;

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DesignerBusinessDataEntryDrivenTaskBuilder designerBusinessDataEntryDrivenTaskBuilder;

    private static final ThreadLocal<QueryResultSet> CONTEXT_HOLDER = new TransmittableThreadLocal<>();

    @Override
    public String supportKey() {
        return PcUibotSupportKeyConstant.Designer.START_PROJECT;
    }

    @Override
    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine, List<PcUiBotTaskPageDefine> pageDefines, UiBotModel dynamicForm) {
        CONTEXT_HOLDER.set(queryResultSet);
        // 向uibotMode中存入layout，获取cardlist新增场景获取path使用
        List<UiBotQueryButton> queryButtonList = JsonUtil.objectToJavaObject(pageDefines,
                new TypeReference<List<UiBotQueryButton>>() {
                });
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setType(PcModuleEnum.CONTENT_QUERY_BUTTON.getValue());
        uiBotLayout.setQueryButtons(queryButtonList);
        dynamicForm.addLayout(uiBotLayout);
    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext,
                                     PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        try {
            UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
            if (mainAction.getBindForm() != null && StringUtils.hasLength(mainAction.getBindForm().getFormCode())) {
                // 模型驱动生成的发起项目
                QueryResultSet queryResultSet = CONTEXT_HOLDER.get();
                UiBotModel page = designerBusinessDataEntryDrivenTaskBuilder.createPage(executeContext, queryResultSet, mainAction, apiRequest);
                if (!CollectionUtils.isEmpty(page.getRules())) {
                    uiBotModel.setRules(page.getRules());
                }
                if (MapUtils.isNotEmpty(page.getPageData())) {
                    uiBotModel.getPageData().putAll(page.getPageData());
                }
            }

            if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
                uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
            }
            // 处理单身新增功能--ZtbViewList卡片列表组件与表单组件
            UiBotDesignerRenderService.handleRawPageData(apiRequest, uiBotModel);

            if ("start_SCH_mainline_project_0001".equalsIgnoreCase(executeContext.getTmActivityId())
                    && Objects.isNull(apiRequest.getRawData().getBusinessType())) {
                uiBotModel.getPageData().put("render_obj", Collections.emptyList());
            }

            // 页面内容
            this.bulidRanderData(apiRequest, executeContext, uiBotModel, mainAction, null);
            // 原始数据
            uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));

            // 构建机制参数和交付设计器参数
            uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);

            uiBotModel.getLayout().clear();
            uiBotModel.getPageData().clear();
            if (Objects.nonNull(uiBotModel.getActions())) {
                uiBotModel.getActions().clear();
            }
            uiBotModel.setPageDataIndex(null);
            uiBotModel.setPageDataKeys(null);
            uiBotModel.initMobileLayoutType();
            uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
            uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                    ?
                    uiBotModel.getPageBackgroudColor()
                    :
                    BackgroundColorEnum.APP_MAIN_GREY.getValue());
            uiBotModel.setPageTitle(apiRequest.getRawData().getString("project_name"));
            return uiBotModel;
        } finally {
            CONTEXT_HOLDER.remove();
        }
    }

    private void bulidRanderData(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, PcUiBotTaskPageDefine pageDefine, String componentType) {
        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        cmptContext.setPageDefine(pageDefine);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.START_PROJECT.name());
        uiBotDesignerRenderService.buildCmptSubmitAction(pageDefine);
        UiBotQueryButton queryButton = JsonUtil.objectToJavaObject(pageDefine, UiBotQueryButton.class);
        // 构建头部项目介绍
        buildProjectIntroduce(apiRequest, uiBotModel);

        // 高级属性--构建主页面hooks与上下文中组件级hooks
        uiBotDesignerRenderService.buildMainPageHooksByPageDefine(pageDefine, cmptContext, uiBotModel, componentType);

        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                businessProcessPerformer.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(
                        new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }

            // 构建bottom
            List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                    businessProcessPerformer.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
            if (!CollectionUtils.isEmpty(bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
    }

    @Override
    protected void BuildRule(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(executeContext.getTmActivityId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            dynamicForm.setRules(rules);
        }
    }

    /**
     * 构建头部项目介绍，项目介绍非数据源字段，无法实现配置，固定栏位展示
     */
    private void buildProjectIntroduce(ApiRequest apiRequest, UiBotModel uiBotModel) {
        String projectIntroduce = Optional.ofNullable(apiRequest.getRawData().getString("project_introduce")).orElse("");
        InputMultiText inputMultiText = InputMultiText.create(localeService.getLanguageValue(apiRequest.getLocale(), "项目介绍"),
                projectIntroduce, false, false, apiRequest.getLocale());
        BaseMobileComponentWrapper<BaseMobileComponent> inputMultiTextComponentWrapper =
                new BaseMobileComponentWrapper<>(inputMultiText, "DW_" + InputMultiText.COMPONENT_TYPE, "project_introduce");

        CustomGroup customGroup = new CustomGroup();
        customGroup.setContentGroup(Collections.singletonList(inputMultiTextComponentWrapper));
        BaseMobileComponentWrapper<BaseMobileComponent> projectIntroduceComponentWrapper =
                new BaseMobileComponentWrapper<>(customGroup, "DW_" + CustomGroup.COMPONENT_TYPE, "header");

        uiBotModel.getRenderData().addWrapperedComponentToBody(projectIntroduceComponentWrapper);
    }
}
