package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotModelDesignerMultipleDataSources;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Constants;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Model;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Service;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryInfoSetService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBuilderUtils;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.CastUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：模板创建页面的基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: GeneralPageTemplate.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 20:37
 */
@Slf4j
@Service
public class GeneralPageTemplate<T extends PcUiBotPageDefine> implements TemplateService<T> {

    public final static String generalPageTemplate = "general-page-template";

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    protected PcRuleService pcRuleService;

    @Autowired
    protected MobileDesignerConfigRepository mobileDesignerConfigRepository;

    @Autowired
    protected MockV2Service mockV2Service;

    @Resource(name = "defaultThreadPool")
    protected ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    protected QueryInfoSetService queryInfoSetService;

//    @Autowired
//    TagBuilder pageBuilder;
//
//    @Autowired
//    TagService tagService;
//
//    @Autowired
//    MetadataService metadataService;
//
//    @Autowired
//    protected MessageUtils messageUtils;
//
//    @Autowired
//    ThemeMapService themeMapService;

    /**
     * 返回支持的模板
     *
     * @return
     */
    @Override
    public String supportKey() {
        return generalPageTemplate;
    }

    /**
     * 创建任务页面
     *
     * @param executeContext
     * @param mainAction
     * @param pageDefines
     * @return
     */
    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, T mainAction, List<T> pageDefines) {
        UiBotModel dynamicForm = UiBotModel.emptyUiBotModel();
        dynamicForm.setExecuteContext(JsonUtil.objectToJavaObject(executeContext,
                new TypeReference<UiBotExecuteContext>() {
                }));
//        dynamicForm.setPageData(new HashMap<>());
        //数据源
        long start = System.currentTimeMillis();
        QueryResultSet queryResultSet = BuildDataSource(executeContext, mainAction, dynamicForm, apiRequest);
        if (null != queryResultSet && queryResultSet.getMainQueryResult() != null && mainAction.getPageInfo() != null) {
            if (queryResultSet.getMainQueryResult().isHasNext()) {
                mainAction.setUseHasNext(true);
            }
        }
        Long firstBacklogId = executeContext.getFirstBacklogId();
        log.debug("[{}]读取数据，cost：{} ms", firstBacklogId, System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        //布局
        BuildLayout(apiRequest, executeContext, queryResultSet, mainAction, pageDefines, dynamicForm);
        log.debug("[{}]创建布局，cost：{} ms", firstBacklogId, System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        //规则
        BuildRule(apiRequest, executeContext, mainAction, dynamicForm, queryResultSet);
        BuildStyle(executeContext, dynamicForm);
        log.debug("[{}]创建规则，cost：{} ms", firstBacklogId, System.currentTimeMillis() - start);
        // 设置页面其他信息
        BuildPageInfo(executeContext, mainAction, dynamicForm);

        BuildPageData(dynamicForm, queryResultSet);
        start = System.currentTimeMillis();
        //设置提交的按钮
        BuildActions(executeContext, mainAction, dynamicForm);
        // 设置页面需要的一些附加变量
        PcUiBotBuilderUtils.BuildVariables(dynamicForm);
        log.debug("[{}]创建提交，cost：{} ms", firstBacklogId, System.currentTimeMillis() - start);

        if (dynamicForm.getFinished() != null && dynamicForm.getFinished() && !CollectionUtils.isEmpty(dynamicForm.getRules())
                //过滤掉签核类型任务卡
                && !TaskStringUtil.isBizApproval(executeContext.getPattern(), executeContext.getCategory())) {
            // 任务的追踪中、已完成、项目的待处理等需要去掉编辑类的规则
            this.filterEditRules(dynamicForm.getRules());
        }
        return dynamicForm;
    }


    protected void BuildPageData(UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        if (queryResultSet != null
                && queryResultSet.getMainQueryResult() != null
                && StringUtils.hasText(queryResultSet.getMainQueryResult().getDataSourceName())) {
            Map<String, Object> result = queryResultSet.getPageData();
            for (String key : result.keySet()) {
                if (!dynamicForm.getPageData().containsKey(key)) {
                    dynamicForm.getPageData().put(key, result.get(key));
                }
            }
            dynamicForm.setPageDataIndex(JsonUtil.objectToJavaObject(queryResultSet.getPageDataIndex(),
                    new TypeReference<UiBotPageData>() {
                    }));
            dynamicForm.setPageDataKeys(JsonUtil.objectToJavaObject(queryResultSet.getPageDataKeys(),
                    new TypeReference<UiBotPageData>() {
                    }));
//            dynamicForm.setPageCountSize(queryResultSet.getMainQueryResult().size());
        } else {
//            dynamicForm.setPageCountSize(0);
        }
    }


    protected void BuildPageInfo(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm) {
        /*dynamicForm.setTitle(pageDefine.getTitle());
        dynamicForm.setDescription(pageDefine.getDescription());
        dynamicForm.setIcon(pageDefine.getIcon());
        dynamicForm.setSubTitle(pageDefine.getSubTitle());
        //todo:需要删除的代码
        Map<String, Object> content = new HashMap<>();
        content.put("businessUnit", executeContext.getBusinessUnit());
        content.put("pattern", executeContext.getPattern());
        content.put("category", executeContext.getCategory());
        if (executeContext.getRelationTag() != null) {
            content.put("identity", executeContext.getRelationTag().getIdentity());
            content.put("activityId", executeContext.getRelationTag().getActivityId());
        }
        content.put("activityParameter", executeContext.getActivityParameter());
        //增加dataStateCode，方便前端判断当前状态是待处理还是已完成
        content.put("dataStateCode", pageDefine.getDataStateCode());
        dynamicForm.setContent(content);*/
    }

    /**
     * 创建数据源
     */
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        if (pageDefine == null) {
            return null;
        }
        PcUiBotExecuteContext pageDefineContext = pageDefine.getExecuteContext();
        //如果是后端分页，设置fromAdsc为true，atdm中会通过adsc查询
        if (Boolean.TRUE.equals(pageDefine.getEnableBackEndPaging()) && Objects.nonNull(pageDefineContext)) {
            pageDefineContext.setFromAdsc(true);
        }
        //没有分页，设置默认分页信息
        if (Objects.nonNull(pageDefineContext) && Boolean.TRUE.equals(pageDefineContext.getFromAdsc()) && Objects.isNull(pageDefine.getPageInfo())) {
            PcUiBotPageInfo pageInfo = new PcUiBotPageInfo();
            pageInfo.setPageNo(1);
            pageInfo.setPageSize(50);
            pageDefine.setPageInfo(pageInfo);
        }
        // 获取数据源的数据
        QueryResultSet queryResultSet = this.queryByPagedefineWithMetaData(pageDefineContext, pageDefine, apiRequest);

        // 根据设计器配置的数据状态条件过滤数据--应用api不支持过滤时此方法会过滤出实际数据，支持情况下已经是筛选后的数据
        this.filterQueryResultSet(queryResultSet, pageDefine);

        appendFixedParameters(queryResultSet, pageDefine);

        return queryResultSet;
    }

    private void filterQueryResultSet(QueryResultSet queryResultSet, T pageDefine) {
        if (queryResultSet == null) {
            return;
        }
        List<QueryResult> queryResults = queryResultSet.getQueryResults();
        if (CollectionUtils.isEmpty(queryResults)) {
            return;
        }
        PcUiBotTmDataFilter dataFilter = pageDefine.getDataFilter();
        if (dataFilter == null) {
            return;
        }
        List<PcUiBotTmFilterCondition> apiCondition = dataFilter.getApiCondition();
        if (CollectionUtils.isEmpty(apiCondition)) {
            return;
        }
        Map<String, String> filterMap = new HashMap<>();
        apiCondition.forEach(r -> {
            //服务端 过滤
            String conName = r.getName();
            if (conName.contains(".")) {
                //指定过滤条件加在哪个参数中
                String[] conNames = conName.split("\\.");
                filterMap.put(conNames[1], StringUtil.valueOf(r.getValue()));
            } else {
                filterMap.put(r.getName(), StringUtil.valueOf(r.getValue()));
            }
        });
        for (QueryResult queryResult : queryResults) {
            List<Map<String, Object>> data = queryResult.getData();
            if (CollectionUtils.isEmpty(data)) {
                continue;
            }
            data = data.stream().filter(r ->
                            filterMap.keySet().stream().allMatch(key -> {
                                String value = filterMap.get(key);
                                if (!r.containsKey(key)) {
                                    // 移除 过滤条件的字段不在查询后的数据中
                                    return true;
                                }
                                if ("true".equals(value)) {
                                    return Objects.equals(r.get(key), true);
                                } else if ("false".equals(value)) {
                                    return Objects.equals(r.get(key), false);
                                } else {
                                    return Objects.equals(r.get(key), value);
                                }
                            }))
                    .collect(Collectors.toList());
            queryResult.setData(data);
            queryResult.setTotalResults(data.size());
        }
    }

    public QueryResultSet queryByPagedefineWithMetaData(PcUiBotExecuteContext executeContext, T pageDefine, ApiRequest apiRequest) {
        if (executeContext == null || pageDefine.getDataSourceSet() == null) {
            return QueryResultSet.empty();
        }
        Map<String, Object> body = new HashMap<>();
        body.put("dataSourceSetDTO", pageDefine.getDataSourceSet());
        PcUiBotExecuteContext pcUiBotExecuteContext = JsonUtil.objectToJavaObject(executeContext, PcUiBotExecuteContext.class);
        if (UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(executeContext.getPageCode())) {
            pcUiBotExecuteContext.setPageCode("project-detail");
        } else {
            pcUiBotExecuteContext.setPageCode("task-detail");
        }
        body.put("executeContext", pcUiBotExecuteContext);
        body.put("parameter", pageDefine.getParameter());
        body.put("settings", pageDefine.getSettings());
        if (pageDefine.getPageInfo() != null) {
            body.put("pageInfo", pageDefine.getPageInfo());
        }
        if (pageDefine.getSortInfo() != null && !pageDefine.getSortInfo().isEmpty()) {
            body.put("sortInfo", pageDefine.getSortInfo());
        }
        if (pageDefine.getSearchInfo() != null && !pageDefine.getSearchInfo().isEmpty()) {
            body.put("searchInfo", pageDefine.getSearchInfo());
        }
        if (executeContext.getTmActivityId().contains(MockV2Constants.MULTI_SPEED_TM_ACTIVITY_ID)) {
            MockV2Model mockV2Model = mockV2Service.getMockV2Model(MockV2Constants.MULTI_SPEED_TM_ACTIVITY_ID);
            if (ObjectUtils.isNotEmpty(mockV2Model)) {
                return mockV2Model.getData();
            }
        }
        if ((executeContext.getTmActivityId().contains(MockV2Constants.SINGLE_SPEED_TM_ACTIVITY_ID)
                || executeContext.getTmActivityId().contains(MockV2Constants.SINGLE_SPEED_TM_ACTIVITY_ID_2))
                && !"A20240409174845_lcdp_task_0004".equalsIgnoreCase(executeContext.getTmActivityId())) {
            MockV2Model mockV2Model = mockV2Service.getMockV2Model(MockV2Constants.SINGLE_SPEED_TM_ACTIVITY_ID);
            if (ObjectUtils.isNotEmpty(mockV2Model)) {
                return mockV2Model.getData();
            }
        }
        //设计器数据源大于1，才走多数据源
        String dataSourceName = AppRequestContext.getContextEntity().getDataSourceName();
        if (StringUtil.isNotEmpty(dataSourceName)) {
            UiBotModelDesignerMultipleDataSources.handleDataSourceParas(pageDefine.getDataSourceSet(), apiRequest);
        }
        return digiwinAtdmProxyService.queryWithMetaData(executeContext.getLocale(),
                executeContext.getAuthoredUser().getToken(),
                JsonUtil.javaObjectToJsonString(body),
                executeContext.getAuthoredUser().getTenantId());
    }

    /**
     * 创建布局
     */
    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, List<T> pageDefines, UiBotModel dynamicForm) {
        // 填充卡片列表分页配置
        queryInfoSetService.buildLayoutDsl(executeContext, queryResultSet, pageDefine);
//        UiBotModel dynamicFormByTag = null;//pageBuilder.createPage(executeContext, queryResultSet, pageDefine);
//        dynamicForm.setLayout(dynamicFormByTag.getLayout());
//        dynamicForm.setPageData(dynamicFormByTag.getPageData());
//        dynamicForm.getRules().addAll(dynamicFormByTag.getRules());
////        dynamicForm.getStyle().putAll(dynamicFormByTag.getStyle());
//        dynamicForm.setStyle(dynamicFormByTag.getStyle());
    }

    /**
     * 创建业务规则
     */
    protected void BuildRule(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm, QueryResultSet queryResultSet) {

    }

    /**
     * 创建业务规则
     */
    protected void BuildStyle(PcUiBotExecuteContext executeContext, UiBotModel dynamicForm) {

    }

    /**
     * 添加提交的逻辑
     */
    protected void BuildActions(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm) {
        if (requireRenderActions(pageDefine, dynamicForm)) {
            if (!CollectionUtils.isEmpty(pageDefine.getSubmitActions())) {
                dynamicForm.setActions(JsonUtil.objectToJavaObject(pageDefine.getSubmitActions(),
                        new TypeReference<List<UiBotAction>>() {
                        }));
            }
        }
    }

    /**
     * 是否需要渲染提交按钮
     *
     * @return
     */
    private boolean requireRenderActions(T pageDefine, UiBotModel dynamicForm) {
        PcUiBotDataSourceSetDTO dataSourceSetDTO = pageDefine.getDataSourceSet();
        // 没有配置数据源，不关心是否渲染提交按钮
        if (null == dataSourceSetDTO || CollectionUtils.isEmpty(dataSourceSetDTO.getDataSourceList())) {
            return true;
        }
        Map<String, Object> pageData = dynamicForm.getPageData();
        // 有配置数据源，但没有相关业务数据，不需要渲染提交按钮
        if (CollectionUtils.isEmpty(pageData)) {
            return false;
        }

        for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSetDTO.getDataSourceList()) {
            Object dataObj = pageData.get(dataSourceDTO.getName());
            if (null == dataObj) {
                continue;
            }
            // 不是集合，返回true
            if (!(dataObj instanceof Collection)) {
                return true;
            }
            // 是非空集合，返回true
            else if (!CollectionUtils.isEmpty((Collection) dataObj)) {
                return true;
            }
        }
        return false;
    }

    public void filterEditRules(List<UiBotRule> rules) {
        // 去掉只有在可编辑时才起作用的规则
        // 非编辑类：!x.containsKey("scope") || !Objects.equals("EDIT", x.get("scope")
        // 编辑类：x.containsKey("scope") && Objects.equals("EDIT", x.get("scope")
        rules.removeIf(rule -> Objects.equals("EDIT", rule.getScope()));
    }

//    @Override
//    public List<DynamicLayout> createTreePage(ExecuteContext executeContext, T PageDefine){
//        return null;
//    }

    /**
     * 在数据源数据中添加固定参数，例如edit_type=1
     *
     * @param queryResultSet 数据源数据
     * @param pageDefine     页面定义
     */
    protected void appendFixedParameters(QueryResultSet queryResultSet, T pageDefine) {
        if (queryResultSet == null) {
            return;
        }
        appendFixedParameters(queryResultSet.getPageData(), pageDefine);
    }

    /**
     * 在数据源数据中添加固定参数，例如edit_type=1
     *
     * @param pageData   页面数据
     * @param pageDefine 页面定义
     */
    protected void appendFixedParameters(Map<String, Object> pageData, T pageDefine) {
        if (CollectionUtils.isEmpty(pageData)) {
            return;
        }
        appendEditTypeParam(pageData, pageDefine);
    }

    /**
     * 增加edit_type=1参数
     *
     * @param pageData   页面数据
     * @param pageDefine 页面定义
     */
    protected void appendEditTypeParam(Map<String, Object> pageData, T pageDefine) {
        List<PcUiBotSubmitAction> submitActions = pageDefine.getSubmitActions();
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }
        // 若没有combine组合操作，则无需增加edit_type=1参数
        boolean noneCombineSubmitAction = submitActions.stream()
                .noneMatch(submitAction -> PcUiBotActivityConstants.TmActionType.COMBINE.equals(submitAction.getType()));
        if (noneCombineSubmitAction) {
            return;
        }
        for (Object rowData : pageData.values()) {
            if (rowData instanceof List) {
                List<Map<String, Object>> rowDataList = CastUtils.cast(rowData);
                for (Map<String, Object> rowDataMap : rowDataList) {
                    rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
                }
            } else if (rowData instanceof Map) {
                Map<String, Object> rowDataMap = CastUtils.cast(rowData);
                rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
            }
        }
    }

    protected QueryResultSet queryByActivityQueryDTO(
            PcUiBotExecuteContext executeContext, PcUiBotDataSourceSetDTO dataSourceSet,
            Map<String, Object> parameter, PcUiBotPageInfo pageInfo, List<Map> sortInfo,
            List<Map> searchInfo) {
        if (dataSourceSet == null) {
            return QueryResultSet.empty();
        }
        Map<String, Object> body = new HashMap<>();
        body.put("dataSourceSetDTO", dataSourceSet);
        body.put("executeContext", executeContext);
        body.put("parameter", parameter);
        if (pageInfo != null) {
            body.put("pageInfo", pageInfo);
        }
        if (sortInfo != null && sortInfo.size() > 0) {
            body.put("sortInfo", sortInfo);
        }
        if (searchInfo != null && searchInfo.size() > 0) {
            body.put("searchInfo", searchInfo);
        }
        return digiwinAtdmProxyService.queryByActivityQueryDTO(executeContext.getLocale(),
                executeContext.getAuthoredUser().getToken(),
                JsonUtil.javaObjectToJsonString(body),
                executeContext.getTenantId());
    }


    protected PcUiBotTaskPageDefine handleDefaultPageDefine(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        for (PcUiBotTaskPageDefine temp : pageDefines) {
            // 获取对应的数据状态下的数据量
            Integer total = this.queryDataSize(executeContext, temp);
            if (total != null && total > 0) {
                // 默认选中的页签
                temp.setIsDefault(true);
                temp.setRowSize(total);
                return temp;
            }
        }
        return mainAction;
    }

    protected PcUiBotTaskPageDefine handleDefaultPageDefineByFilter(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        for (PcUiBotTaskPageDefine temp : pageDefines) {
            // 获取对应的数据状态下的数据量
            T t = JsonUtil.objectToJavaObject(temp, new TypeReference<T>() {
            });
            // 获取数据源的数据
            QueryResultSet queryResultSet = this.queryByPagedefineWithMetaData(executeContext, t, apiRequest);
            // 根据设计器配置的数据状态条件过滤数据--应用api不支持过滤时此方法会过滤出实际数据，支持情况下已经是筛选后的数据
            this.filterQueryResultSet(queryResultSet, t);
            int total = Optional.ofNullable(queryResultSet).map(QueryResultSet::getQueryResults)
                    .filter(e -> !CollectionUtils.isEmpty(e))
                    .map(queryResults -> queryResults.get(0))
                    .map(QueryResult::getData).map(data -> data.size())
                    .orElse(0);
            if (total > 0) {
                // 默认选中的页签
                temp.setIsDefault(true);
                temp.setRowSize(total);
                return temp;
            }
        }
        return mainAction;
    }

    protected Integer queryDataSize(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        if (pageDefine == null) {
            return 0;
        }
        Map<String, Object> body = JsonUtil.objectToJavaObject(pageDefine, new TypeReference<Map<String, Object>>() {
        });
        body.put("executeContext", executeContext);
        return digiwinAtdmProxyService.getDataSize(executeContext.getLocale(),
                executeContext.getAuthoredUser().getToken(),
                body,
                executeContext.getTenantId());
    }


    @Override
    public UiBotModel createPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, T mainAction, List<T> pageDefines) {
        return null;
    }
}
