package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * StartProjectGeneralPageTemplate Description
 *
 * @author xujinc
 * @date 2024/01/09
 * @since
 */
@Service("startProjectGeneralPageTemplate")
public class StartProjectGeneralPageTemplate extends GeneralPageTemplate<PcUiBotTaskPageDefine> {
    private static final String SUPPORT_KEY = "start-project-general-page-template";

    @Override
    public String supportKey() {
        return SUPPORT_KEY;
    }

    /**
     * 添加提交的逻辑
     *
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    protected void BuildActions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        List<PcUiBotSubmitAction> submitActions = pageDefine.getSubmitActions();
        //把常量放在pageData中，特殊处理发起项目不用actionParams里的字段
        parseConstantSubmitActionParams(submitActions, dynamicForm.getPageData(), pageDefine);
        /**
         * 去除提交按钮的actionParams：
         * 1、提交时，将数据全部提交，不做筛选；
         * 2、actionParams在前面构建page步骤中，只用于将metadataField设置为可编辑；
         * 3、actionParams中的type为 TM_VARIABLE的字段，不去除
         */
        // wjw TODO: 2024/12/23 注释掉此段逻辑，因为 模型驱动手动发起项目，必须传递actionParams，否则会报错(无参数)
        if (!TaskStringUtil.isProjectCreateOfModelDriven(executeContext.getTmActivityId())) {
            removeActionParams(submitActions);
        }
        dynamicForm.setActions(JsonUtil.objectToJavaObject(submitActions, new TypeReference<List<UiBotAction>>() {
        }));
    }


    private void removeActionParams(List<PcUiBotSubmitAction> submitActions) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }

        for (PcUiBotSubmitAction submitAction : submitActions) {
            submitAction.setActionParams(null);
        }
    }


    private void parseConstantSubmitActionParams(List<PcUiBotSubmitAction> submitActions, Map<String, Object> pageData, PcUiBotPageDefine pageDefine) {
        if (CollectionUtils.isEmpty(submitActions) || CollectionUtils.isEmpty(pageData)) {
            return;
        }

        List<PcUiBotActionParameterMapping> actionParamList = submitActions.get(0).getActionParams();
        if (CollectionUtils.isEmpty(actionParamList)) {
            return;
        }
        String schema = parseFormSchema(pageDefine);
        for (PcUiBotActionParameterMapping actionParamMapping : actionParamList) {
            if ("CONSTANT".equals(actionParamMapping.getType())) {
                Map<String, Object> specify = (Map<String, Object>) pageData.get(schema);
                specify.put(actionParamMapping.getName(), actionParamMapping.getValue());
            }
        }
    }

    private String parseFormSchema(PcUiBotPageDefine pageDefine) {
        PcUiBotDataSourceSetDTO dataSourceSetDTO = pageDefine.getDataSourceSet();
        if (dataSourceSetDTO == null) {
            return "";
        }
        List<PcUiBotDataSourceDTO> dataSourceDTOList = dataSourceSetDTO.getDataSourceList();
        if (CollectionUtils.isEmpty(dataSourceDTOList)) {
            return "";
        }
        return dataSourceDTOList.get(0).getName();
    }
}