package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>功能描述：api 元数据处理 工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotApiMetadataUtil.java
 * @Author: wangjwc
 * @Date: created at 2023/7/3 17:31
 */
public class PcUiBotApiMetadataUtil {

    private static final String METADATA_LAST_NAME_GET = "get";
    private static final String METADATA_LAST_NAME_PROCESS = "process";
    private static final String METADATA_LAST_NAME_UPDATE = "update";
//    /**
//     * 执行使用元数据字段
//     *
//     * @return
//     */
//    public static List<MetadataField> showFieldsRange(ApiMetadata apiMetadata) {
//        String lastName = StringUtils.substringAfterLast(apiMetadata.getServiceName(), ".");
//        if (METADATA_LAST_NAME_GET.equals(lastName)) {
//            return apiMetadata.getResponseFields();
//        } else if (METADATA_LAST_NAME_PROCESS.equals(lastName)) {
//            return apiMetadata.getRequestFields();
//        }else if (METADATA_LAST_NAME_UPDATE.equals(lastName)) {
//            return apiMetadata.getRequestFields();
//        }
//        return apiMetadata.getResponseFields();
//    }


//    /**
//     * 编辑字段 确定映射字段
//     *
//     * @return
//     */
//    public static String editFieldsRangeType(ApiMetadata apiMetadata) {
//        String lastName = StringUtils.substringAfterLast(apiMetadata.getServiceName(), ".");
//        if (METADATA_LAST_NAME_GET.equals(lastName)) {
//            return "GET_ACTION_RESPONSE";
//        } else if (METADATA_LAST_NAME_PROCESS.equals(lastName)) {
//            return "GET_ACTION_REQUEST";
//        }else if (METADATA_LAST_NAME_UPDATE.equals(lastName)) {
//            return "GET_ACTION_REQUEST";
//        }
//        return "GET_ACTION_RESPONSE";
//    }


    /**
     * 获取路劲名称
     *
     * @param parentPathName
     * @param metadataField
     * @return
     */
    public static String pathFieldName(String parentPathName, PcUiBotMetadataField metadataField) {
        String pathFieldName;
        if (StringUtils.isBlank(parentPathName)) {
            pathFieldName = metadataField.getName();
        } else {
            pathFieldName = parentPathName + "." + metadataField.getName();
        }
        return pathFieldName;
    }


    public static void flatMetaData(PcUiBotApiMetadata apiMetadata) {
        if (apiMetadata == null) {
            return;
        }
        if (CollectionUtils.isEmpty(apiMetadata.getResponseFields())) {
            return;
        }
        Map<String, PcUiBotMetadataField> fieldMap = new HashMap<>();
        apiMetadata.setResponseFieldMap(fieldMap);
        for (PcUiBotMetadataField rootField : apiMetadata.getResponseFields()) {
            fieldMap.put(rootField.getName(), rootField);
            rootField.setPath(null);
            rootField.flatMetaData(null);
        }
        fieldMap = new HashMap<>();
        apiMetadata.setRequestFieldMap(fieldMap);
        if (apiMetadata.getRequestFields() != null) {
            for (PcUiBotMetadataField rootField : apiMetadata.getRequestFields()) {
                fieldMap.put(rootField.getName(), rootField);
                rootField.setPath(null);
                rootField.flatMetaData(null);
            }
        }
    }

    public static void flatMetaDataNotFlatPath(PcUiBotApiMetadata apiMetadata) {
        if (CollectionUtils.isEmpty(apiMetadata.getResponseFields())) {
            return;
        }
        Map<String, PcUiBotMetadataField> fieldMap = new HashMap<>();
        apiMetadata.setResponseFieldMap(fieldMap);
        for (PcUiBotMetadataField rootField : apiMetadata.getResponseFields()) {
            fieldMap.put(rootField.getName(), rootField);
            rootField.setPath(rootField.getPath());
            rootField.flatMetaDataNotFlatPath(null);
        }
        fieldMap = new HashMap<>();
        apiMetadata.setRequestFieldMap(fieldMap);
        if (apiMetadata.getRequestFields() != null) {
            for (PcUiBotMetadataField rootField : apiMetadata.getRequestFields()) {
                fieldMap.put(rootField.getName(), rootField);
                rootField.setPath(rootField.getPath());
                rootField.flatMetaDataNotFlatPath(null);
            }
        }
    }

    public static List<String> getDataKeys(List<PcUiBotMetadataField> metadataFields) {
        if (CollectionUtils.isEmpty(metadataFields)) {
            return Collections.emptyList();
        }

        List<String> dataKeys = metadataFields.stream()
                .filter(PcUiBotMetadataField::isBusinessKey)
                .map(PcUiBotMetadataField::getName)
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataKeys)) {
            dataKeys = metadataFields.stream()
                    .filter(metadataFieldDTO -> "true".equals(metadataFieldDTO.getDataKey()))
                    .map(PcUiBotMetadataField::getName)
                    .collect(Collectors.toList());
        }
        return dataKeys;
    }


    /**
     * 根据字段名称，获取其对应的元数据
     *
     * @param metadataName
     * @param apiMetadata
     * @return
     */
    public static PcUiBotApiMetadata getApiMetadataByMetaName(String metadataName, PcUiBotApiMetadata apiMetadata) {
        if (CollectionUtils.isEmpty(apiMetadata.getResponseFields())) {
            return apiMetadata;
        }
        PcUiBotApiMetadata subApiMetadata = new PcUiBotApiMetadata();
        subApiMetadata.setServiceName(apiMetadata.getServiceName());
        subApiMetadata.setActionId(apiMetadata.getActionId());
        PcUiBotMetadataField metadataField = apiMetadata.getResponseFields().get(0);
        if ("object".equals(metadataField.getDataType()) && metadataName.equals(metadataField.getName())) {
            subApiMetadata.setResponseFields(apiMetadata.getResponseFields());
            subApiMetadata.setResponseFieldMap(apiMetadata.getResponseFieldMap());
            return subApiMetadata;
        }
        if (!CollectionUtils.isEmpty(metadataField.getSubFields())) {
            for (PcUiBotMetadataField subMetadataField : metadataField.getSubFields()) {
                if ("object".equals(subMetadataField.getDataType()) && metadataName.equals(subMetadataField.getName())) {
                    //subApiMetadata.setResponseFields(subMetadataField.getSubFields());
                    //subApiMetadata.setResponseFieldMap(subMetadataField.getFieldMap());
                    subMetadataField.setPath(null);
                    subApiMetadata.setResponseFields(Collections.singletonList(subMetadataField));
                    Map<String, PcUiBotMetadataField> responseFieldMap = new HashMap<>();
                    responseFieldMap.put(metadataName, metadataField.getFieldMap().get(metadataName));
                    subApiMetadata.setResponseFieldMap(responseFieldMap);
                    break;
                }
                if (CollectionUtils.isEmpty(subApiMetadata.getResponseFields())) {
                    getsubApiMetadata(metadataName, subApiMetadata, subMetadataField);
                }
            }
        }
        return subApiMetadata;
    }

    private static void getsubApiMetadata(String metadataName, PcUiBotApiMetadata subApiMetadata, PcUiBotMetadataField metadataField) {
        if (!CollectionUtils.isEmpty(metadataField.getSubFields())) {
            for (PcUiBotMetadataField subMetadataField : metadataField.getSubFields()) {
                if ("object".equals(subMetadataField.getDataType()) && metadataName.equals(subMetadataField.getName())) {
                    subApiMetadata.setResponseFields(subMetadataField.getSubFields());
                    subApiMetadata.setResponseFieldMap(subMetadataField.getFieldMap());
                    break;
                }
            }
        }
    }

//    /**
//     * 根据元数据构建数据
//     *
//     * @param apiMetadata
//     * @return
//     */
//    public static QueryResult buildQueryResultByMetadata(PcUiBotPageDefine pageDefine,
//                                                         PcUiBotApiMetadata apiMetadata) {
//        PcUiBotApiMetadataCollection apiMetadataCollection = PcUiBotApiMetadataCollection.empty();
//        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
//        List<PcUiBotMetadataField> responseFields = apiMetadata.getResponseFields();
//        PcUiBotDataSourceSetDTO dataSourceSet = pageDefine.getDataSourceSet();
//        dataSourceSet.getFirstDataQuery();
//        String dataSourceName = dataSourceSet.getMainDatasource();
//        PcUiBotTmActivity taskDefinition = UiBotUtils.getPreviewParam().getTaskDefinition();
//        List<String> dataKeys = PcUiBotApiMetadataUtil.getDataKeys(responseFields);
//        // mock数据
//        PcUiBotMetadataField firstResponseMetadata = responseFields.get(0);
//        List<Map<String, Object>> data = new ArrayList<>();//AthenaMockConfig.mockRowDataList(firstResponseMetadata);
//        // 数据体
//        Map<String, Object> dataMap = new HashMap<>();
//        dataMap.put(dataSourceName, data);
//        Map<String, PcUiBotTmQueryAction> queryActionMap = taskDefinition.getDataSources();
//        PcUiBotTmQueryAction queryAction = queryActionMap.get(dataSourceName);
//        Boolean single = queryAction.getNotArray();
//        // 参考atdm的com.digiwin.athena.atdm.datasource.datasource.DataSourceBase#queryMetaData
//        Integer limit = queryAction.getLimit();
//        if (BooleanUtil.isTrue(single)) {
//            limit = 1;
//            firstResponseMetadata.setArray(false);
//        } else if (single == null) {
//            single = !firstResponseMetadata.isArray();
//            limit = 1;
//        }
//        // 分页数据
//        PcUiBotPageInfo pageInfo = pageDefine.getPageInfo();
//
//        QueryResult queryResult = QueryResult.withData(dataSourceName, dataMap, pageInfo);
//        queryResult.setDataSourceName(dataSourceName);
//        queryResult.setHasNext(pageInfo != null && pageInfo.isHasNext());
//        queryResult.setTotalResults(10);
//        queryResult.setSingle(single);
//        queryResult.setLimit(limit);
//        queryResult.withMetaData(apiMetadataCollection);
//        queryResult.setDataKeys(dataKeys);
//        queryResult.initDataKeyIndex();
//        return queryResult;
//    }
}
