package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.io.UnsupportedEncodingException;
import java.util.*;

/**
 * <p>功能描述：附件工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotAttachmentUtil.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 14:59
 */
public final class PcUiBotAttachmentUtil {
    public static boolean isPageCodeEnableAttachment(String pageCode) {
        if (UiBotDesignerService.PAGECODE_TASK_DETAIL.equals(pageCode)
                || UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(pageCode)
                || UiBotDesignerService.PAGECODE_BASIC_DATA.equals(pageCode)) {
            return true;
        }

        return false;
    }

    public static void addDefaultAttachmentDataSourceProcess(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        if (tmActivity.getAttachment() == null) {
            return;
        }
        for (Map.Entry<String, PcUiBotTmQueryAction> stringTmQueryActionEntry : tmActivity.getDataSources().entrySet()) {
            PcUiBotTmQueryAction tmQueryAction = stringTmQueryActionEntry.getValue();
            List<PcUiBotTmDataProcess> allProcessors = tmQueryAction.getDataProcessors();
            if (allProcessors == null) {
                allProcessors = new ArrayList<>();
                tmQueryAction.setDataProcessors(allProcessors);
            }
            /**
             * modify by majianfu， 2021/09/10
             * 必须使用tmActivity.getDataProcessor。
             * activityConfigs中若显式配置附件processor  applyTo task-detail，但是在
             * {@link com.digiwin.athena.uibot.activity.ConvertTmActivityUtils#processDataProcessor}中，若发现当前是【非task-detail】，会将附件processor去掉。
             * 使用tmQueryAction.getDataProcessor的话，将导致该处会将附件processor重新加上。
             */
            Optional<PcUiBotTmDataProcess> processInTmActivityOpt = getAlreadyExistAttachmentProcessorConfig(tmActivity.getDataProcessors());
            Optional<PcUiBotTmDataProcess> processInTmQueryActionOpt = getAlreadyExistAttachmentProcessorConfig(tmQueryAction.getDataProcessors());
            /**
             * 若活动定义中定义了attachment processor，不管适不适用于当前pageCode，都不会再动态添加全局attachment processor
             */
            // tmActivity、tmQueryAction中【同时存在attachment processor】，说明applyTo适用于当前pageCode
            if (processInTmActivityOpt.isPresent() && processInTmQueryActionOpt.isPresent()) {
                PcUiBotAttachmentConfigInfo attachmentConfigInfo = (PcUiBotAttachmentConfigInfo) processInTmQueryActionOpt.get().getParas();
                if (null == attachmentConfigInfo) {
                    attachmentConfigInfo = tmActivity.getAttachment();
                }

                PcUiBotAttachmentConfigInfo availableAttachmentConfigInfo = getAvailableAttachmentConfigInfo(attachmentConfigInfo);

                PcUiBotAttachmentConfigInfo attachConfigInfoCopy = new PcUiBotAttachmentConfigInfo();
                if (null != availableAttachmentConfigInfo) {
                    attachConfigInfoCopy = JsonUtil.objectToJavaObject(availableAttachmentConfigInfo, PcUiBotAttachmentConfigInfo.class);
                }
                encodeDmcAccountPwd(attachConfigInfoCopy.getConfigs());
                processInTmQueryActionOpt.get().setParas(attachConfigInfoCopy);
            }
            // tmActivity中【不存在attachment processor】，则向tmQueryAction中添加attachment processor
            else if (!processInTmActivityOpt.isPresent()) {
                addAttachmentDataSourceProcess(executeContext, tmActivity, allProcessors);
            }
        }

    }

    private static void encodeDmcAccountPwd(List<PcUiBotAttachmentConfig> attachmentConfigList) {
        if (!CollectionUtils.isEmpty(attachmentConfigList)) {
            for (PcUiBotAttachmentConfig attachmentConfig : attachmentConfigList) {
                if (null != attachmentConfig) {
                    encodeDmcAccountPwd(attachmentConfig.getDmcAccount());
                }
            }
        }
    }

    private static void encodeDmcAccountPwd(PcUiBotAttachmentConfig.DmcAccount dmcAccount) {
        if (null == dmcAccount || dmcAccount.isPasswordAlreadyEncoded() || StringUtils.isBlank(dmcAccount.getPassword())) {
            return;
        }

        dmcAccount.setPassword(encode(dmcAccount.getPassword()));
        dmcAccount.setPasswordAlreadyEncoded(true);
    }

    private static String encode(String text) {
        byte[] textByte = new byte[0];
        try {
            textByte = text.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return Base64.getEncoder().encodeToString(textByte);
    }

    public static void appendEffectAfterSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        if (null == tmActivity.getPages()) {
            return;
        }

        // 优先使用pages下第一个DataState的submitActions
        List<PcUiBotTmAction> submitActions = null;
        if (!CollectionUtils.isEmpty(tmActivity.getPages().getDataStates())) {
            submitActions = tmActivity.getPages().getDataStates().get(0).getSubmitActions();
        }
        // 再使用pages.submitActions
        if (CollectionUtils.isEmpty(submitActions)) {
            submitActions = tmActivity.getPages().getSubmitActions();
        }

        appendEffectAfterSubmitAction(executeContext, tmActivity.getAttachment(), submitActions);
    }

    public static void appendEffectAfterSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotAttachmentConfigInfo attachmentConfigInfoParam, List<PcUiBotTmAction> submitActions) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }

        // 优先比较combineActions
        for (PcUiBotTmAction submitAction : submitActions) {
            if (!CollectionUtils.isEmpty(submitAction.getCombineActions())) {
                appendEffectAfterSubmitAction(executeContext, attachmentConfigInfoParam, submitAction.getCombineActions());
            }
        }

        PcUiBotAttachmentConfigInfo attachmentConfigInfo = getAvailableAttachmentConfigInfo(executeContext, attachmentConfigInfoParam);
        // attachConfigInfo.enable没配置或者值为false，则不启用附件列
        if (null == attachmentConfigInfo || BooleanUtils.isFalse(attachmentConfigInfo.getEnable()) || CollectionUtils.isEmpty(attachmentConfigInfo.getConfigs())) {
            return;
        }

        // <submitActionId， attachment targetSchema list>
        Map<String, List<String>> map = new HashMap<>();
        String submitVariableName = null;
        for (PcUiBotAttachmentConfig attachmentConfig : attachmentConfigInfo.getConfigs()) {
            PcUiBotAttachmentConfig.EffectAfterSubmit effectAfterSubmit = attachmentConfig.getEffectAfterSubmit();
            if (null == effectAfterSubmit) {
                continue;
            }

            submitVariableName = effectAfterSubmit.getSubmitVariableName();
            List<String> applyToSubmitActionIds = effectAfterSubmit.getApplyToSubmitActionId();

            if (StringUtils.isNotBlank(submitVariableName) && !CollectionUtils.isEmpty(applyToSubmitActionIds)) {
                for (String applyToSubmitActionId : applyToSubmitActionIds) {
                    List<String> submitActionIdList = map.computeIfAbsent(applyToSubmitActionId, key -> new ArrayList<>());
                    submitActionIdList.add(attachmentConfig.getTargetSchema());
                }
            }
        }

        for (PcUiBotTmAction submitAction : submitActions) {
            List<String> targetSchemaList = map.get(submitAction.getActionId());
            if (CollectionUtils.isEmpty(targetSchemaList)) {
                continue;
            }

            PcUiBotTmAction effectAfterSubmitAction = null;
            if (null != submitAction.getAttachActions()) {
                effectAfterSubmitAction = submitAction.getAttachActions().stream()
                        .filter(attachAction -> StringUtils.equals("upload-or-save-attachment", attachAction.getActionId()))
                        .findFirst()
                        .orElse(null);
            } else {
                submitAction.setAttachActions(new ArrayList<>());
            }

            if (null == effectAfterSubmitAction) {
                effectAfterSubmitAction = createEffectAfterSubmitAction();
                submitAction.getAttachActions().add(effectAfterSubmitAction);
            }

            if (null == effectAfterSubmitAction.getExtendParas()) {
                effectAfterSubmitAction.setExtendParas(new HashMap<>());
                effectAfterSubmitAction.getExtendParas().put("submitVariableName", submitVariableName);
                effectAfterSubmitAction.getExtendParas().put("targetSchemaList", targetSchemaList);
            } else {
                effectAfterSubmitAction.getExtendParas().put("submitVariableName", submitVariableName);
                List<String> targetSchemaListTmp = (List<String>) effectAfterSubmitAction.getExtendParas().get("targetSchemaList");
                if (null == targetSchemaListTmp) {
                    targetSchemaListTmp = targetSchemaList;
                    effectAfterSubmitAction.getExtendParas().put("targetSchemaList", targetSchemaListTmp);
                } else {
                    targetSchemaListTmp.addAll(targetSchemaList);
                }
            }
        }
    }

    private static Optional<PcUiBotTmDataProcess> getAlreadyExistAttachmentProcessorConfig(List<PcUiBotTmDataProcess> tmDataProcesses) {
        if (CollectionUtils.isEmpty(tmDataProcesses)) {
            return Optional.empty();
        }
        Optional<PcUiBotTmDataProcess> attachmentProcessorOptional = tmDataProcesses.stream()
                .filter(processor -> StringUtils.equals(processor.getServiceName(), PcUiBotActivityConstant.ATTACHMENT_DS_SERVICE_INSTANCE_NAME))
                .findAny();
        return attachmentProcessorOptional;
    }

    public static void addAttachmentDataSourceProcess(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, List<PcUiBotTmDataProcess> allProcessors) {
        PcUiBotAttachmentConfigInfo attachmentConfigInfo = getAvailableAttachmentConfigInfo(executeContext, tmActivity.getAttachment());
        // attachConfigInfo.enable没配置或者值为false，则不启用附件列
        if (null == attachmentConfigInfo || BooleanUtils.isFalse(attachmentConfigInfo.getEnable()) || CollectionUtils.isEmpty(attachmentConfigInfo.getConfigs())) {
            return;
        }

        // 添加附件全局数据处理器
        PcUiBotTmDataProcess attachmentProcessor = new PcUiBotTmDataProcess();
        attachmentProcessor.setType("service");
        attachmentProcessor.setServiceName(PcUiBotActivityConstant.ATTACHMENT_DS_SERVICE_INSTANCE_NAME);
        attachmentProcessor.setActivePoint(PcUiBotConstants.DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED);

        PcUiBotAttachmentConfigInfo attachConfigInfoCopy = JsonUtil.objectToJavaObject(attachmentConfigInfo, PcUiBotAttachmentConfigInfo.class);
        encodeDmcAccountPwd(attachConfigInfoCopy.getConfigs());
        attachmentProcessor.setParas(attachConfigInfoCopy);

        allProcessors.add(attachmentProcessor);
    }

    private static PcUiBotAttachmentConfigInfo getAvailableAttachmentConfigInfo(PcUiBotExecuteContext executeContext, PcUiBotAttachmentConfigInfo attachmentConfigInfo) {
        // pageCode为project-detail，task-detail才需要添加附件处理器
        String pageCode = executeContext.getPageCode();
        if (!isPageCodeEnableAttachment(pageCode)) {
            return null;
        }

        return getAvailableAttachmentConfigInfo(attachmentConfigInfo);
    }

    private static PcUiBotAttachmentConfigInfo getAvailableAttachmentConfigInfo(PcUiBotAttachmentConfigInfo attachmentConfigInfo) {
        // attachConfigInfo.enable没配置或者值为false，则不启用附件列
        if (null == attachmentConfigInfo || BooleanUtils.isFalse(attachmentConfigInfo.getEnable())) {
            return null;
        }

        PcUiBotAttachmentConfigInfo attachmentConfigInfoCopy = new PcUiBotAttachmentConfigInfo();
        attachmentConfigInfoCopy.setEnable(Boolean.TRUE);

        List<PcUiBotAttachmentConfig> enabledAttachmentConfigs = Lists.newArrayList();
        // 过滤掉未启用的attachmentConfig
        for (PcUiBotAttachmentConfig attachmentConfig : attachmentConfigInfo.getConfigs()) {
            if (null != attachmentConfig && BooleanUtils.isTrue(attachmentConfig.getEnable())) {
                enabledAttachmentConfigs.add(attachmentConfig);
            }
        }

        for (int idx = 0; idx < enabledAttachmentConfigs.size(); idx++) {
            PcUiBotAttachmentConfig attachmentConfig = enabledAttachmentConfigs.get(idx);
            // 设置targetSchema
            if (StringUtils.isBlank(attachmentConfig.getTargetSchema())) {
                attachmentConfig.setTargetSchema("attachment" + idx);
            }
        }
        attachmentConfigInfoCopy.setConfigs(enabledAttachmentConfigs);

        return attachmentConfigInfoCopy;
    }

    /**
     * 是否能够编辑（上传和删除）附件列 pageCode是TASK_DETAIL、任务待办还未完成，才允许编辑附件列
     *
     * @param pageCode            pageCode
     * @param taskWithBacklogData 任务待办项
     * @return boolean
     */
    public static boolean isPageCodeAllowEdit(String pageCode, DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        // 任务卡第四层才允许编辑附件列
        boolean pageCodeIsTaskDetail = StringUtils.equals(UiBotDesignerService.PAGECODE_TASK_DETAIL, pageCode)
                || StringUtils.equals(UiBotDesignerService.PAGECODE_BASIC_DATA, pageCode)
                || StringUtils.equals(UiBotDesignerService.PAGECODE_EDIT_PAGE, pageCode);
        return pageCodeIsTaskDetail;

//        boolean isBacklogFinished = Optional.ofNullable(taskWithBacklogData).map(TaskWithBacklogData::getBacklog)
//                .filter(CollectionUtils::isNotEmpty).map(backlog -> backlog.get(0))
//                // finishedActionId不为空字符串，则认为待办已完成，不允许编辑附件列
//                .map(backlogData -> StringUtils.isNotBlank(backlogData.getFinishedActionId())).orElse(false);
//
//        return pageCodeIsTaskDetail && !isBacklogFinished;
    }

    public static PcUiBotAttachmentConfigInfo toAttachment(Object param) {
        if (null == param) {
            return new PcUiBotAttachmentConfigInfo();
        }

        if (param instanceof PcUiBotAttachmentConfigInfo) {
            return (PcUiBotAttachmentConfigInfo) param;
        } else {
            return JsonUtil.objectToJavaObject(param, PcUiBotAttachmentConfigInfo.class);
        }
    }

    /**
     * 创建用于上传保存or删除附件的Action，此类附件的上传和删除，只有在点击”提交“按钮后，才会生效
     */
    private static PcUiBotTmAction createEffectAfterSubmitAction() {
        PcUiBotTmAction action = new PcUiBotTmAction();
        action.setDispatch(false);
        action.setDispatch(false);
        action.setTitle("上传保存/删除附件");
        action.setType("UIBOT");
        action.setActionId("upload-or-save-attachment");
        action.setServiceName("upload-or-save-attachment");
        action.setExtendParas(new HashMap<>());
        action.getExtendParas().put("targetSchemaList", new ArrayList<>());

        return action;
    }
}
