package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import cn.hutool.core.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：基础资料工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotBaseDataUtil.java
 * @Author: wangjwc
 * @Date: created at 2024/1/19 10:01
 */
public class PcUiBotBaseDataUtil {

    private PcUiBotBaseDataUtil() {
    }

    /**
     * 是否为新增页面
     *
     * @param executeContext
     * @param pageDefine
     * @return
     */
    public static boolean isAddPage(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine) {
        return pageDefine.getParameter() == null
                || PcUiBotConstants.BaseDataEditType.ADD.equals(executeContext.getEditType());
    }

    /**
     * 设置默认值
     *
     * @param executeContext
     * @param pageDefine
     * @param dynamicForm
     */
    public static void setManageStatusDefaultValue(PcUiBotExecuteContext executeContext,
                                                   PcUiBotPageDefine pageDefine,
                                                   UiBotModel dynamicForm) {
        Object datasourceName = pageDefine.getDataSourceSet().getMainDatasource();
        Object pageDataObj = dynamicForm.getPageData().get(datasourceName);
        if (pageDataObj instanceof Map) {
            Map pageDataMap = (Map) pageDataObj;
            boolean addPage = isAddPage(executeContext, pageDefine);
            List<Map<String, Object>> rules = JsonUtil.objectToJavaObject(dynamicForm.getRules(), List.class);
            rules = CollectionUtils.isEmpty(rules) ? pageDefine.getRules() : rules;
            boolean existManageStatusDefaultValueRule = PcRuleService.exist(rules,
                    PcUiBotTagConstant.MANAGE_STATUS, PcUiBotConstants.RuleKeyType.DEFAULT_VALUE);
            // 新增界面且不存在默认值规则时，添加默认MANAGE_STATUS
            if (addPage && !existManageStatusDefaultValueRule) {
                putManageStatusIfAbsent(pageDataMap);
            }
        }
    }

    /**
     * 添加MANAGE_STATUS值，如果存在，则忽略
     *
     * @param rowDataMap
     */
    public static void putManageStatusIfAbsent(Map rowDataMap) {
        // 如果api返回的字段没有manage_status,默认赋值为N
        if (StringUtils.isBlank(MapUtil.getStr(rowDataMap, PcUiBotTagConstant.MANAGE_STATUS, ""))) {
            rowDataMap.put(PcUiBotTagConstant.MANAGE_STATUS, PcUiBotTagConstant.MANAGE_STATUS_DEFAULT);
        }
    }

}
