package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PcUiBotBuilderUtils {

//    @Autowired
//    private ThemeMapService themeMapService;

    /**
     * 页面需要的一些附加变量
     * 比如：交付设计器参数
     */
    private static final String UIBOT_VARIABLES = "uiBot__variables";

    /**
     * 相关变量赋值
     */
    public static void BuildVariables(UiBotModel dynamicForm) {
        List<PcUiBotActionVariable> variables = new ArrayList<>();
        List<PcUiBotSubmitAction> actions = JsonUtil.objectToJavaObject(dynamicForm.getActions(),
                new TypeReference<List<PcUiBotSubmitAction>>() {
                });
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        for (PcUiBotSubmitAction action : actions) {
            if (CollectionUtils.isEmpty(action.getActionParams())) {
                continue;
            }
            for (PcUiBotActionParameterMapping actionParam : action.getActionParams()) {
                if (!"CONSTANT".equals(actionParam.getType())) {
                    continue;
                }
                //对于TM_VARIABLE这类变量，name代表真正要传给api的变量名，value是指向的变量名
                PcUiBotActionVariable actionVariable = PcUiBotActionVariable.builder()
                        .variableKey(actionParam.getName())
                        .variableValue(actionParam.getValue())
                        .build();
                actionVariable.setVariableType(actionParam.getValueType());
                variables.add(actionVariable);
            }
        }
        List<PcUiBotActionVariable> pageDataVariables = (List<PcUiBotActionVariable>) dynamicForm.getPageData().get(UIBOT_VARIABLES);
        if (CollectionUtils.isEmpty(variables)) {
            return;
        }
        if (pageDataVariables == null) {
            dynamicForm.getPageData().put(UIBOT_VARIABLES, variables);
        } else {
            List<String> existVariableKeys = pageDataVariables.stream().map(PcUiBotActionVariable::getVariableKey).collect(Collectors.toList());
            variables.forEach(variable -> {
                if (!existVariableKeys.contains(variable.getVariableKey())) {
                    pageDataVariables.add(variable);
                }
            });
        }
    }

    /**
     * 初始化分页
     *
     * @param pageDefine
     * @param queryResultSet
     */
    public static void setTotalResultsDefault(PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet) {
        if (BooleanUtils.isTrue(pageDefine.getUseHasNext())
                && Objects.isNull(queryResultSet.getMainQueryResult().getTotalResults())) {
            queryResultSet.getMainQueryResult().setTotalResults(0);
        }
    }
}
