package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;


import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.text.MessageFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService.PC_PAGECODE_TASK_DETAIL;

/**
 * <p>功能描述：对tm返回的结果做版本转换</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ConvertTmActivityUtils.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 13:17
 */
public class PcUiBotConvertTmActivityUtils {

    //根据默认的方式来定义code
    //waiting 待处理
    //tracing 追踪中
    //completed 已完成
    //processing 处理中
    //异常排除
    static String[] solveStates = {"waitting", "tracing", "completed"};
    //一般任务的
    static String[] states = {"waitting", "completed"};


    public static void convert(String pageCode, String locale, PcUiBotTmActivity tmActivity) {
        //升级datastate
        updateTmActivity(pageCode, tmActivity);

        //处理process,把所有的处理器放到数据源上
        processDataProcessor(pageCode, tmActivity);

        setDataStateCode(tmActivity);

        setDataSourceDefaultValue(tmActivity);

        updateSubmitAction(tmActivity);

        updateShowSubmitActions(tmActivity);

        updateSubmitType(locale, tmActivity);
    }

    private static void updateShowSubmitActions(PcUiBotTmActivity tmActivity) {
        if (tmActivity.getPages() != null && tmActivity.getPages().getShowSubmitActions() == null) {
            tmActivity.getPages().setShowSubmitActions(true);
        }
    }

    private static void updateSubmitAction(PcUiBotTmActivity tmActivity) {
        if (tmActivity.getApprove() != null && tmActivity.getApprove().getSequence() != null) {
            for (PcUiBotTmSequence tmSequence : tmActivity.getApprove().getSequence()) {
                if (tmSequence.getSubmits() != null) {
                    for (PcUiBotTmAction submit : tmSequence.getSubmits()) {
                        updateSubmitActionDispatch(submit);
                    }
                }
            }
        }
        if (tmActivity.getPages() != null && tmActivity.getPages().getSubmitActions() != null) {
            for (PcUiBotTmAction submit : tmActivity.getPages().getSubmitActions()) {
                updateSubmitActionDispatch(submit);
            }
        }
        if (tmActivity.getPages() != null && !CollectionUtils.isEmpty(tmActivity.getPages().getDataStates())) {
            for (PcUiBotTmDataState dataState : tmActivity.getPages().getDataStates()) {
                if (dataState.getSubmitActions() != null) {
                    for (PcUiBotTmAction submit : dataState.getSubmitActions()) {
                        updateSubmitActionDispatch(submit);
                    }
                }
            }
        }
    }


    private static void updateSubmitActionDispatch(PcUiBotTmAction action) {
        if (action.getDispatchBPM() != null) {
            action.setDispatch(action.getDispatchBPM());
        }
        if (!CollectionUtils.isEmpty(action.getAttachActions())) {
            for (PcUiBotTmAction attachAction : action.getAttachActions()) {
                updateSubmitActionDispatch(attachAction);
            }
        }
    }

    /**
     * 如果任务是合并的，设置submitType按任务分批提交
     *
     * @param locale
     * @param tmActivity
     */
    private static void updateSubmitType(String locale, PcUiBotTmActivity tmActivity) {
        if (tmActivity != null && tmActivity.getPages() != null && !CollectionUtils.isEmpty(tmActivity.getPages().getDataStates())) {
            if (Objects.equals(tmActivity.getMerge(), true)) {
                tmActivity.getPages().getDataStates().forEach(tmDataState -> {
                    if (Objects.equals(tmDataState.getCode(), "waitting")) {
                        //只处理waitting的dataState
                        if (tmDataState.getSubmitType() != null) {
                            if (!Objects.equals(tmDataState.getSubmitType().getIsBatch(), true)) {
                                //如果不是分批提交的，才会设置按任务提交
                                tmDataState.getSubmitType().setIsBatch(true);
                                tmDataState.getSubmitType().setByActivity(true);
                            }
                        } else {
                            if (!CollectionUtils.isEmpty(tmDataState.getSubmitActions())) {
                                tmDataState.getSubmitActions().forEach(submitAction -> {
                                    //如果dataState没有设置，则再处理dataState中的submitAction
                                    if (submitAction.getSubmitType() != null) {
                                        if (!Objects.equals(submitAction.getSubmitType().getIsBatch(), true)) {
                                            submitAction.getSubmitType().setIsBatch(true);
                                            submitAction.getSubmitType().setByActivity(true);
                                            if (StringUtils.isBlank(submitAction.getSubmitType().getSchema())) {
                                                String message = MessageFormat.format("合并任务 {0}({1}) 未配置submitType的schema",
                                                        tmActivity.getActivityNameByLocale(), tmActivity.getActivityId());
                                                throw new ServiceException(message);
                                            }
                                        }
                                    } else {
                                        PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                                        submitType.setIsBatch(true);
                                        submitType.setByActivity(true);
                                        if (!CollectionUtils.isEmpty(tmActivity.getDataSources()) && tmActivity.getDataSources().size() == 1) {
                                            submitType.setSchema(tmActivity.getDataSources().keySet().stream().findFirst().get());
                                        } else {
                                            String message = MessageFormat.format("合并任务 {0}({1}) 未配置submitType的schema",
                                                    tmActivity.getActivityNameByLocale(), tmActivity.getActivityId());
                                            throw new ServiceException(message);
                                        }
                                        tmDataState.setSubmitType(submitType);
                                    }
                                });
                            }
                        }
                    }
                });
            }
        }
    }

    private static void setDataStateCode(PcUiBotTmActivity tmActivity) {
        if (!CollectionUtils.isEmpty(tmActivity.getPages().getDataStates())) {
            if (tmActivity.getPages().getEnableDataState() != null && tmActivity.getPages().getEnableDataState()) {

                //根据默认的方式来定义code
                //todo:暂时按照固定的数组处理，后续再改成根据任务的category来
                String[] dataStateCodes = states;
                if ("SOLVE".equals(tmActivity.getCategory())) {
                    dataStateCodes = solveStates;
                }
                int index = 0;
                for (PcUiBotTmDataState dataState : tmActivity.getPages().getDataStates()) {
                    if (StringUtils.isEmpty(dataState.getCode())) {
                        if (index < dataStateCodes.length) {
                            dataState.setCode(dataStateCodes[index]);
                        } else {
                            dataState.setCode("unknown");
                        }
                    }
                    index++;
                }
            } else {
                int index = 0;
                for (PcUiBotTmDataState dataState : tmActivity.getPages().getDataStates()) {
                    if (StringUtils.isEmpty(dataState.getCode())) {
                        dataState.setCode("uibot__data__state__" + String.format("%05d", index));
                    }
                    index++;
                }
            }
        }
    }


    /**
     * themeMap定义预处理
     *
     * @param tmActivity
     */
    private static void updateTmActivity(String pageCode, PcUiBotTmActivity tmActivity) {

        if (tmActivity.getPages() == null) {
            //容错处理，如果没有设置pages,则给一个空的
            tmActivity.setPages(new PcUiBotTmPage());
        }

        if (!CollectionUtils.isEmpty(tmActivity.getDataFilters())) {
            //dataFilters补全code
            int index = 1;
            for (PcUiBotTmDataFilter dataFilter : tmActivity.getDataFilters()) {
                if (StringUtils.isEmpty(dataFilter.getCode())) {
                    dataFilter.setCode("uibot__data__filter__" + String.format("%05d", index));
                    index++;
                }
            }
        }
        //如果没有dataState的定义，则使用filter来创建dataState
        if (CollectionUtils.isEmpty(tmActivity.getPages().getDataStates())) {
            List<PcUiBotTmDataState> dataStates = new ArrayList<>();
            List<PcUiBotTmDataFilter> tmDataFilters = null;
            if (!CollectionUtils.isEmpty(tmActivity.getDataFilters())) {
                if (CollectionUtils.isEmpty(tmDataFilters) || (!CollectionUtils.isEmpty(tmDataFilters) && tmDataFilters.size() == 0)) {
                    tmDataFilters = tmActivity.getDataFilters().stream()
                            .filter((filter) -> StringUtils.isEmpty(filter.getApplyTo()) || filter.getApplyTo().contains(PC_PAGECODE_TASK_DETAIL))
                            .collect(Collectors.toList());
                }
                //除了任务详情和项目详情，其他都只是使用默认显示过滤器或者使用第一个
                if (tmDataFilters != null && !tmDataFilters.isEmpty() &&
                        (!UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(pageCode)
                                && !UiBotDesignerService.PAGECODE_TASK_DETAIL.equals(pageCode))) {
                    Optional<PcUiBotTmDataFilter> defaultFilter = tmDataFilters.stream()
                            .filter(filter -> filter.getDefaultFilter() != null && filter.getDefaultFilter())
                            .findFirst();
                    if (defaultFilter.isPresent()) {
                        tmDataFilters.clear();
                        tmDataFilters.add(defaultFilter.get());
                    } else {
                        PcUiBotTmDataFilter tmDataFilter = tmDataFilters.get(0);
                        tmDataFilters.clear();
                        tmDataFilters.add(tmDataFilter);
                    }
                }
            }

            //如果没有设置dataStates，则将dataFilters转换为dataStates
            if (!CollectionUtils.isEmpty(tmDataFilters)) {
                for (PcUiBotTmDataFilter tmDataFilter : tmDataFilters) {
                    PcUiBotTmDataState ds = createTmDataState(tmDataFilter, tmActivity);
                    dataStates.add(ds);
                }
                tmActivity.getPages().setDataStates(dataStates);

            } else {
                PcUiBotTmDataState ds = createTmDataState(null, tmActivity);
                // 构建DataFilter下的数据
                ds = setDataFilterAndViewCode(tmActivity, ds);
                dataStates.add(ds);
            }
            tmActivity.getPages().setDataStates(dataStates);
        } else {
            //调整datafilter的位置，优化到每个具体的page下dataState中；如果同时存在，以page里的datafilter为主
            int index = 1;
            for (PcUiBotTmDataState tmDataState : tmActivity.getPages().getDataStates()) {
                if (tmDataState.getDataFilter() != null && StringUtils.isEmpty(tmDataState.getDataFilter().getCode())) {
                    tmDataState.getDataFilter().setCode("uibot__data__filter__" + String.format("%05d", index));
                    index++;
                }
            }
        }

        // 若tmActivity.pages.settings不为null
        if (Objects.nonNull(tmActivity.getPages()) && Objects.nonNull(tmActivity.getPages().getSettings())
                && !CollectionUtils.isEmpty(tmActivity.getPages().getDataStates())) {
            for (PcUiBotTmDataState dataState : tmActivity.getPages().getDataStates()) {
                // 如果dataState.settings为null，则使用tmActivity.pages.settings替换
                if (Objects.nonNull(dataState) && Objects.isNull(dataState.getSettings())) {
                    dataState.setSettings(tmActivity.getPages().getSettings());
                }
            }
        }

        Optional<PcUiBotTmDataState> dataStates = tmActivity.getPages().getDataStates().stream()
                .filter(s -> s.getMergeQuery() != null && s.getMergeQuery()).findFirst();
        if (dataStates.isPresent()) {
            tmActivity.getPages().setMergeQuery(true);
        } else {
            tmActivity.getPages().setMergeQuery(false);
        }

    }

    /**
     * 把processor放到数据源上去。
     * * @param pageCode
     *
     * @param tmActivity
     */
    private static void processDataProcessor(String pageCode, PcUiBotTmActivity tmActivity) {

        if (tmActivity.getDataSources() == null
                || tmActivity.getDataSources().size() == 0) {
            return;
        }
        //xuxx 2022-11-07 移除外层的dataProcessors，移至：dataSources[x].dataProcessors,如果同时存在以dataSources[x].中为准；
        int indexProcess = 0;
        for (Map.Entry<String, PcUiBotTmQueryAction> stringTmQueryActionEntry : tmActivity.getDataSources().entrySet()) {
            String key = stringTmQueryActionEntry.getKey();
            PcUiBotTmQueryAction tmActionDTO = stringTmQueryActionEntry.getValue();
            if (!CollectionUtils.isEmpty(tmActionDTO.getDataProcessors())) {
                List<String> dataSourceNames = new ArrayList<>();
                dataSourceNames.add(key);
                if (indexProcess == 0) {
                    tmActivity.setDataProcessors(new ArrayList<>());
                }
                Iterator<PcUiBotTmDataProcess> tmDataProcessByDataSource = tmActionDTO.getDataProcessors().iterator();
                while (tmDataProcessByDataSource.hasNext()) {
                    PcUiBotTmDataProcess proce = tmDataProcessByDataSource.next();
                    //只获取该页面定义下的处理器
                    if (StringUtils.isBlank(proce.getApplyTo()) || proce.getApplyTo().contains(PC_PAGECODE_TASK_DETAIL)) {
                        proce.setDataSourceNames(dataSourceNames);
                        if (!tmActivity.getDataProcessors().contains(proce)) {
                            tmActivity.getDataProcessors().add(proce);
                        }
                    } else {
                        //否则将处理器移除
                        tmDataProcessByDataSource.remove();
                    }
                }
                indexProcess++;
            }
        }
        if (CollectionUtils.isEmpty(tmActivity.getDataProcessors())) {
            return;
        }
        List<PcUiBotTmDataProcess> dataProcessors = new ArrayList<>();
        for (PcUiBotTmDataProcess dataProcessor : tmActivity.getDataProcessors()) {
            if (StringUtils.isNotBlank(dataProcessor.getApplyTo())) {
                String[] applyTos = StringUtils.split(dataProcessor.getApplyTo(), ",");
                for (String applyTo : applyTos) {
                    if (applyTo.equals(pageCode)) {
                        if (!dataProcessors.contains(dataProcessor)) {
                            dataProcessors.add(dataProcessor);
                        }
                    }
                }
            } else {
                if (!dataProcessors.contains(dataProcessor)) {
                    dataProcessors.add(dataProcessor);
                }
            }
        }
        //把非全局的处理器拿出来
        Map<String, PcUiBotTmDataProcess> dataProcessMap = new HashMap<>();
        //取全局的数据处理器
        List<PcUiBotTmDataProcess> allDataProcessors = new ArrayList<>();
        //全局的指定了数据源的处理器拿出来
        Map<String, PcUiBotTmDataProcess> allDataProcessMap = new HashMap<>();
        for (PcUiBotTmDataProcess dataProcessor : dataProcessors) {
            //特殊处理任务的process
            if ("atmcDataService".equals(dataProcessor.getServiceName())
                    || PcUiBotConstants.DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED.equals(dataProcessor.getActivePoint())) {

                if (dataProcessor.getDataSourceNames() == null) {
                    //如果没有指定数据源也是全局的
                    allDataProcessors.add(dataProcessor);
                } else {
                    for (String dataSourceName : dataProcessor.getDataSourceNames()) {
                        allDataProcessMap.put(dataSourceName, dataProcessor);
                    }
                }
            } else {
                if (dataProcessor.getDataSourceNames() == null) {
                    //如果没有指定数据源也是全局的
                    allDataProcessors.add(dataProcessor);
                } else {
                    for (String dataSourceName : dataProcessor.getDataSourceNames()) {
                        dataProcessMap.put(dataSourceName, dataProcessor);
                    }
                }
            }
        }

        for (Map.Entry<String, PcUiBotTmQueryAction> stringTmQueryActionEntry : tmActivity.getDataSources().entrySet()) {
            String key = stringTmQueryActionEntry.getKey();
            PcUiBotTmQueryAction value = stringTmQueryActionEntry.getValue();
            //当存dataSources下面存在dataProcessors，以dataSources中的为准
            if (!CollectionUtils.isEmpty(value.getDataProcessors())) {
                continue;
            }
            value.setName(key);
            addDataProcessor(value, dataProcessMap);
            value.getDataProcessors().addAll(allDataProcessors);
            if (allDataProcessMap.containsKey(key)) {
                value.getDataProcessors().add(allDataProcessMap.get(key));
            }
        }

    }


    private static void addDataProcessor(PcUiBotTmQueryAction tmQueryAction, Map<String, PcUiBotTmDataProcess> dataProcessMap) {
        if (tmQueryAction.getDataProcessors() == null) {
            tmQueryAction.setDataProcessors(new ArrayList<>());
        }
        if (dataProcessMap.containsKey(tmQueryAction.getName())) {
            tmQueryAction.getDataProcessors().add(dataProcessMap.get(tmQueryAction.getName()));
        }
        if (tmQueryAction.getLeft() != null) {
            addDataProcessor(tmQueryAction.getLeft(), dataProcessMap);
        }
        if (tmQueryAction.getRightList() != null) {
            for (PcUiBotTmQueryAction queryAction : tmQueryAction.getRightList()) {
                addDataProcessor(queryAction, dataProcessMap);
            }
        }
    }

    private static PcUiBotTmDataState createTmDataState(PcUiBotTmDataFilter tmDataFilter, PcUiBotTmActivity tmActivity) {

        PcUiBotTmDataState ds = PcUiBotTmDataState.builder()
                .dataFilterCode(tmDataFilter == null ? null : tmDataFilter.getCode())
                .operations(null)
                .submitActions(null)
                .extendedFields(tmActivity.getPages().getExtendedFields())
                .submitType(tmActivity.getPages().getSubmitType())
                .multipleSelectMerge(tmActivity.getPages().getMultipleSelectMerge())
//                .summaryFields(tmActivity.getPages().getSummaryFields())
                .taskStates(tmActivity.getPages().getTaskStates())
                .settings(tmActivity.getPages().getSettings())
                .abortTaskAction(tmActivity.getPages().getAbortTaskAction())
                .enablePaging(tmActivity.getPages().getEnablePaging())
                .tabs(tmActivity.getPages().getTabs())
                .enableBackEndPaging(tmActivity.getPages().getEnableBackEndPaging())
                .enableBackEndPagingLimit(tmActivity.getPages().getEnableBackEndPagingLimit())
                .mergeQuery(tmActivity.getPages().getMergeQuery())
//                .gridConfig(tmActivity.getPages().getGridConfig())
//                .gridSettings(tmActivity.getPages().getGridSettings())
                .layout(tmActivity.getPages().getLayout())
                .hooks(tmActivity.getPages().getHooks())
                .dataViewQuerys(tmActivity.getPages().getDataViewQuerys())
                .masterFromDataSourceName(tmActivity.getPages().getMasterFromDataSourceName())
                .build();

        if (tmDataFilter == null || tmDataFilter.getDefaultFilter()) {
            ds.setOperations(tmActivity.getPages().getOperations());
            ds.setSubmitActions(tmActivity.getPages().getSubmitActions());
        }
        return ds;
    }

    /**
     * 设置 数据源name 值
     *
     * @param tmActivity
     */
    private static void setDataSourceDefaultValue(PcUiBotTmActivity tmActivity) {
        if (CollectionUtils.isEmpty(tmActivity.getDataSources())) {
            return;
        }
        tmActivity.getDataSources().forEach((k, v) -> {
            if (StringUtils.isBlank(v.getName())) {
                v.setName(k);
            }
        });
    }

    /**
     * 构建DataFilter下的数据
     * 1.构建DataFilter下的DataSourceNames
     * 2.遍历数据源打标识,设置当前viewCode
     * 3.新模式没有单独的dataViewQuerys，这里构建放到线程容器中是为了在后面构建左边树使用
     *
     * @param tmActivity
     * @param ds
     * @return
     */
    private static PcUiBotTmDataState setDataFilterAndViewCode(PcUiBotTmActivity tmActivity, PcUiBotTmDataState ds) {
        /**
         * 查询方案的通用数据源
         * 查询方案无tmDataFilter结构，只有dataSourceNames结构
         * 对DataSourceNames结构进行拼接，与原tmDataFilter结构融合
         */
        if (!CollectionUtils.isEmpty(tmActivity.getPages().getDataSourceNames())) {

            List<String> dataSourceNames = tmActivity.getPages().getDataSourceNames();

            //兼容有些历史配置有dataSourceNames又不是新的模式，DataSources下又没有dataViewQuery
            if (tmActivity.getDataSources().get(dataSourceNames.get(0)) != null &&
                    tmActivity.getDataSources().get(dataSourceNames.get(0)).getDataViewQuery() != null) {

                PcUiBotTmDataFilter tempTmDataFilter = new PcUiBotTmDataFilter();
                tempTmDataFilter.setDataSourceNames(dataSourceNames);
                ds.setDataFilter(tempTmDataFilter);

                //视图模式，有从请求传入的viewCode，这里获取的就是请求传入的viewCode
                //在DataViewPageDefineAnalyzer类66行
                String viewCode =
                        PcUiBotRuntimes.getContext().get(PcUiBotConstants.RuntimesContextKey.VIEW_CODE, String.class).orElse(StringUtils.EMPTY);

                /**
                 * 遍历数据源打标识,设置当前视图
                 */
                List<PcUiBotTmQueryAction> tmQueryActionList = new ArrayList<>();
                for (String dataSourceName : dataSourceNames) {
                    PcUiBotTmQueryAction queryAction = tmActivity.getDataSources().get(dataSourceName);
                    if (queryAction != null) {
                        tmQueryActionList.add(queryAction);
                    }
                }

                if (!CollectionUtils.isEmpty(tmQueryActionList)) {
                    List<PcUiBotTmDataViewQuery> tmDataViewQueries =
                            tmQueryActionList.stream().map(PcUiBotTmQueryAction::getDataViewQuery).filter(Objects::nonNull).collect(Collectors.toList());
                    //先选第一个为默认视图
                    String defaultViewCode = tmDataViewQueries.get(0).getCode();
                    //标识是否为viewCode数据源，非viewCode数据源不用构建dataViewQuerys给左侧栏展示
                    boolean isViewCodeMode =
                            tmQueryActionList.get(0).getType().equals(PcUiBotConstants.ACTION_CATEGORY_VIEW_CODE);
                    PcUiBotTmDataViewQuery tmDataViewQuery =
                            tmDataViewQueries.stream().filter(s -> s.getIsDefault() != null && s.getIsDefault()).findFirst().orElse(null);
                    if (tmDataViewQuery != null) {
                        //有isDefault设置为默认视图
                        defaultViewCode = tmDataViewQuery.getCode();
                    }

                    //当没有从请求传入视图，就按现在筛选出来的视图作为默认视图，进行覆盖操作
                    if (StringUtils.isBlank(viewCode)) {
                        PcUiBotRuntimes.getContext().put(PcUiBotConstants.RuntimesContextKey.VIEW_CODE, defaultViewCode);
                    }

                    /**
                     * 新模式没有单独的dataViewQuerys，这里构建放到线程容器中是为了在后面构建左边树使用
                     */
                    List<PcUiBotDataViewQueryDTO> dataViewQuerys = tmQueryActionList.stream().map(tmQueryAction -> {
                        PcUiBotDataViewQueryDTO dataViewQueryDTO = new PcUiBotDataViewQueryDTO();
                        if (tmQueryAction.getType().equals(PcUiBotConstants.ACTION_CATEGORY_VIEW_CODE)) {
                            PcUiBotTmDataViewQuery dataViewQuery = tmQueryAction.getDataViewQuery();
                            dataViewQueryDTO.setViewName(tmQueryAction.getTitle());
                            dataViewQueryDTO.setViewCode(dataViewQuery.getCode());
                            dataViewQueryDTO.setSort(dataViewQuery.getSort());
                            dataViewQueryDTO.setIsDefault(dataViewQuery.getIsDefault());
                        } else {
                            PcUiBotTmDataViewQuery dataViewQuery = tmQueryAction.getDataViewQuery();
                            //其他类型没DataViewQuery结构体，需要自己手动创建对象
                            dataViewQueryDTO.setViewName(tmQueryAction.getTitle());
                            dataViewQueryDTO.setViewCode(tmQueryAction.getViewCode());
                            dataViewQueryDTO.setSort(tmQueryAction.getSequence());
                            dataViewQueryDTO.setIsDefault(dataViewQuery.getIsDefault());
                        }
                        return dataViewQueryDTO;
                    }).collect(Collectors.toList());

                    if (isViewCodeMode && dataViewQuerys.size() > 1) {
                        //放到线程容器,给后面构建左边树使用
                        PcUiBotRuntimes.getContext().put(PcUiBotConstants.RuntimesContextKey.DATA_VIEW_QUERYS, dataViewQuerys);
                    }
                }

                //移除为了兼容开发平台没有去掉的tmActivity.pages.dataViewQuerys下的配置
                //不移除，到后面analysisDataViewQuerys()里会分析tmActivity.pages.dataViewQuerys下的配置，就会走老逻辑
                tmActivity.getPages().setDataViewQuerys(null);
                ds.setDataViewQuerys(null);
                ds.setLayout(null);
                ds.setOperations(null);
                ds.setSubmitActions(null);
            }
        }

        return ds;
    }
}
