package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadataConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotMetadataTagResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotThemeMapTag;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;

/**
 * <p>功能描述：创建自定义标签</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotDefaultTagUtils.java
 * @Author: wangjwc
 * @Date: created at 2023/10/27 15:25
 */
public final class PcUiBotDefaultTagUtils {


    private static final String DATA_TYPE_DATE = "date";

    private static final String DATA_TYPE_DATETIME = "datetime";

    private static final String DATA_TYPE_TIME = "time";

    private static final String DATA_TYPE_STRING = "string";

    private static final String DATA_TYPE_NUMBER = "number";

    private static final String DATA_TYPE_NUMERIC = "numeric";

    private static final String DATA_TYPE_BOOLEAN = "boolean";

    public static PcUiBotTagDefinition createTagDefinition() {
        PcUiBotTagDefinition tagDefinition = new PcUiBotTagDefinition();
        tagDefinition.setCode(UUID.randomUUID().toString());
        tagDefinition.setName("随机标签");
        tagDefinition.setCustomize(true);
        return tagDefinition;
    }


    public static List<PcUiBotTagDefinition> createTagDefinitions() {
        List<PcUiBotTagDefinition> tagDefinitions = new ArrayList<>();
        PcUiBotTagDefinition tagDefinition = new PcUiBotTagDefinition();
        tagDefinition.setCode(UUID.randomUUID().toString());
        tagDefinition.setName("随机标签");
        tagDefinition.setCustomize(true);
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }

    /**
     * 添加默认的字段
     *
     * @param metadataFieldList
     * @param tagConsumer       添加的默认字段后的处理
     */
    public static void addDefaultTag(List<PcUiBotMetadataField> metadataFieldList, Consumer<PcUiBotMetadataField> tagConsumer) {
        if (CollectionUtils.isEmpty(metadataFieldList)) {
            return;
        }
        for (PcUiBotMetadataField metadataField : metadataFieldList) {
            List<PcUiBotTagDefinition> tagDefinitions = metadataField.getTagDefinitions();
            // 没有标签且不是对象类型
            if (CollectionUtils.isEmpty(tagDefinitions) && !PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                // 添加默认标签
                metadataField.setTagDefinitions(createDataTypeTagDefinitions(metadataField));
                if (tagConsumer != null) {
                    // 添加标签的处理
                    tagConsumer.accept(metadataField);
                }
            }
            addDefaultTag(metadataField.getSubFields(), tagConsumer);
        }
    }


//    public List<TagDefinition> createOrderTagDefinitions(String value) {
//        List<TagDefinition> tagDefinitions = new ArrayList<>();
//        TagDefinition tagDefinition = new TagDefinition();
//        tagDefinition.setTmTagCode(TagConstant.ORDER_PREFIX + value);
//        tagDefinition.setTmTagValue(value);
//        tagDefinition.setCode(TagConstant.ORDER_TAG);
//        tagDefinition.setName("顺序标签");
//        tagDefinition.setDescription("排序使用");
//        tagDefinition.setCategory("ORDER");
//        tagDefinition.setInterpreterServiceName("orderTagInterpreter");
//        tagDefinition.setCustomize(false);
//        tagDefinitions.add(tagDefinition);
//        return tagDefinitions;
//    }


    public static List<PcUiBotTagDefinition> createTemplateMiddleTagDefinitions() {
        List<PcUiBotTagDefinition> tagDefinitions = new ArrayList<>();
        PcUiBotTagDefinition tagDefinition = new PcUiBotTagDefinition();
//        tagDefinition.setTmTagCode(TagConstant.CHARGE_APPROVAL_TEMPLATE_MIDDLE);
        tagDefinition.setCode(PcUiBotTagConstant.CHARGE_APPROVAL_TEMPLATE_MIDDLE);
        tagDefinition.setName("是否重要属性");
        tagDefinition.setDescription("是否重要属性");
        tagDefinition.setCategory(PcUiBotTagConstant.CATEGORY_BUSINESS);
//        tagDefinition.setInterpreterServiceName("importantTagInterpreter");
        tagDefinition.setCustomize(false);

        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }

    public static PcUiBotTagDefinition createEocSelectTagDef() {
        PcUiBotTagDefinition tagDefinition = new PcUiBotTagDefinition();

        tagDefinition.setCode(PcUiBotTagConstant.EOC_SELECT);
        tagDefinition.setCategory(PcUiBotTagConstant.CATEGORY_BUSINESS);
//        tagDefinition.setInterpreterServiceName(EocSelectInterpreter.INSTANCE_NAME);
        tagDefinition.setCustomize(false);

        return tagDefinition;
    }

    /**
     * 创建数据标签
     *
     * @param metadataField
     * @return
     */
    public static List<PcUiBotTagDefinition> createDataTypeTagDefinitions(PcUiBotMetadataField metadataField) {
        List<PcUiBotTagDefinition> tagDefinitions = new ArrayList<>();
        tagDefinitions.add(createDataTypeDefinition(metadataField, null));
        return tagDefinitions;
    }

    /**
     * 创建数据标签
     *
     * @param metadataField
     * @return
     */
    public static void createDataTypeTagDefinition(PcUiBotMetadataField metadataField, PcUiBotMetadataTagResult metadataTagResult) {
        List<PcUiBotTagDefinition> tagDefinitions = metadataField.getTagDefinitions();
        if (CollectionUtils.isEmpty(tagDefinitions)) {
            tagDefinitions = new ArrayList<>();
            tagDefinitions.add(createDataTypeDefinition(metadataField, metadataTagResult));
            metadataField.setTagDefinitions(tagDefinitions);
        } else {
            boolean addFlag = true;
            for (PcUiBotTagDefinition tagDefinition : tagDefinitions) {
                if (StringUtils.isNotBlank(tagDefinition.getInterpreterServiceName())) {
                    addFlag = false;
                }
            }
            if (addFlag) {
                tagDefinitions.add(createDataTypeDefinition(metadataField, metadataTagResult));
            }
        }
    }


    public static PcUiBotTagDefinition createDataTypeDefinition(PcUiBotMetadataField metadataField, PcUiBotMetadataTagResult metadataTagResult) {
        PcUiBotTagDefinition tagDefinition = new PcUiBotTagDefinition();
        tagDefinition.setDefaultTag(true);
        tagDefinition.setName("数据组件");
        tagDefinition.setDescription("数据组件");
        tagDefinition.setCategory(PcUiBotTagConstant.CATEGORY_DATATYPE);
        tagDefinition.setCustomize(false);
        if (metadataField != null && metadataTagResult != null && metadataTagResult.getTags() != null) {
            tagDefinition.setThemeMapTag(metadataTagResult.getTags().get(0));
        }
        if (metadataField.getEnumKey() != null) {//NOSONAR
            tagDefinition.setCode(PcUiBotTagConstant.BUSINESS_SELECT);
            tagDefinition.setInterpreterServiceName("selectInterpreter");
        } else if (DATA_TYPE_DATE.equals(metadataField.getDataType())) {
            tagDefinition.setCode(PcUiBotTagConstant.TYPE_DATE_TAG);
            tagDefinition.setInterpreterServiceName("typeDateTagInterpreter");
        } else if (DATA_TYPE_DATETIME.equals(metadataField.getDataType())) {
            tagDefinition.setCode(PcUiBotTagConstant.TYPE_DATE_TAG);
            tagDefinition.setInterpreterServiceName("typeDateTagInterpreter");
        } else if (DATA_TYPE_TIME.equals(metadataField.getDataType())) {
            tagDefinition.setCode(PcUiBotTagConstant.TYPE_DATE_TAG);
            tagDefinition.setInterpreterServiceName("typeDateTagInterpreter");
        } else if (DATA_TYPE_STRING.equals(metadataField.getDataType())) {
//            tagDefinition.setTmTagCode(TagConstant.TYPE_STRING_TAG);
            if (metadataField.getName() != null && metadataField.getName().contains("remark")) {
                tagDefinition.setCode(PcUiBotTagConstant.TYPE_STRING_TAG);
                tagDefinition.setInterpreterServiceName("textAreaTagInterpreter");
            } else {
                tagDefinition.setCode(PcUiBotTagConstant.TYPE_STRING_TAG);
                tagDefinition.setInterpreterServiceName("typeStringTagInterpreter");
            }
        } else if (DATA_TYPE_NUMBER.equals(metadataField.getDataType())) {
//            tagDefinition.setTmTagCode(TagConstant.TYPE_NUMBER_TAG);
            tagDefinition.setCode(PcUiBotTagConstant.TYPE_NUMBER_TAG);
            tagDefinition.setInterpreterServiceName("typeNumberTagInterpreter");
        } else if (DATA_TYPE_BOOLEAN.equals(metadataField.getDataType())) {
//            tagDefinition.setTmTagCode(TagConstant.TYPE_BOOLEAN_TAG);
            tagDefinition.setCode(PcUiBotTagConstant.TYPE_BOOLEAN_TAG);
            tagDefinition.setInterpreterServiceName("typeBooleanTagInterpreter");
        } else if (DATA_TYPE_NUMERIC.equals(metadataField.getDataType())) {
//            tagDefinition.setTmTagCode(TagConstant.TYPE_NUMERIC_TAG);
            tagDefinition.setCode(PcUiBotTagConstant.TYPE_NUMERIC_TAG);
            tagDefinition.setInterpreterServiceName("typeNumericTagInterpreter");
        } else {
            tagDefinition.setCode(PcUiBotTagConstant.TYPE_STRING_TAG);
            tagDefinition.setInterpreterServiceName("typeStringTagInterpreter");
        }
        return tagDefinition;
    }

    /**
     * 构建附件tag
     *
     * @return 附件tag列表
     */
    public static List<PcUiBotTagDefinition> buildAttachmentFileTagDefs(String tagName, String tagDescription) {
        List<PcUiBotTagDefinition> tagDefinitions = Lists.newArrayList();

        PcUiBotTagDefinition tagDefinition = new PcUiBotTagDefinition();
        tagDefinition.setCode(PcUiBotTagConstant.BUSINESS_ATTACHMENT_FILE);
        tagDefinition.setName(tagName);
        tagDefinition.setDescription(tagDescription);
        tagDefinition.setCategory(PcUiBotTagConstant.CATEGORY_BUSINESS);
        tagDefinition.setInterpreterServiceName("attachmentFileInterpreter");
        tagDefinition.setCustomize(false);

        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }

    /**
     * 生成基本数据类型的默认值：
     * 数组：返回: []
     * 数字：返回：null
     * 布尔：返回：false
     * 日期、字符串，返回：""
     *
     * @param metadataField
     * @return
     */
    public static Object genPrimitiveTypeDefaultValue(PcUiBotMetadataField metadataField) {
        if (metadataField.isArray()) {
            return new String[]{};
        }

        if (DATA_TYPE_NUMBER.equals(metadataField.getDataType()) || DATA_TYPE_NUMERIC.equals(metadataField.getDataType())) {
            return null;
        } else if (DATA_TYPE_BOOLEAN.equals(metadataField.getDataType())) {
            return Boolean.FALSE;
        } else {
            return "";
        }
    }

    /**
     * 构建不可编辑TAG
     *
     * @return
     */
    public static PcUiBotTagDefinition createUneditableTagDef() {
        PcUiBotTagDefinition tagDefine = new PcUiBotTagDefinition();
        tagDefine.setCode(PcUiBotTagConstant.UNEDITABLE);
        tagDefine.setCategory(PcUiBotTagConstant.CATEGORY_DISPLAY);
        PcUiBotThemeMapTag themeMapTag = new PcUiBotThemeMapTag();
        themeMapTag.setCode(PcUiBotTagConstant.UNEDITABLE);
        tagDefine.setThemeMapTag(themeMapTag);
        return tagDefine;
    }


    public static List<PcUiBotTagDefinition> createDefinitionByType(String tagCode, String tagName, String interpreterServiceName) {
        List<PcUiBotTagDefinition> tagDefinitions = Lists.newArrayList();
        PcUiBotTagDefinition tagDefinition = new PcUiBotTagDefinition();
        tagDefinition.setDefaultTag(true);
        tagDefinition.setName(tagName);
        tagDefinition.setDescription(tagName);
        tagDefinition.setCategory(PcUiBotTagConstant.CATEGORY_BUSINESS);
        tagDefinition.setCustomize(false);
        tagDefinition.setCode(tagCode);
        tagDefinition.setInterpreterServiceName(interpreterServiceName);
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }

}
