package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadataConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.google.common.collect.Lists;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PcUiBotHeadTagUtils {

    private PcUiBotHeadTagUtils() {
    }

    public static PcUiBotMetadataField analysisTag(List<PcUiBotMetadataField> originalMetadata) {
        return positionHeadTag(originalMetadata);
    }

    /**
     * head 特殊标签
     */
    private static PcUiBotMetadataField positionHeadTag(List<PcUiBotMetadataField> originalMetadata) {
        List<PcUiBotMetadataField> headShowFiles = new ArrayList<>();
        handleHeadTag(headShowFiles, originalMetadata);
        if (!CollectionUtils.isEmpty(headShowFiles)) {
            PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
            metadataField.setHead(Boolean.TRUE);
            metadataField.setName(originalMetadata.get(0).getName() + "_HEAD");
            metadataField.setArray(Boolean.FALSE);
            metadataField.setSubFields(headShowFiles);
            metadataField.setDataType(PcUiBotApiMetadataConstants.METADATA_OBJECT);
            // 获取需要组成groupInline的字段
            List<PcUiBotMetadataField> groupInlineFields = extractGroupInlineFields(headShowFiles);
            // 打标：groupInline标签
            markGroupInlineTag(groupInlineFields);
            // 打标：group标签
            markGroupTag(headShowFiles);
            metadataField.getSubFields().addAll(groupInlineFields);
            return metadataField;
        }
        return null;
    }

    /**
     * 打标：GROUP
     *
     * @param headShowFiles
     */
    private static void markGroupTag(List<PcUiBotMetadataField> headShowFiles) {
        for (PcUiBotMetadataField headField : headShowFiles) {
            if (!CollectionUtils.isEmpty(headField.getTagDefinitions())) {
                PcUiBotTagDefinition tag = PcUiBotTagUtil.buildGroupTagDefinition(headField.getName());
                headField.getTagDefinitions().add(tag);
            }
        }
    }

    /**
     * 打标：GROUP_INLINE
     *
     * @param groupInlineFields
     */
    private static void markGroupInlineTag(List<PcUiBotMetadataField> groupInlineFields) {
        for (PcUiBotMetadataField headField : groupInlineFields) {
            if (!CollectionUtils.isEmpty(headField.getTagDefinitions())) {
                PcUiBotTagDefinition tag = PcUiBotTagUtil.buildTagDefinition(PcUiBotTagConstant.TagCode.GROUP_INLINE, headField.getName());
                headField.getTagDefinitions().add(tag);
            }
        }
    }

    /**
     * 从head字段中，根据标签code，抽取contact和address字段
     *
     * @param headShowFiles
     * @return
     */
    private static List<PcUiBotMetadataField> extractGroupInlineFields(List<PcUiBotMetadataField> headShowFiles) {
        List<PcUiBotMetadataField> combineField = Lists.newArrayList();
        for (PcUiBotMetadataField headShowFile : headShowFiles) {
            List<PcUiBotTagDefinition> tagDefinitions = headShowFile.getTagDefinitions();
            if (PcUiBotTagUtil.existBusinessTag(tagDefinitions, PcUiBotTagConstant.TagCode.CONTACT)
                    || PcUiBotTagUtil.existBusinessTag(tagDefinitions, PcUiBotTagConstant.TagCode.ADDRESS)) {
                combineField.add(headShowFile);
            }
        }
        // 暂固定
        if (combineField.size() == 2) {
            headShowFiles.removeAll(combineField);
            return combineField;
        }
        return Lists.newArrayList();
    }

    /**
     * 变形数据结构
     * headShowFiles  这边显示的字段需要上提到最上一级
     *
     * @param metadataFields
     * @return
     */
    private static void handleHeadTag(List<PcUiBotMetadataField> headShowFiles, List<PcUiBotMetadataField> metadataFields) {
        if (!CollectionUtils.isEmpty(metadataFields)) {
            Iterator<PcUiBotMetadataField> metadataFieldIterator = metadataFields.iterator();
            while (metadataFieldIterator.hasNext()) {
                PcUiBotMetadataField metadataField = metadataFieldIterator.next();
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                    handleHeadTag(headShowFiles, metadataField.getSubFields());
                }
                if (!CollectionUtils.isEmpty(metadataField.getTagDefinitions())) {
                    for (PcUiBotTagDefinition tagDefinition : metadataField.getTagDefinitions()) {
                        if (tagDefinition.getThemeMapTag() != null &&
                                PcUiBotTagConstant.POSITION_TAG.equals(tagDefinition.getCategory()) && PcUiBotTagConstant.HEAD_TAG.equals(tagDefinition.getThemeMapTag().getCode())) {
                            try {
                                metadataFieldIterator.remove();
                            } catch (Exception e) {
                            } finally {
                                PcUiBotMetadataField newMetadataField = JsonUtil.objectToJavaObject(metadataField, PcUiBotMetadataField.class);
                                PcUiBotTagUtil.removeTag(newMetadataField, PcUiBotTagConstant.POSITION_TAG, PcUiBotTagConstant.HEAD_TAG);
                                if (!headShowFiles.contains(newMetadataField)) {
                                    headShowFiles.add(newMetadataField);
                                }
                            }
                        }
                    }
                }
            }
        }

    }

}
