package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;


import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * <p>功能描述：国际化工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MessageUtils.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 9:31
 */
public class PcUiBotMessageUtils {

    public static String getMessageByCurrentLanguage(Object langObject) {
        String langName = AppRequestContext.getContextEntity().getLocale();
        return getMessageByLanguage(langObject, langName);
    }

    public static String getMessageByLanguage(Object langObject, String langName) {
        if (langObject == null) {
            return "";
        }
        Map langMap = null;
        if (langObject instanceof String) {
            String valueText = langObject.toString();
            if (valueText.startsWith("{") && valueText.endsWith("}")) {
                ObjectMapper om = new ObjectMapper();
                try {
                    langMap = om.readValue(valueText, Map.class);
                } catch (JsonProcessingException e) {
                    return "";
                }
            } else {
                return valueText;
            }
        } else if (langObject instanceof Map) {
            langMap = (Map) langObject;
        } else {
            return langObject.toString();
        }

        if (!CollectionUtils.isEmpty(langMap)) {
            langName = langName.replace("-", "_");
            if (langMap.containsKey(langName)) {
                return (String) langMap.get(langName);
            } else {
                return "";
            }
        }

        return langObject.toString();
    }
}
