package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotCondition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：用于判断Operations上相关操作</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotOperationsUtil.java
 * @Author: wangjwc
 * @Date: created at 2023/11/21 15:19
 */
public final class PcUiBotOperationsUtil {

    /**
     * 是否存在某个操作
     * true 存在
     * false 不存在
     *
     * @param operations
     * @return
     */
    public static boolean isExists(List<PcUiBotOperationDTO> operations, List<String> types) {
        if (CollectionUtils.isEmpty(operations)) {
            return false;
        }
        Optional<PcUiBotOperationDTO> optional = operations.stream()
                .filter(opr -> StringUtils.isNotEmpty(opr.getType())
                        && types.contains(opr.getType())).findFirst();
        return optional.isPresent();
    }

    /**
     * 设置条件相关参数：包含禁用条件和隐藏条件
     *
     * @param tmOperation
     * @param operationDTO
     */
    public static void setCondition(PcUiBotTmOperation tmOperation, PcUiBotOperationDTO operationDTO) {
        if (StringUtils.isNotEmpty(tmOperation.getCondition())) {
            PcUiBotCondition condition = new PcUiBotCondition();
            operationDTO.setCondition(condition);

            condition.setScript(tmOperation.getCondition());
            condition.setTrigger(Lists.newArrayList(PcUiBotConstants.TriggerPoint.INIT));
            if (CollectionUtils.isNotEmpty(tmOperation.getTriggerList())) {
                condition.setTrigger(tmOperation.getTriggerList());
            }
        }
        operationDTO.setHidden(JsonUtil.objectToJavaObject(tmOperation.getHidden(), new TypeReference<PcUiBotCondition>() {
        }));
    }

    /**
     * 根据Sequence排序，Sequence默认为0；从小到大；
     * 模型驱动在rebuild中排序；非模型驱动，在构建ToolBar组件时排序；
     *
     * @param operationDTOList
     */
    public static void sortBySequence(List<PcUiBotOperationDTO> operationDTOList) {
        if (operationDTOList != null) {
            operationDTOList.sort(Comparator.comparingInt(PcUiBotOperationDTO::getSequence));
        }
    }

}
