package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import org.apache.commons.lang3.StringUtils;

public final class PcUiBotPatternUtil {

    /**
     * 是否为移动工作台
     *
     * @param pattern
     * @return
     */
    public static boolean isWorkBench(String pattern) {
        return StringUtils.equals(PcUiBotActivityConstants.PATTERN_WORKBENCH, pattern);
    }

    /**
     * 是否为基础资料录入
     *
     * @param pattern
     * @return
     */
    public static boolean isBaseData(String pattern) {
        return StringUtils.equals(PcUiBotActivityConstants.PATTERN_BASIC_DATA, pattern);
    }

    /**
     * 是否为报表条件
     *
     * @param pattern
     * @return
     */
    public static boolean isStatement(String pattern) {
        return StringUtils.equals(PcUiBotActivityConstants.PATTERN_STATEMENT, pattern);
    }

    /**
     * 是否为业务型
     *
     * @param pattern 业务模式
     * @return 是否为业务型
     */
    public static boolean isBusiness(String pattern) {
        return StringUtils.equals(PcUiBotActivityConstants.PATTERN_BUSINESS, pattern);
    }

    /**
     * 是否为模型驱动的任务
     */
    public static boolean isModelDriven(PcUiBotExecuteContext executeContext) {
        return PcUiBotActivityConstants.PATTERN_BUSINESS.equals(executeContext.getPattern())
                && PcUiBotActivityConstants.CATEGORY_DATA_ENTRY_DRIVEN.equals(executeContext.getCategory());
    }

    /**
     * 是否为开窗
     *
     * @param pattern
     * @return
     */
    public static boolean isDialog(String pattern) {
        return PcUiBotActivityConstants.PATTERN_DIALOG.equals(pattern);
    }
}
