package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.PropertyPlaceholderHelper;

import java.util.Map;

public abstract class PcUiBotPropertyPlaceholderUtil {
    public static final PropertyPlaceholderHelper HELPER = new PropertyPlaceholderHelper("${", "}", (String) null, true);

    public static String resolve(String value, String placeholder, String replacementValue) {
        if (StringUtils.isBlank(value)) {
            return value;
        }

        return HELPER.replacePlaceholders(value, placeholderName -> {
            if (StringUtils.equals(placeholder, placeholderName)) {
                return replacementValue;
            }

            return null;
        });
    }

    public static String resolve(String value, final Map<String, Object> replacementValues) {
        if (StringUtils.isBlank(value)) {
            return value;
        }

        return HELPER.replacePlaceholders(value, placeholderName -> {
            Object replaceValue = replacementValues.get(placeholderName);
            return null != replaceValue ? String.valueOf(replaceValue) : null;
        });
    }
}
