package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import cn.hutool.script.ScriptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.script.*;
import java.util.Map;

public class PcUiBotScriptUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptUtil.class);

    // js脚本引擎
    private static ScriptEngine jsEngine = null;

    static {
        ScriptEngineManager manager = new ScriptEngineManager();
        // js执行引擎
        jsEngine = manager.getEngineByName("js");
    }

//    /**
//     * 执行js脚本
//     *
//     * @param script   js脚本
//     * @param params   参数
//     * @param timeout  超时时间
//     * @param timeUnit 时间单位
//     * @param handler  执行结果处理器
//     */
//    public static void evalJs(String script, Map<String, Object> params, long timeout, TimeUnit timeUnit, ScriptExecuteResultHandler handler) {
//        long startTime = System.currentTimeMillis();
//        // todo 单独创建个线程池来执行？
//        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> evalJs(script, params, handler));
//        try {
//            completableFuture.get(timeout, timeUnit);
//        } catch (Exception ex) {
//            LOGGER.error("执行JS脚本情况：执行超时，脚本：{}，耗时：{}", script, System.currentTimeMillis() - startTime);
//            if (null != handler) {
//                handler.fail(jsEngine, ex);
//            }
//        }
//    }

    /**
     * 执行js脚本
     *
     * @param script  js脚本
     * @param params  参数
     * @param handler 执行结果处理器
     */
    public static void evalJs(String script, Map<String, Object> params, ScriptExecuteResultHandler handler) {
        ScriptContext ctx = new SimpleScriptContext();
        Bindings bindings = jsEngine.createBindings();
        bindings.putAll(params);
        ctx.setBindings(bindings, ScriptContext.ENGINE_SCOPE);
        long startTime = System.currentTimeMillis();
        try {
            Object result = jsEngine.eval(script, ctx);
            LOGGER.debug("执行JS脚本情况：执行成功，脚本：{}，耗时：{}", script, System.currentTimeMillis() - startTime);
            if (null != handler) {
                handler.success(jsEngine, result);
            }
        } catch (Exception ex) {
            LOGGER.error("执行JS脚本情况：执行失败，脚本：{}，耗时：{}，异常：{}", script, System.currentTimeMillis() - startTime, ex.getMessage());
            if (null != handler) {
                handler.fail(jsEngine, ex);
            }
        }
    }

    public interface ScriptExecuteResultHandler {
        /**
         * 执行成功
         *
         * @param engine        执行引擎实例，可以用它执行js脚本中的函数
         * @param executeResult 执行结果
         */
        void success(ScriptEngine engine, Object executeResult);

        /**
         * 执行失败
         *
         * @param engine    执行引擎实例，可以用它执行js脚本中的函数
         * @param exception 异常信息
         */
        default void fail(ScriptEngine engine, Exception exception) {
        }
    }
}
