package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * <p>功能描述：标签对应的组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTagConstant.java
 * @Author: wangjwc
 * @Date: created at 2023/10/27 15:19
 */
public class PcUiBotTagConstant {


    /**
     * 非组件类型
     */
    public static final String CATEGORY_GROUP = "GROUP";
    /**
     * 非组件类型
     */
    public static final String CATEGORY_ORDER = "ORDER";
    /**
     * 非组件类型
     */
    public static final String CATEGORY_DISPLAY = "DISPLAY";

    /**
     * 非组件类型
     */
    public static final String CATEGORY_POSITION = "POSITION";

    /**
     * 和组件有关系
     */
    public static final String CATEGORY_BUSINESS = "BUSINESS";
    /**
     * 数据类型 和组件有关系
     */
    public static final String CATEGORY_DATATYPE = "DATATYPE";

    /**
     * 和组件有关系
     */
    public static final String CATEGORY_APPLICATION = "APPLICATION";

    /**
     * 参加button操作列
     */
    public static final String BUSINESS_BUTTON_GROUP = "BUTTON_GROUP";

    public static final String BUSINESS_BASE_DATA_MANAGER_STATUS = "BASE_DATA_MANAGER_STATUS";

    // 状态列的预制schema
    public static final String MANAGE_STATUS = "manage_status";

    // 状态列默认值：未生效
    public static final String MANAGE_STATUS_DEFAULT = "N";


    /**
     * TM-ORDER 顺序标签 前缀
     */
    public static final String ORDER_PREFIX = "ORDER_";

    /**
     * TM-ORDER 顺序标签 前缀
     */
    public static final String GROUP_PREFIX = "GROUPTITLE_";
    /**
     * TM-特殊标签 HEAD：把元数据中所有的字段都汇总到表头中去
     */
    public static final String HEAD_TAG = "HEAD";

    public static final String TYPE_DATE_TAG = "TYPE_DATE";

    public static final String TYPE_STRING_TAG = "TYPE_STRING";

    public static final String TYPE_NUMBER_TAG = "TYPE_NUMBER";

    public static final String TYPE_NUMERIC_TAG = "TYPE_NUMERIC";

    public static final String TYPE_BOOLEAN_TAG = "TYPE_BOOLEAN";

    public static final String TYPE_REPORT_TAG = "UIBOT_NAVIGATE_REPORT";


    public static final String UNEDITABLE = "UNEDITABLE";

    public static final String DISPLAY_CHART_TAG = "DISPLAY_CHART";

    public static final String DISPLAY_WBS_TAG = "DISPLAY_WBS";


    /**
     * table 表格下载
     */
    public static final String TABLE_DATA_ATTACHMENT = "TABLE_DATA_ATTACHMENT";


    /**
     * 活动状态
     */
    public static final String ACTIVITY_TASK_STATUS = "ACTIVITY_TASK_STATUS";


    public static final String ACTIVITY_DESCRIPTION_TITLE = "ACTIVITY_DESCRIPTION_title";


    public static final String LABEL_IMPORTANT = "LABEL_IMPORTANT";

    /**
     * 主表+从表组件
     */
    public static final String SPLIT_LAYOUT = "SPLIT_LAYOUT";


    /**
     * 坐标类
     */
    public static final String POSITION_TAG = "POSITION";

    /**
     * ORDER 顺序标签 前缀
     */
    public static final String ORDER_TAG = "ORDER";

    /**
     * ORDER 顺序标签 前缀
     */
    public static final String GROUP_TAG = "GROUP";

    public static final String CHECK_ITEM = "checkItem";

    /**
     * 签核中段部分显示
     */
    public static final String CHARGE_APPROVAL_TEMPLATE_MIDDLE = "TEMPLATE_CHARGE_APPROVAL_TEMPLATE_MIDDLE";


    /**
     * 签核末端部分显示
     */
    public static final String CHARGE_APPROVAL_TEMPLATE_LAST = "TEMPLATE_CHARGE_APPROVAL_TEMPLATE_LAST";

    /**
     * 附件标签tag code
     */
    public static final String BUSINESS_ATTACHMENT_FILE = "BUSINESS_ATTACHMENT_FILE";

    public static final String BUSINESS_AMOUNT = "BUSINESS_AMOUNT";

    public static final String NAME_CODE_TAG = "NAME_CODE_COMPONENT";

    public static final String CONTACT_ADDRESS_TAG = "CONTACT_ADDRESS_COMPONENT";

    public static final String NEW_OLD_TAG = "NEW_OLD_COMPONENT";

    public static final String EOC_USER_SELECT_TAG = "EOC_USER_SELECT_COMPONENT";

    public static final String TREE_CODE = "BUSINESS_TREE";

    public static final String EOC_SELECT = "EOC_SELECT";

    public static final String BUSINESS_SELECT = "SELECT";

    public static final String UIBOT_BUTTON_GROUP = "UIBOT_BUTTON_GROUP";

    public static final String DISPLAY_NOT_CONTAIN_EXPLICIT_TAG = "DISPLAY_NOT_CONTAIN_EXPLICIT";

    public static final String BUSINESS_OBJECT_RENDER = "BUSINESS_OBJECT_RENDER";

    /**
     * 平铺元数据tag（后面要废除）
     */
    public static final String BUSINESS_FLAT_METADATA = "BUSINESS_FLAT_METADATA";

    /**
     * 平铺元数据tag
     */
    public static final String DISPALY_FLAT_METADATA = "DISPALY_FLAT_METADATA";

    /**
     * 串报表
     */
    public static final String NAVIGATE_REPORT = "NAVIGATE_REPORT";
    /**
     * 合并的编码
     */
    public final static String MERGE_TAG_CODE_PREFIX = "group_";


    /**
     * 标签编码常量内部类
     */
    public static class TagCode {

        public static final String GROUP = "GROUP";

        public static final String GROUP_INLINE = "GROUP_INLINE";

        public static final String TAB = "TAB";

        public static final String GROUP_TAB = "GROUP_TAB";

        public static final String CONTACT = "CONTACT";

        public static final String ADDRESS = "ADDRESS";

        public static final String DRAWER_BUTTON = "DRAWER_BUTTON";

    }

    /**
     * 标签类型常量内部类
     */
    public static class TagType {

        public static final String NAME_CODE = "NAME_CODE";

        public static final String GROUP_INLINE = "GROUP_INLINE";

    }

    /**
     * 组件标签code枚举；目前15个；
     */
    public enum ComponentTagCodeEnum {
        // 日期范围选择
        BUSINESS_DATE_RANGE,
        // split布局
        SPLIT_LAYOUT,
        // 合并单元格
        BUSINESS_FLAT_METADATA,
        // 多选
        MULTIPLE_SELECT,
        // 可输入开窗
        INPUT_WITH_WINDOW,
        // 数据流转状态
        DATA_FLOW_STATUS,
        // 非内含外显
        DISPLAY_NOT_CONTAIN_EXPLICIT_TAG,
        // 百分比输入框
        BUSINESS_PERCENT_INPUT,
        // 金额输入框
        BUSINESS_AMOUNT,
        // 单位下拉框
        BUSINESS_MEASURE,
        // 新旧数量
        NEW_OLD_NUMBER,
        // EOC单选
        EOC_SINGLE_SELECT,
        // EOC多选
        BUSINESS_MULTI_EOC_SELECT_COMPANY,
        // EOC员工
        BUSINESS_EMPLOYEE_SELECT,
        // 附件
        BUSINESS_ATTACHMENT_FILE;

        /**
         * 是否属于组件标签；tagCode完全相等
         *
         * @param code 标签code
         * @return
         */
        public static boolean isContain(String code) {
            if (StringUtils.isEmpty(code)) {
                return Boolean.FALSE;
            }
            return Arrays.stream(values()).anyMatch(ele -> code.equals(ele.name()));
        }
    }

}
