package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadataConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotShowMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotMetadataTagResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotObjectRenderTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotThemeMapTag;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Slf4j
public final class PcUiBotTagUtil {
    private PcUiBotTagUtil() {
    }

    public static final List<String> RENDER_OBJECT_TAG_CODE = Arrays.asList(PcUiBotTagConstant.TREE_CODE, PcUiBotTagConstant.BUSINESS_ATTACHMENT_FILE);

//    protected static final List<String> NAVIGATE_TAG = Arrays.asList(NavigateTaskInterpreter.BEAN_NAME, NavigateReportInterpreter.BEAN_NAME);

    public static boolean containsTagDef(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        return null != getTagDefByCode(tagDefList, tagCode);
    }

    public static boolean existBusinessTag(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        return getBusinessTagDefByCode(tagDefList, tagCode) != null;
    }

    public static PcUiBotTagDefinition getBusinessTagDefByCode(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        if (org.springframework.util.CollectionUtils.isEmpty(tagDefList) || StringUtils.isBlank(tagCode)) {
            return null;
        }
        for (PcUiBotTagDefinition tagDef : tagDefList) {
            if (null != tagDef
                    && tagCode.equals(tagDef.getCode())
                    && PcUiBotTagConstant.CATEGORY_BUSINESS.equals(tagDef.getCategory())) {
                return tagDef;
            }
        }
        return null;
    }

    public static boolean existTag(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        return getTagDefByCode(tagDefList, tagCode) != null;
    }

    public static PcUiBotTagDefinition getTagDefByCode(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        if (CollectionUtils.isEmpty(tagDefList) || StringUtils.isBlank(tagCode)) {
            return null;
        }

        for (PcUiBotTagDefinition tagDef : tagDefList) {
            if (null != tagDef && tagCode.equals(tagDef.getCode())) {
                return tagDef;
            }
        }

        return null;
    }

    public static PcUiBotTagDefinition getTagDefByStartCode(List<PcUiBotTagDefinition> tagDefList, String tagCode) {
        if (CollectionUtils.isEmpty(tagDefList) || StringUtils.isBlank(tagCode)) {
            return null;
        }

        for (PcUiBotTagDefinition tagDef : tagDefList) {
            if (null != tagDef && tagDef.getCode() != null && tagDef.getCode().startsWith(tagCode)) {
                return tagDef;
            }
        }

        return null;
    }

    /**
     * 渲染对象类型字段
     *
     * @param metadataField
     * @return true：可直接渲染的object字段
     */
    public static boolean renderObjectMetadataField(PcUiBotMetadataField metadataField) {
        // 字段不是object类型
        if (!PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
            return false;
        }
        // 没打tag
        if (CollectionUtils.isEmpty(metadataField.getTagDefinitions())) {
            return false;
        }
        // 有ObjectRenderTagDefinition类型及其子类型的tag
        for (PcUiBotTagDefinition tagDef : metadataField.getTagDefinitions()) {
            if (tagDef instanceof PcUiBotObjectRenderTagDefinition) {
                // 如果PcUiBotObjectRenderTagDefinition存在多个，则全部删除
                if (metadataField.getTagDefinitions().size() > 1) {
                    removeTag(metadataField, PcUiBotTagConstant.BUSINESS_OBJECT_RENDER);
                }
                return true;
            }
        }
        // 有tree tag
        for (String tagCode : RENDER_OBJECT_TAG_CODE) {
            if (containsTagDef(metadataField.getTagDefinitions(), tagCode)) {
                return true;
            }
        }
        return false;
    }


    /**
     * 移除已经处理过的TAG
     */
    public static void removeTag(PcUiBotMetadataField metadataField, String tagCategory, String tmTagCode) {
        List<PcUiBotTagDefinition> tagDefinitions = metadataField.getTagDefinitions();
        if (CollectionUtils.isNotEmpty(tagDefinitions)) {
            Iterator<PcUiBotTagDefinition> tagDefinitionIterator = tagDefinitions.iterator();
            while (tagDefinitionIterator.hasNext()) {
                PcUiBotTagDefinition tagDefinition = tagDefinitionIterator.next();
                if (tagDefinition.getThemeMapTag() != null && tagCategory.equals(tagDefinition.getCategory()) && tmTagCode.equals(tagDefinition.getThemeMapTag().getCode())) {
                    tagDefinitionIterator.remove();
                }
            }
        }
    }


    /**
     * 移除已经处理过的TAG
     */
    public static void removeTag(PcUiBotMetadataField metadataField, String tagCode) {
        List<PcUiBotTagDefinition> tagDefinitions = metadataField.getTagDefinitions();
        if (CollectionUtils.isNotEmpty(tagDefinitions)) {
            Iterator<PcUiBotTagDefinition> tagDefinitionIterator = tagDefinitions.iterator();
            while (tagDefinitionIterator.hasNext()) {
                PcUiBotTagDefinition tagDefinition = tagDefinitionIterator.next();
                if (tagCode.equals(tagDefinition.getCode())) {
                    tagDefinitionIterator.remove();
                }
            }
        }
    }

    /**
     * 字段是否打上了 去掉输入内容前后端空格的TAG
     *
     * @param metadataField
     * @return
     */
    public static boolean tagInputEnableTrim(PcUiBotMetadataField metadataField) {
        // 理论上所有的只要是INPUT 组件，都应该去掉数据内容的前后空格
        return true;
    }

    /**
     * 特殊处理栏位只打导航Tag的场景：
     * NAVIGATE_TASK、NAVIGATE_REPORT等TAG，需要前面显示一个组件（如INPUT、SELECT等），再显示导航任务、导航报表等图标。
     * 因此如果检查到栏位tag列表中只有导航TAG，需要为该栏位添加一个默认TAG
     * （详情参考{ PcUiBotDefaultTagUtils createDataTypeDefinition(MetadataField, MetadataTagResult)}）。
     *
     * @param showMetadata 要显示的栏位
     */
    public static void handleOnlyHasNavigateTagScene(PcUiBotShowMetadata showMetadata) {
        List<PcUiBotMetadataField> showFields = showMetadata.getShowFields();
        for (PcUiBotMetadataField showField : showFields) {
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(showField.getDataType())) {
                doHandleOnlyHasNavigateTagScene(showField.getSubFields());
            }
        }
    }

    private static void doHandleOnlyHasNavigateTagScene(List<PcUiBotMetadataField> showFields) {
        for (PcUiBotMetadataField metadataField : showFields) {
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())
                    && CollectionUtils.isNotEmpty(metadataField.getSubFields())) {
                PcUiBotTagUtil.doHandleOnlyHasNavigateTagScene(metadataField.getSubFields());
            }
        }

        for (PcUiBotMetadataField showField : showFields) {
            List<PcUiBotTagDefinition> tagList = showField.getTagDefinitions();
            if (PcUiBotTagUtil.onlyHasNavigateTag(tagList)) {
                // tag列表中添加一个默认TAG
                tagList.add(0, PcUiBotDefaultTagUtils.createDataTypeDefinition(showField, null));
            }
        }
    }

    /**
     * 元数据定义上只包含导航TAG
     *
     * @param tagList
     * @return
     */
    public static boolean onlyHasNavigateTag(List<PcUiBotTagDefinition> tagList) {
        if (CollectionUtils.isEmpty(tagList)) {
            return false;
        }

        for (PcUiBotTagDefinition tag : tagList) {
            // 没有TAG定义 或 有非导航TAG定义
//            if (null == tag.getThemeMapTag() || !NAVIGATE_TAG.contains(tag.getInterpreterServiceName())) {
//                return false;
//            }
        }
        return true;
    }

    public static PcUiBotTagDefinition buildGroupTagDefinition(String suffixValue) {
        PcUiBotTagDefinition tagDefinition = buildTagDefinition(PcUiBotTagConstant.GROUP_TAG, suffixValue);
        PcUiBotThemeMapTag themeMapTag = tagDefinition.getThemeMapTag();
        themeMapTag.setCode(themeMapTag.getCategory());
        return tagDefinition;
    }

    public static PcUiBotTagDefinition buildTagDefinition(String tagCode) {
        return buildTagDefinition(tagCode, "CUSTOM");
    }

    public static PcUiBotTagDefinition buildTagDefinition(String tagCode, String suffixValue) {
        String category = tagCode.concat("_").concat(suffixValue);
        PcUiBotThemeMapTag themeMapTag = new PcUiBotThemeMapTag();
        // special
        themeMapTag.setCode(tagCode);
        themeMapTag.setName("TEST-TAG");
        themeMapTag.setCategory(category);
        themeMapTag.setUiBotCode(tagCode);

        PcUiBotTagDefinition tag = new PcUiBotTagDefinition();
        tag.setCode(tagCode);
        tag.setCategory(category);
        tag.setCustomize(Boolean.FALSE);
        tag.setThemeMapTag(themeMapTag);
        return tag;
    }

    /**
     * 获取tagCode定义
     *
     * @param tagCode
     * @return
     */
//    public static String getTagCodePure(String tagCode) {
//        List<String> split = CharSequenceUtil.split(tagCode, PcUiBotConstants.Symbol.DOUBLE_UNDERLINE);
//        if (split.size() == 3) {
//            return split.get(2);
//        }
//        return null;
//    }

    /**
     * 获取组件标签
     *
     * @param tagList
     * @return 组件标签或code="null"的空标签
     */
    public static PcUiBotThemeMapTag getComponentTagOrNull(List<PcUiBotThemeMapTag> tagList) {
        return tagList.stream()
                .filter(ele -> PcUiBotTagConstant.ComponentTagCodeEnum.isContain(ele.getCode()))
                .findFirst()
                .orElse(PcUiBotThemeMapTag.empty());
    }

    /**
     * 清理标签中包含的 角色信息
     * 例子：
     * 标签：   warehouseRack__UNEDITABLE
     * 处理结果：UNEDITABLE
     */
    public static void cleanRelationId(List<PcUiBotMetadataTagResult> metadataMetadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataMetadataTagResults) {
            if (CollectionUtils.isEmpty(metadataTagResult.getTags())) {
                continue;
            }
            for (PcUiBotThemeMapTag tag : metadataTagResult.getTags()) {
                if (StringUtils.contains(tag.getCode(), PcUiBotConstants.Symbol.DOUBLE_UNDERLINE)) {
                    tag.setCode(StringUtils.substringAfterLast(tag.getCode(), PcUiBotConstants.Symbol.DOUBLE_UNDERLINE));
                }
            }
        }
    }

}
