package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadataConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;

import java.util.Iterator;
import java.util.List;

/**
 * <p>功能描述：不可编辑</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotUnEditableTagUtils.java
 * @Author: wangjwc
 * @Date: created at 2023/10/27 16:37
 */
public class PcUiBotUnEditableTagUtils {

    public static boolean analysisTag(PcUiBotMetadataField originalMetadata) {
        boolean hasUnEditableTag = false;
        List<PcUiBotTagDefinition> tagDefinitions = originalMetadata.getTagDefinitions();
        if (CollectionUtils.isNotEmpty(tagDefinitions)) {
            Iterator<PcUiBotTagDefinition> iterator = tagDefinitions.iterator();
            while (iterator.hasNext()) {
                PcUiBotTagDefinition tagDefinitionDTO = iterator.next();
                if (tagDefinitionDTO.getThemeMapTag() != null
                        && PcUiBotTagConstant.UNEDITABLE.equals(tagDefinitionDTO.getThemeMapTag().getCode())) {
                    originalMetadata.setCanEdit(false);
                    hasUnEditableTag = true;
                    break;
                }
            }
            if (hasUnEditableTag) {
                //去除已近解析过的标签
                PcUiBotTagUtil.removeTag(originalMetadata, PcUiBotTagConstant.CATEGORY_DISPLAY, PcUiBotTagConstant.UNEDITABLE);
            }
        }
        return hasUnEditableTag;
    }

    public static boolean analysisTagNotMove(PcUiBotMetadataField originalMetadata) {
        boolean hasUnEditableTag = false;
        List<PcUiBotTagDefinition> tagDefinitions = originalMetadata.getTagDefinitions();
        if (CollectionUtils.isNotEmpty(tagDefinitions)) {
            Iterator<PcUiBotTagDefinition> iterator = tagDefinitions.iterator();
            while (iterator.hasNext()) {
                PcUiBotTagDefinition tagDefinitionDTO = iterator.next();
                if (tagDefinitionDTO.getThemeMapTag() != null
                        && PcUiBotTagConstant.UNEDITABLE.equals(tagDefinitionDTO.getThemeMapTag().getCode())) {
                    originalMetadata.setCanEdit(false);
                    hasUnEditableTag = true;
                    break;
                }
            }
        }
        return hasUnEditableTag;
    }


    /**
     * 显示字段来处理字段是否可以执行编辑状态
     *
     * @param fields
     */
    public static void analysisTag(List<PcUiBotMetadataField> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (PcUiBotMetadataField field : fields) {
            analysisTag(field);
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(field.getDataType())) {
                analysisTag(field.getSubFields());
            }
        }
    }

}
