package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

/**
 * <p>功能描述：词库对应的变量</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotWordsConstants.java
 * @Author: wangjwc
 * @Date: created at 2023/11/14 11:50
 */
public final class PcUiBotWordsConstants {

    /**
     * 业务主键的关联属性
     */
    public final static String DATAKEY_PROPERTIES = "dataKeyProperties";
    /**
     * 执行标的物目标
     */
    public final static String SUBJECT_MATTER_TARGET = "subjectMatterTargets";
    /**
     * 执行标的物
     */
    public final static String SUBJECT_MATTER = "subjectMatter";
    /**
     * 执行标物的属性
     */
    public final static String SUBJECT_MATTER_PROPERTIES = "subjectMatterProperties";
    /**
     * 执行者关注
     */
    public final static String ROLE_ATTEITION = "roleAttention";
    /**
     * 执行期望
     */
    public final static String SUBJECT_EXPECT = "subjectExpect";
    /**
     * 可编辑、执行内容
     * 执行落差量化结果
     */
    public final static String SUBJECT_SHORT_FAIL = "subjectShortfall";

    /**
     * 无头能力标识
     */
    public static final String HEADLESS_ABILITY = "HEADLESS_ABILITY";

    /**
     * 维度类型
     */
    public static class DimensionType {

        /**
         * 事-场景
         */
        public static final String CATEGORY = "CATEGORY";

        /**
         * 人-职能
         */
        public static final String DUTY = "DUTY";

        /**
         * 时
         */
        public static final String TIME = "TIME";

        /**
         * 地
         */
        public static final String PLACE = "PLACE";
    }

    /**
     * 状态：0未发布；1已发布
     */
    public static class Status {

        public static final Long UNPUBLISHED = 0L;

        public static final Long PUBLISHED = 1L;
    }

    /**
     * 用途：0-非API使用，1-API使用
     */
    public static class Purpose {

        public static final Long NOT_API = 0L;

        public static final Long API = 1L;
    }

    /**
     * 来源：0配置设计器；1手动；2其他
     */
    public static class Source {

        public static final Long DESIGNER = 0L;

        public static final Long MANUAL = 1L;

        public static final Long OTHER = 2L;
    }

}
