package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.context;/*
 * Copyright (C), 2001-2024, 鼎捷软件股份有限公司
 * FileName: com.digiwin.athena.uibot.util.runtime.context
 * Author:   杨尹(22191)
 * Date:     2024/6/28 01:08
 * Description: // 模块目的、功能描述
 * History:		// 修改记录
 * <author>		<time>		<version>		<desc>
 * 22191		2024/6/28 01:08		1.0		<描述>
 */

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @version v1.0
 * @Description: TODO
 * <p>〈功能详细描述〉</p>
 *
 * <pre>
 * 〈举例说明〉
 * </pre>
 * @ClassName RuntimeContext
 * @author xujinc
 * @date 2024/10/14 10:07
 */
public class PcUiBotRuntimeUiBotContext implements PcUiBotContext {

    private final Map<String,Object> contextMap=new HashMap<>();

    @Override
    public void put(String name, Object o) {
        contextMap.put(name,o);
    }

    @Override
    public <T> Optional<T> get(String name, Class<T> type) {
        Object o = contextMap.get(name);
        if(o!=null && (o.getClass()==type || type.isInstance(o))){
            return (Optional<T>) Optional.of(o);
        }
        return Optional.empty();
    }

    @Override
    public <T> T get(String name, Class<T> type, Function<String, T> function) {
        return get(name,type).orElseGet(new Supplier<T>() {
            @Override
            public T get() {
                T apply = function.apply(name);
                contextMap.put(name,apply);
                return apply;
            }
        });
    }

    @Override
    public void remove(String name) {
        contextMap.remove(name);
    }
}
