package com.digiwin.mobile.mobileuibot.proxy.uibot.service;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDsl;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷AgileInteraction系统代理服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotProxyService
 * @Author: Zaregoto
 * @Date: 2021/5/17 21:29
 */
public interface DigiwinPcUiBotProxyService {

    String API_PREFIX_TOP = "/api/ai/v1";
    String API_PREFIX = API_PREFIX_TOP + "/bot";
    String API_PREFIX_AGILE_REPORT = API_PREFIX_TOP + "/agile/report";

    UiBotModel getTaskTemplateShowByBacklogId(String locale, String iamUserToken, String tenantId, String backlogId,
                                              String tmTaskId, String tmActivityId, ApiRawData apiRawData);

    List<Map<String, Object>> getProjectDetailByProjectId(String locale, String iamUserToken, String tenantId, String projectId,
                                                          String tmTaskId, String tmActivityId);

    UiBotModel actionShow(String locale, String iamUserToken, String bodyPayload);


    /**
     * actionShow扩展支持请求头携带digi-proxy-token
     *
     * @param locale
     * @param tenantId
     * @param proxyToken
     * @param iamUserToken
     * @param bodyPayload
     * @return
     */
    UiBotModel actionShowByProxyToken(String locale, String tenantId, String proxyToken, String iamUserToken, String bodyPayload);

    /**
     * 根据项目类型获取项目创建 uiBot
     *
     * @param projectType
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    UiBotModel getProjectTemplateShowByType(String projectType, String iamUserToken, String tenantId, String locale);

    /**
     * NLP显示图纸
     *
     * @param tmActivityId
     * @param params
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    UiBotModel simpleShow(String tmActivityId, Map<String, Object> params, String iamUserToken, String tenantId, String locale);

    /**
     * 行事历显示手动任务详情
     *
     * @param tmActivityId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param apiRawData
     * @return
     */
    UiBotModel showUibotManualTask(String tmActivityId, String iamUserToken, String tenantId, String locale, ApiRawData apiRawData);

    /**
     * 获取异常原因第一个api返回值，作为异常原因的请求参数
     *
     * @param locale
     * @param iamUserToken
     * @param params
     * @return
     */
    Map<String, Object> getActionShowParameter(String locale, String iamUserToken, Map<String, Object> params);

    /**
     * 获取ABI报表的配置的查询条件
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param reportId
     * @return
     */
    UiBotModel conditionShow(String locale, String iamUserToken, String tenantId, String reportId);

    /**
     * 获取基础数据录入任务的详情
     *
     * @param tmActivityId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    UiBotModel basicDataTaskShow(String tmActivityId, String iamUserToken, String tenantId, String locale);

    /**
     * 获取呈现敏捷数据快照的中间态数据
     *
     * @param snapshotId   快照ID
     * @param requestParam url参数
     * @param iamUserToken 用户token
     * @param tenantId     租户id
     * @param locale       语言别
     * @return
     */
    AgileDataIntermediateDsl getAgileReportShow(String snapshotId, Map<String, String> requestParam,
                                                String iamUserToken, String tenantId, String locale);
}