package com.digiwin.mobile.mobileuibot.proxy.uibot.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDsl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinPcUiBotProxyServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/5/17 21:41
 */
@Slf4j
@Service("digiwinPcUiBotProxyService")
public class DigiwinPcUiBotProxyServiceImpl implements DigiwinPcUiBotProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public UiBotModel getTaskTemplateShowByBacklogId(String locale, String iamUserToken, String tenantId, String backlogId,
                                                     String tmTaskId, String tmActivityId, ApiRawData apiRawData) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/template/task/show/" + tmTaskId + "/" + tmActivityId + "/" + backlogId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };
        String proxyToken = "";
        boolean isTeamTask = apiRawData.getBooleanValue("isTeamTask");
        if (apiRawData != null) {
            if (apiRawData.containsKey("digi-proxy-token")) {
                proxyToken = apiRawData.getString("digi-proxy-token");
            }
            if (apiRawData.getBooleanValue("isTeamTask")) {
                // 复用pc端已有的功能：若是团队任务或被分享出去的任务，打开时只能查看，不能做任何编辑。
                url = url + "?isShared=" + isTeamTask;
            }
        }
        // TODO 这里需要注意webplatform这个参数，5月迭代因为还没有正式写mobileuibot，所以这里要假装是pc端调用接口，否则没数据
        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId, proxyToken), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        if (statusCode.is2xxSuccessful()) {
            Map<String, Object> map = responseEntity.getBody().getResponse();
            if (map != null) {
                // 移除PC的hooks属性，因为PC的hooks是数组类型，而uibotModel中hooks是map类型，导致反序列化失败
                map.remove("hooks");
            }
            UiBotModel uiBotModel = JsonUtil.objectToJavaObject(map, UiBotModel.class);
            if (isTeamTask && !CollectionUtils.isEmpty(uiBotModel.getActions())) {
                // 针对团队任务的详情数据，防止pc端处理有问题，对详情中的操作元素做清除
                uiBotModel.setActions(null);
            }
            UiBotPageData uiBotPageData = JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class);
            //新版本DSL 返回原始PageData数据
            uiBotModel.setRawUiBotPageData(uiBotPageData);
            return uiBotModel;
        } else {
            throw new ServiceException(responseEntity.getBody().getErrorMessage());
        }

    }

    @Override
    public UiBotModel getProjectTemplateShowByType(String projectType, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/template/preset-activity/show/" + projectType;
        ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), responseType);

        return getUiBotModelReturn(responseEntity);
    }

    @Override
    public UiBotModel simpleShow(String tmActivityId, Map<String, Object> params, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/template/simple/show";
        Map<String, Object> bodyPayload = new HashMap<>();
        bodyPayload.put("tmActivityId", tmActivityId);
        bodyPayload.putAll(params);
        ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(bodyPayload), responseType);

        return getUiBotModelReturn(responseEntity);
    }

    @Override
    public UiBotModel showUibotManualTask(String tmActivityId, String iamUserToken, String tenantId, String locale, ApiRawData apiRawData) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/template/task/show/__uibot__/uibotManualTask/" + tmActivityId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>>() {
                };
        String proxyToken = "";
        boolean isTeamTask = apiRawData.getBooleanValue("isTeamTask");
        if (apiRawData != null) {
            if (apiRawData.containsKey("digi-proxy-token")) {
                proxyToken = apiRawData.getString("digi-proxy-token");
            }
            if (apiRawData.getBooleanValue("isTeamTask")) {
                // 复用pc端已有的功能：若是团队任务或被分享出去的任务，打开时只能查看，不能做任何编辑。
                url = url + "?isShared=" + isTeamTask;
            }
        }

        // TODO 这里需要注意webplatform这个参数，5月迭代因为还没有正式写mobileuibot，所以这里要假装是pc端调用接口，否则没数据
        ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId, proxyToken), new HashMap<>(), responseType);

        return getUiBotModelReturn(responseEntity);
    }

    @Override
    public List<Map<String, Object>> getProjectDetailByProjectId(String locale, String iamUserToken, String tenantId,
                                                                 String projectId, String tmTaskId, String tmActivityId) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/project/detail/" + tmTaskId + "/" + tmActivityId + "/" + projectId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<Map<String, Object>>>>() {
                };

        // TODO 这里需要注意webplatform这个参数，5月迭代因为还没有正式写mobileuibot，所以这里要假装是pc端调用接口，否则没数据
        ResponseEntity<DigiwinAthenaApiResponse<List<Map<String, Object>>>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public UiBotModel actionShow(String locale, String iamUserToken, String bodyPayload) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/action/show";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>>() {
                };

        // TODO 这里需要注意webplatform这个参数，5月迭代因为还没有正式写mobileuibot，所以这里要假装是pc端调用接口，否则没数据
        ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken), bodyPayload, responseType);

        return getUiBotModelReturn(responseEntity);
    }

    @Override
    public UiBotModel actionShowByProxyToken(String locale, String tenantId, String proxyToken, String iamUserToken, String bodyPayload) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/action/show";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId, proxyToken), bodyPayload, responseType);

        return getUiBotModelReturn(responseEntity);
    }

    @Override
    public Map<String, Object> getActionShowParameter(String locale, String iamUserToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX_TOP
                + "/data/query/action";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ?
                responseEntity.getBody().getResponse() : new HashMap<>();
    }

    @Override
    public UiBotModel conditionShow(String locale, String iamUserToken, String tenantId, String reportId) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/template/statement/condition/show/" + reportId;

        ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(
                        "webplatform", locale, iamUserToken, tenantId), responseType);

        return getUiBotModelReturn(responseEntity);
    }

    @Override
    public UiBotModel basicDataTaskShow(String tmActivityId, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX
                + "/template/basic-data/show/" + tmActivityId;

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<UiBotModel>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), new HashMap<>(), responseType);

        return getUiBotModelReturn(responseEntity);
    }

    @Override
    public AgileDataIntermediateDsl getAgileReportShow(String snapshotId, Map<String, String> requestParam, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + DigiwinPcUiBotProxyService.API_PREFIX_AGILE_REPORT
                + "/show/" + snapshotId;
        if (!CollectionUtils.isEmpty(requestParam)) {
            StringBuilder queryString = new StringBuilder();
            queryString.append("?");
            for (String requestKey : requestParam.keySet()) {
                queryString.append(requestKey).append("=").append(requestParam.get(requestKey));
            }
            url += queryString.toString();
        }
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataIntermediateDsl>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataIntermediateDsl>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<AgileDataIntermediateDsl>> responseEntity =
                this.httpService.doGet(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        new HashMap<>(), responseType);
        return getAgileDataIntermediateDslReturn(responseEntity);
    }

    private UiBotModel getUiBotModelReturn(ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity) {
        HttpStatus statusCode = responseEntity.getStatusCode();

        if (statusCode.is2xxSuccessful()) {
            UiBotModel uiBotModel = responseEntity.getBody().getResponse();
            if (ObjectUtil.isNotEmpty(uiBotModel)) {
                //只有v2版本的DSL时增加
                if (MobileRenderMetaData.RENDER_VERSION_2.equals(AppRequestContext.getContextEntity().getRenderVersion())) {
                    UiBotPageData uiBotPageData = JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class);
                    //新版本DSL 返回原始PageData数据
                    uiBotModel.setRawUiBotPageData(uiBotPageData);
                }
            }
            return uiBotModel;
        } else {
            return UiBotModel.emptyUiBotModel();
        }
    }

    private AgileDataIntermediateDsl getAgileDataIntermediateDslReturn(
            ResponseEntity<DigiwinAthenaApiResponse<AgileDataIntermediateDsl>> responseEntity) {
        HttpStatus statusCode = responseEntity.getStatusCode();

        if (statusCode.is2xxSuccessful()) {
            AgileDataIntermediateDsl intermediateDsl = responseEntity.getBody().getResponse();
            if (ObjectUtil.isNotEmpty(intermediateDsl)) {
                //只有v2版本的DSL时增加
                if (MobileRenderMetaData.RENDER_VERSION_2.equals(AppRequestContext.getContextEntity().getRenderVersion())) {
                    UiBotPageData uiBotPageData = JsonUtil.objectToJavaObject(intermediateDsl.getPageData(), UiBotPageData.class);
                    //新版本DSL 返回原始PageData数据
                    intermediateDsl.setRawUiBotPageData(uiBotPageData);
                }
            }
            return intermediateDsl;
        } else {
            return new AgileDataIntermediateDsl()
                    .setErrorMessage(responseEntity.getBody().getErrorMessage());
        }
    }
}