package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AsnHeaderResponse implements Serializable {
    private static final long serialVersionUID = 8880206821059840081L;

    /**
     * 任务二维码
     */
    private String taskQrCode;
    /**
     * 任务编号
     */
    private String taskNo;
    /**
     * 任务类型编号
     */
    private String taskTypeNo;
    /**
     * 任务类型名称
     */
    private String taskTypeName;
    /**
     * 送货单号
     */
    private String deliveryNo;
    /**
     * 收货地址
     */
    private String receiptAddress;
    /**
     * 收获城市
     */
    private String receiverCityName;
    /**
     * 收货人
     */
    private String receiverName;
    /**
     * 收货人联系方式
     */
    private String receiverMobile;
    /**
     * 发货地址
     */
    private String deliveryAddress;
    /**
     * 发货城市
     */
    private String deliveryCityName;
    /**
     * 发货人
     */
    private String shipperName;
    /**
     * 发货人联系方式
     */
    private String shipperMobile;
    /**
     * 预计到货时间  yyyy-MM-dd
     */
    private String planArrivalDate;
    /**
     * 备注
     */
    private String remark;
    /**
     * 月台编号
     */
    private String platformNo;
    /**
     * 月台名称
     */
    private String platformName;
    /**
     * 预约送货日期
     */
    private String appointmentDeliveryDate;
    /**
     * 时间段
     */
    private List<TimeSlot> timeSlot;
    /**
     * 接收者的地址簿ID
     */
    private String receiptAddressId;
    /**
     * 发送者的地址簿ID
     */
    private String deliveryAddressId;

}
