package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 在途宝-车辆信息
 *
 * @author wuyang
 * @date 20220915
 */
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@NoArgsConstructor
@AllArgsConstructor
public class ZTBDriverVehicle implements Serializable {
    private static final long serialVersionUID = 5662130310431274423L;

    /**
     * 车辆信息id
     */
    private Integer vehicleInfoId;
    private Integer id;
    /**
     * 品牌型号
     */
    private String brandModelNo;
    /**
     * 车辆类型
     */
    private String vehicleType;
    /**
     * 车牌号
     */
    private String licensePlateNo;
    /**
     * 司机姓名
     */
    private String driverName;
    /**
     * 司机手机号码
     */
    private String driverMobile;
    /**
     * 载货长度
     */
    private String vehicleLength;
    /**
     * 车辆照片文件id
     */
    private String picFileId;
    /**
     * 运单号
     */
    private String transportNo;
    /**
     * 装车数量
     */
    private String loadedItemCount;
    /**
     * 是否默认车辆 TRUE：是，FALSE：否
     */
    private Boolean isDefault;
}
