package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.custom.ApiRequestZhilinkPrintData;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.CustomCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.InputScanCheckRequestData;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * 智互联相关接口
 *
 * @author zhangjj
 * @date 2021/12/16 0016 14:59
 */
@RestController
@RequestMapping("/mobile/v1/zhilink")
public class ZhilinkController {

    private static final Logger logger = LoggerFactory.getLogger(ZhilinkController.class);

    private static final String QR_CODE_RESULT = "qrCodeResult";
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private ZhilinkService zhilinkService;

    @PostMapping(value = "/printdata")
    public ApiResponse<ZhilinkBarcodeDataResponse> getZhilinkPrintData(
            @RequestBody ApiRequestZhilinkPrintData apiRequest) {
        ZhilinkBarcodeDataResponse responseData;
        // 初次调用
        if (!apiRequest.getActionDone()) {
            responseData = this.zhilinkService.generateBarcodeFirstTime(apiRequest);
        } else {
            // 再次调用
            responseData = this.zhilinkService.generateBarcodeNotFirstTime(apiRequest);
        }
        if (null != responseData) {
            // TODO 测试代码，完成后删除
            List<ZhilinkBarcodeData> testProcessData = responseData.getBarcodeData().size() > 0 ?
                    responseData.getBarcodeData().subList(0, 1) :
                    responseData.getBarcodeData();
            responseData.setBarcodeData(testProcessData);
            return ApiResponse.buildOK().setData(responseData);
        } else {
            return ApiResponse.buildError(
                    "Get Zhilink PrintData failed...current request from app is : "
                            + JsonUtil.javaObjectToJsonString(apiRequest));
        }
    }

    /**
     * 校验单号
     *
     * @return
     */
    @PostMapping(value = "/check/wo_no")
    public ApiResponse checkWoNo(
            @RequestBody InputScanCheckRequestData requestData) {
        Map<String, Object> rawData = requestData.getRawData();
        String locale = requestData.getLocale();
        //正确的单号数据集合
        List<Map<String, Object>> woDataList = (List<Map<String, Object>>) rawData.get("data");
        //校验的单号
        String checkWoNo = requestData.getQrCode();

        if (null == woDataList || woDataList.isEmpty()) {
            return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "工单数据集错误") + ", "
                    + LocaleUtil.getMobileTextByKey(locale, "校验失败"));
        }
        if (!StringUtils.hasLength(checkWoNo)) {
            return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "扫描值为空") + ", "
                    + LocaleUtil.getMobileTextByKey(locale, "校验失败"));
        }
        boolean match = woDataList.stream().anyMatch(map -> Objects.equals(checkWoNo, map.get("wo_no")));
        if (!match) {
            return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "工单不属于该物料") + ", "
                    + LocaleUtil.getMobileTextByKey(locale, "校验失败"));
        } else {
            Map resultMap = new HashMap();
            resultMap.put(QR_CODE_RESULT, checkWoNo);
            return ApiResponse.buildOK().setData(resultMap);
        }
    }

    /**
     * 校验标签
     *
     * @return
     */
    @PostMapping(value = "/check/barcode_no")
    public ApiResponse<Map> checkBarcodeNo(
            @RequestParam("type") String type, @RequestBody InputScanCheckRequestData requestData) {
        // 调用接口查询标签信息
        List<ZhilinkBarcodeData> scannedBarcodeDataList = this.haveBarcodeMsg(type, requestData);
        String locale = requestData.getLocale();

        if (CustomCodeEnum.PASTE.getValue().equals(type)) {
            //查询失败，返回失败结果--return
            if (null == scannedBarcodeDataList || scannedBarcodeDataList.isEmpty()) {
                // TODO 错误提示的国际化
                return ApiResponse.buildError(
                        LocaleUtil.getMobileTextByKey(locale, "标签贴错，并非该工单下条码"));
            }

            ZhilinkBarcodeData barcodeData = scannedBarcodeDataList.get(0);
            //查询标签信息成功，调用接口查询是否已扫描过
            boolean scanBarcodeMsg =
                    this.scanBarcodeMsg(type, requestData, barcodeData.getBarcodeNo(), "", "");
            //已扫描过，返回失败--return
            if (scanBarcodeMsg) {
                // TODO 错误提示的国际化
                return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "标签已扫描过"));
            }
            //未扫描过，调用接口插入扫描信息
            boolean insertSuccess = this.insertBarcode(type, requestData, barcodeData);
            if (insertSuccess) {
                //返回标签信息--return
                Map<String, String> map = new HashMap<>();
                map.put(QR_CODE_RESULT, barcodeData.getBarcodeNo());
                logger.debug("checkBarcodeNo type is {}, barcode_no returned {}", type,
                        barcodeData.getBarcodeNo());
                return ApiResponse.buildOK().setData(map);
            } else {
                // TODO 错误提示的国际化
                return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "标签扫描记录新增失败"));
            }
        } else if (CustomCodeEnum.CHECKOUT.getValue().equals(type)) {
            //查询失败，返回失败结果--return
            if (null == scannedBarcodeDataList || scannedBarcodeDataList.isEmpty()) {
                // TODO 错误提示的国际化
                return ApiResponse.buildError(
                        LocaleUtil.getMobileTextByKey(locale, "扫描的产品与待出厂的产品信息不符，请仔细核对"));
            }
            // 因是精确查找，所以取返回数组中的第1个元素
            ZhilinkBarcodeData scannedBarcodeData = scannedBarcodeDataList.get(0);
            String scannedBarcodeDataSoNo = scannedBarcodeData.getSoNo();
            String taskSoNo = (String) ((List<Map<String, Object>>) requestData.getRawData().get("barcode_data")).get(0).get("so_no");
            if (!Objects.equals(scannedBarcodeDataSoNo, taskSoNo)) {
                // TODO 错误提示的国际化
                return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale,
                        "扫描的条码 " + scannedBarcodeData.getBarcodeNo() + " 订单号" + scannedBarcodeDataSoNo
                                + " 不存在本次待出库订单中，请核实"));
            }
            boolean scanBarcodeMsg = this.scanBarcodeMsg(type, requestData, requestData.getQrCode(),
                    scannedBarcodeData.getSoNo(), scannedBarcodeData.getSourceNo());
            //已扫描过，返回失败--return
            if (scanBarcodeMsg) {
                // TODO 错误提示的国际化
                return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "标签已扫描过"));
            }
            //未扫描过，调用接口插入扫描信息
            boolean insertSuccess = this.insertBarcode(type, requestData, scannedBarcodeData);
            if (insertSuccess) {
                //返回标签信息--return
                Map<String, String> map = new HashMap<>();
                map.put(QR_CODE_RESULT, scannedBarcodeData.getBarcodeNo());
                logger.debug("checkBarcodeNo type is {}, barcode_no returned {}", type,
                        scannedBarcodeData.getBarcodeNo());
                return ApiResponse.buildOK().setData(map);
            } else {
                // TODO 错误提示的国际化
                return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "标签扫描记录新增失败"));
            }
        } else {
            logger.error("type NOT found in CustomCodeEnum... nothing done...");
            return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale,
                    "type NOT found in CustomCodeEnum... nothing done..."));

        }


    }

    /**
     * 建立条码暂存信息
     *
     * @param type
     * @param requestData
     * @param barcodeData
     * @return
     */
    private boolean insertBarcode(String type, InputScanCheckRequestData requestData,
                                  ZhilinkBarcodeData barcodeData) {
        Map<String, Object> rawData = requestData.getRawData();
        Map<String, Object> bodyData = new HashMap<>();
        bodyData.put("actionId", "zhilink.barcode.temp.info.create");
        bodyData.put("businessUnit", rawData.get("businessUnit"));
        bodyData.put("executeContext", rawData.get("executeContext"));

        Map<String, Object> parameter = new HashMap<>();
        List<Map<String, Object>> barcodeDataList = new ArrayList<>();

        List<Map<String, Object>> rawDataBarcodeDataList = (List<Map<String, Object>>) rawData.get("barcode_data");

        for (Map<String, Object> rawDataBarcodeDataMap : rawDataBarcodeDataList) {
            Map<String, Object> tempDataMap = new HashMap<>();
            if (CustomCodeEnum.PASTE.getValue().equals(type)) {
                tempDataMap.put("wo_no", rawDataBarcodeDataMap.get("wo_no"));
                tempDataMap.put("source_no", rawDataBarcodeDataMap.get("source_no"));
                // 固定值
                tempDataMap.put("seq_no", "1");
                // 固定值
                tempDataMap.put("operation_type", "2");
                tempDataMap.put("barcode", barcodeData.getBarcodeNo());
                tempDataMap.put("item_no", barcodeData.getItemNo());
                tempDataMap.put("item_name", barcodeData.getItemName());
                tempDataMap.put("item_spec", barcodeData.getItemSpec());
                tempDataMap.put("qty", barcodeData.getQty());
                tempDataMap.put("eoc_company_id", barcodeData.getEocCompanyId());
                tempDataMap.put("eoc_site_id", barcodeData.getEocSiteId());
                tempDataMap.put("eoc_region_id", barcodeData.getEocRegionId());
            } else if (CustomCodeEnum.CHECKOUT.getValue().equals(type)) {
                tempDataMap.put("wo_no", barcodeData.getSourceNo());
                tempDataMap.put("source_no", barcodeData.getSoNo());
                // 固定值
                tempDataMap.put("seq_no", "1");
                // 固定值
                tempDataMap.put("operation_type", "3");
                tempDataMap.put("barcode", barcodeData.getBarcodeNo());
                tempDataMap.put("item_no", barcodeData.getItemNo());
                tempDataMap.put("item_name", barcodeData.getItemName());
                tempDataMap.put("item_spec", barcodeData.getItemSpec());
                tempDataMap.put("qty", barcodeData.getQty());
                tempDataMap.put("eoc_company_id", barcodeData.getEocCompanyId());
                tempDataMap.put("eoc_site_id", barcodeData.getEocSiteId());
                tempDataMap.put("eoc_region_id", barcodeData.getEocRegionId());
            } else {
                logger.error("type NOT found in CustomCodeEnum... NO parameters added...");
            }
            barcodeDataList.add(tempDataMap);
        }

        parameter.put("barcode_data", barcodeDataList);
        bodyData.put("parameter", parameter);

        DigiwinAthenaApiResponse<Map<String, Object>> response =
                digiwinAtdmProxyService.dataQueryByActionId(requestData.getLocale(),
                        requestData.getIamUserToken(), JsonUtil.javaObjectToJsonString(bodyData), requestData.getTenantId());
        if (response == null || response.getResponse() == null) {
            return false;
        }
        Map<String, Object> map = response.getResponse();
        List barcodeDataResult = (List) map.get("barcode_data");
        if (barcodeDataResult == null || barcodeDataResult.isEmpty()) {
            return false;
        }
        return true;
    }

    /**
     * 查询是否扫描过该标签
     *
     * @param type
     * @param requestData
     * @param barcode
     * @param sourceNo
     * @param woNo
     * @return
     */
    private boolean scanBarcodeMsg(String type, InputScanCheckRequestData requestData,
                                   String barcode, String sourceNo, String woNo) {
        Map<String, Object> rawData = requestData.getRawData();
        Map<String, Object> bodyData = new HashMap<>();
        bodyData.put("actionId", "zhilink.barcode.temp.info.get");
        bodyData.put("businessUnit", rawData.get("businessUnit"));
        bodyData.put("executeContext", rawData.get("executeContext"));

        Map<String, Object> parameter = new HashMap<>();
        List<Map<String, Object>> barcodeDataList = new ArrayList<>();
        List<Map<String, Object>> rawDataBarcodeDataList = (List<Map<String, Object>>) rawData.get("barcode_data");

        for (Map<String, Object> rawDataBarcodeDataMap : rawDataBarcodeDataList) {
            Map<String, Object> tempDataMap = new HashMap<>();
            if (CustomCodeEnum.PASTE.getValue().equals(type)) {
                tempDataMap.put("barcode", barcode);
                tempDataMap.put("wo_no", rawDataBarcodeDataMap.get("wo_no"));
                // 固定值
                tempDataMap.put("operation_type", "2");
            } else if (CustomCodeEnum.CHECKOUT.getValue().equals(type)) {
                tempDataMap.put("barcode", barcode);
                tempDataMap.put("source_no", sourceNo);
                tempDataMap.put("wo_no", woNo);
                // 固定值
                tempDataMap.put("operation_type", "3");
            } else {
                logger.error("type NOT found in CustomCodeEnum... NO parameters added...");
            }
            barcodeDataList.add(tempDataMap);
        }

        parameter.put("barcode_data", barcodeDataList);
        bodyData.put("parameter", parameter);
        DigiwinAthenaApiResponse<Map<String, Object>> response =
                digiwinAtdmProxyService.dataQueryByActionId(requestData.getLocale(),
                        requestData.getIamUserToken(), JsonUtil.javaObjectToJsonString(bodyData), requestData.getTenantId());
        if (response == null || response.getResponse() == null) {
            //如果请求失败，返回true保证流程不会往下进行
            return true;
        }
        Map<String, Object> map = response.getResponse();
        List barcodeDataResult = (List) map.get("barcode_data");
        if (barcodeDataResult == null || barcodeDataResult.isEmpty()) {
            return false;
        }
        return true;
    }

    /**
     * 查询标签信息
     *
     * @param type
     * @param requestData
     * @return
     */
    private List<ZhilinkBarcodeData> haveBarcodeMsg(String type,
                                                    InputScanCheckRequestData requestData) {
        Map<String, Object> rawData = requestData.getRawData();
        Map<String, Object> bodyData = new HashMap<>();
        bodyData.put("actionId", "bm.bcsc.barcode.get");
        bodyData.put("businessUnit", rawData.get("businessUnit"));
        bodyData.put("executeContext", rawData.get("executeContext"));
        Map<String, Object> parameter = new HashMap<>();
        parameter.put("use_has_next", false);

        List<Map<String, Object>> rawDataBarcodeDataList = (List<Map<String, Object>>) rawData.get("barcode_data");
        List<Map> barcodeDataMapList = new ArrayList<>();

        for (Map<String, Object> rawDataBarcodeDataMap : rawDataBarcodeDataList) {
            Map<String, Object> tempDataMap = new HashMap<>();
            if (CustomCodeEnum.PASTE.getValue().equals(type)) {
                tempDataMap.put("barcode_url", rawDataBarcodeDataMap.get("barcode_url"));
                tempDataMap.put("source_no", rawDataBarcodeDataMap.get("wo_no"));
                tempDataMap.put("barcode_no", requestData.getQrCode());
                tempDataMap.put("item_no", rawDataBarcodeDataMap.get("item_no"));
                tempDataMap.put("sn_barcode_status", rawDataBarcodeDataMap.get("sn_barcode_status"));
                tempDataMap.put("eoc_company_id", rawDataBarcodeDataMap.get("eoc_company_id"));
                tempDataMap.put("eoc_site_id", rawDataBarcodeDataMap.get("eoc_site_id"));
            } else if (CustomCodeEnum.CHECKOUT.getValue().equals(type)) {
                tempDataMap.put("barcode_url", rawDataBarcodeDataMap.get("barcode_url"));
                tempDataMap.put("barcode_no", requestData.getQrCode());
                tempDataMap.put("item_no", rawDataBarcodeDataMap.get("item_no"));
                tempDataMap.put("sn_barcode_status", rawDataBarcodeDataMap.get("sn_barcode_status"));
                tempDataMap.put("eoc_company_id", rawDataBarcodeDataMap.get("eoc_company_id"));
                tempDataMap.put("eoc_site_id", rawDataBarcodeDataMap.get("eoc_site_id"));
            } else {
                logger.error("type NOT found in CustomCodeEnum... NO parameters added...");
            }
            barcodeDataMapList.add(tempDataMap);
        }

        parameter.put("barcode_data", barcodeDataMapList);
        bodyData.put("parameter", parameter);
        List<ZhilinkBarcodeData> barcodeDataList =
                digiwinAtdmProxyService.getBarcodeData(requestData.getLocale(),
                        requestData.getIamUserToken(), JsonUtil.javaObjectToJsonString(bodyData), requestData.getTenantId());
        return barcodeDataList;
    }

}
