package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.api.custom.ApiRequestZhilinkPrintData;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.pageable.PageableListData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.Logistics;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ZhilinkProxyService
 * @Author: Zaregoto
 * @Date: 2021/12/14 19:45
 */
public interface ZhilinkService {

    String GROUP_KEY = "#";

    Map<String, Object> woProductItemSummaryInfoGet(ApiRequest apiRequest, UiBotModel pcUiBotModel);

    ZhilinkBarcodeDataResponse generateBarcodeFirstTime(ApiRequestZhilinkPrintData apiRequest);

    ZhilinkBarcodeDataResponse generateBarcodeNotFirstTime(ApiRequestZhilinkPrintData apiRequest);

    ZhilinkBarcodeDataResponse getCheckoutBarcodeTaskDetail(ApiRequest apiRequest,
                                                            UiBotModel pcUiBotModel, Map<String, Object> bizDataItem);

    Map<String, Object> getScanRawDataInPasteDetail(UiBotModel pcUiBotModel, List<Map<String, Object>> woDataList);

    Map<String, Object> getScanRawDataInCheckoutDetail(UiBotModel pcUiBotModel, Map<String, Object> barcodeData);

    boolean updateWoInfoBeforeSubmitToAtmcInPasteTask(ApiRequestSubmit apiRequestSubmit);

    boolean updateWoInfoBeforeSubmitToAtmcInCheckoutTask(ApiRequestSubmit apiRequestSubmit);

    List<ZhilinkWoData> getWoDataListInCheckoutTask(ApiRequest apiRequest, UiBotModel pcUiBotModel, List<Map<String, Object>> bizData);

    /**
     * 通过单号查询物流信息
     *
     * @param asnHeaderResponse
     * @return
     */
    Logistics getLogisticsByTaskNo(AsnHeaderResponse asnHeaderResponse, String locale, String schema);

    /**
     * 获取单头信息
     *
     * @param taskNo
     * @param tenantId
     * @param locale
     * @param iamUserToken
     * @return
     */
    AsnHeaderResponse getAsnHeaderByTaskNo(String taskNo, String tenantId, String locale, String iamUserToken);

    /**
     * 获取个人车辆信息
     *
     * @param uiBotLayout
     * @param locale
     * @return
     */
    InputWindowSingleSelect getDriverVehicle(UiBotLayout uiBotLayout, UiBotPageData pageData, String locale);

    /**
     * 获取单身信息
     *
     * @param page_no,page_size,use_has_next
     * @param parameter
     * @param apiRequest
     * @return
     */
    PageableListData getAsnBodyByTaskNo(Integer page_no, Integer page_size, Boolean use_has_next, Map<String, Object> parameter, ApiRequest apiRequest);

    /**
     * 判断是否在途宝用户，是否加入租户，授权应用
     *
     * @param iamUserToken
     * @param locale
     * @param taskNo
     * @param userId
     * @return
     */
    Map<String, Object> joinTenant(String iamUserToken, String locale, String taskNo, String userId);

    /**
     * 扫描司机码，返回的信息
     *
     * @param resultMap
     * @param buttonRawData
     * @param codeScan
     * @param driverVehicles
     * @param cargoInformation
     * @return
     */
    Map<String, Object> buildDriverCodeResultMap(Map<String, Object> resultMap,
                                                 Map<String, Object> buttonRawData,
                                                 Map<String, Object> codeScan,
                                                 Map<String, Object> driverVehicles,
                                                 Object cargoInformation);
}
