package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.api.custom.ApiRequestZhilinkPrintData;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.AppBasePageNameEnum;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.pageable.PageableListData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.Logistics;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.component.search.Pic;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspStdData;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ZhilinkServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/12/14 21:15
 */
@Service("zhilinkService")
public class ZhilinkServiceImpl implements ZhilinkService {

    private static final Logger logger = LoggerFactory.getLogger(ZhilinkServiceImpl.class);
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;


/*    public static void main(String[] args) {
        List<ZhilinkBarcodeData> dataList = new ArrayList<>();
        ZhilinkBarcodeData b1 = new ZhilinkBarcodeData();
        b1.setWoNo("5100-202107020002");
        b1.setSourceNo("2350-202112230002-1-1");
        b1.setSeqNo(1.0);
        b1.setQty(1L);
        dataList.add(b1);

        ZhilinkBarcodeData b2 = new ZhilinkBarcodeData();
        b2.setWoNo("5100-202107020002");
        b2.setSourceNo("2350-202112230002-1-1");
        b2.setSeqNo(1.0);
        b2.setQty(2L);
        dataList.add(b2);

        ZhilinkBarcodeData b3 = new ZhilinkBarcodeData();
        b3.setWoNo("5100-202107020002");
        b3.setSourceNo("2350-202112230002-1-1");
        b3.setSeqNo(1.0);
        b3.setQty(3L);
        dataList.add(b3);

        Map<String, Long> groupedCollect = dataList.stream().collect(
            Collectors.groupingBy(e -> generateZhilinkBarcodeDataGroupKey(e),
                Collectors.summingLong(ZhilinkBarcodeData::getQty)));

        System.out.println(JsonUtil.javaObjectToJsonString(groupedCollect));
    }*/

    private static String generateZhilinkBarcodeDataGroupKey(
            ZhilinkBarcodeData zhilinkBarcodeData) {
        return zhilinkBarcodeData.getWoNo() + GROUP_KEY + zhilinkBarcodeData.getSourceNo()
                + GROUP_KEY + zhilinkBarcodeData.getSeqNo();
    }

    @Override
    public Map<String, Object> woProductItemSummaryInfoGet(ApiRequest apiRequest,
                                                           UiBotModel pcUiBotModel) {
        String dataSchema = pcUiBotModel.searchBizDataSchema();
        JSONArray parameterData =
                pcUiBotModel.getExecuteContext().getJSONObject("taskWithBacklogData").getJSONObject("bpmData")
                        .getJSONArray(dataSchema);
        JSONObject parameter = new JSONObject();
        parameter.put(dataSchema, parameterData);

        DigiwinAtdmRequest request =
                DigiwinAtdmRequest.create("zhilink.wo.product.item.summary.info.get", parameter, pcUiBotModel);
        DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse =
                this.digiwinAtdmProxyService.dataQueryByActionId(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequest.getTenantId());

        return athenaApiResponse.getResponse();
    }

    @Override
    public ZhilinkBarcodeDataResponse generateBarcodeFirstTime(
            ApiRequestZhilinkPrintData apiRequest) {
        boolean updated = this.updateWoInfoBeforePrint(apiRequest);
        if (updated) {
            return this.generateBarcode(apiRequest);
        }
        return null;
    }

    @Override
    public ZhilinkBarcodeDataResponse generateBarcodeNotFirstTime(
            ApiRequestZhilinkPrintData apiRequest) {
        return this.getBarcode(apiRequest);
    }

    @Override
    public ZhilinkBarcodeDataResponse getCheckoutBarcodeTaskDetail(ApiRequest apiRequest,
                                                                   UiBotModel pcUiBotModel, Map<String, Object> bizDataItem) {
        JSONObject parameter = new JSONObject();
        JSONArray barcodeDataArray = new JSONArray();
        JSONObject barcodeDataForRequest = new JSONObject();
        parameter.put("use_has_next", false);
        parameter.put("barcode_data", barcodeDataArray);
        barcodeDataArray.add(barcodeDataForRequest);

        JSONObject executeContextJsonObj = pcUiBotModel.getExecuteContext();
        barcodeDataForRequest.put("barcode_url",
                executeContextJsonObj.getJSONObject("taskWithBacklogData").getJSONObject("bpmData")
                        .getString("barcode_url"));
        barcodeDataForRequest.put("so_no", bizDataItem.get("so_no"));
        barcodeDataForRequest.put("sn_warehouse_no", bizDataItem.get("sn_warehouse_no"));
        barcodeDataForRequest.put("sn_barcode_status",
                this.getSnBarcodeStatusByExecuteCtx(executeContextJsonObj));
        barcodeDataForRequest.put("eoc_company_id", bizDataItem.get("eoc_company_id"));
        barcodeDataForRequest.put("eoc_site_id", bizDataItem.get("eoc_site_id"));

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.bcsc.barcode.get", parameter, pcUiBotModel);
        DigiwinAthenaApiResponse<Map<String, Object>> response =
                this.digiwinAtdmProxyService.dataQueryByActionId(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequest.getTenantId());

        return JsonUtil.objectToJavaObject(response.getResponse(),
                ZhilinkBarcodeDataResponse.class);
    }

    /**
     * 生成标签检验rawData
     *
     * @param pcUiBotModel
     * @param woDataList
     * @return
     */
    @Override
    public Map<String, Object> getScanRawDataInPasteDetail(UiBotModel pcUiBotModel,
                                                           List<Map<String, Object>> woDataList) {
        Map<String, Object> rawData = new HashMap<>();
        List<Map<String, Object>> barcodeData = new ArrayList<>();

        JSONObject taskWithBacklogData = pcUiBotModel.getExecuteContext().getJSONObject("taskWithBacklogData");
        String barcodeUrl = taskWithBacklogData.getJSONObject("bpmData").getString("barcode_url");
        for (Map<String, Object> woDataMap : woDataList) {
            Map<String, Object> barcodeDataItem = new HashMap<>(6);
            barcodeDataItem.put("barcode_url", barcodeUrl);
            barcodeDataItem.put("item_no", woDataMap.get("item_no"));
            barcodeDataItem.put("eoc_company_id", woDataMap.get("eoc_company_id"));
            barcodeDataItem.put("eoc_site_id", woDataMap.get("eoc_site_id"));
            barcodeDataItem.put("sn_barcode_status", this.getSnBarcodeStatusByExecuteCtx(pcUiBotModel.getExecuteContext()));
            barcodeDataItem.put("wo_no", woDataMap.get("wo_no"));
            barcodeDataItem.put("source_no", woDataMap.get("source_no"));

            barcodeData.add(barcodeDataItem);
        }

        rawData.put("barcode_data", barcodeData);
        rawData.put("executeContext", pcUiBotModel.getExecuteContext());
        rawData.put("businessUnit", taskWithBacklogData.getJSONObject("businessUnit"));
        return rawData;
    }

    @Override
    public Map<String, Object> getScanRawDataInCheckoutDetail(UiBotModel pcUiBotModel,
                                                              Map<String, Object> barcodeData) {
        Map<String, Object> rawData = new HashMap<>();
        List<Map<String, Object>> barcodeDataList = new ArrayList<>();

        JSONObject taskWithBacklogData = pcUiBotModel.getExecuteContext().getJSONObject("taskWithBacklogData");
        String barcodeUrl = taskWithBacklogData.getJSONObject("bpmData").getString("barcode_url");

        Map<String, Object> barcodeDataItem = new HashMap<>(6);
        barcodeDataItem.put("barcode_url", barcodeUrl);
        barcodeDataItem.put("item_no", barcodeData.get("item_no"));
        barcodeDataItem.put("eoc_company_id", barcodeData.get("eoc_company_id"));
        barcodeDataItem.put("eoc_site_id", barcodeData.get("eoc_site_id"));
        barcodeDataItem.put("sn_barcode_status", this.getSnBarcodeStatusByExecuteCtx(pcUiBotModel.getExecuteContext()));
        barcodeDataItem.put("wo_no", barcodeData.get("wo_no"));
        barcodeDataItem.put("source_no", barcodeData.get("source_no"));
        barcodeDataItem.put("so_no", barcodeData.get("so_no"));

        barcodeDataList.add(barcodeDataItem);

        rawData.put("barcode_data", barcodeDataList);
        rawData.put("executeContext", pcUiBotModel.getExecuteContext());
        rawData.put("businessUnit", taskWithBacklogData.getJSONObject("businessUnit"));
        return rawData;
    }

    @Override
    public boolean updateWoInfoBeforeSubmitToAtmcInPasteTask(ApiRequestSubmit apiRequestSubmit) {
        boolean updateResult = false;
        // 查询已扫描的标签数据
        List<ZhilinkBarcodeData> scannedBarcodeDataList =
                this.getScannedBarcodeDataInPasteTask(apiRequestSubmit);
        if (null == scannedBarcodeDataList) {
            logger.debug(
                    "getScannedBarcodeDataInPasteTask returned null...update process aborted...");
            return updateResult;
        }
        // 按照 工单号（wo_no）,订单号(source_no) ,项次(seq_no), 维度进行合并，数量累加sum(qty)
        Map<String, List<ZhilinkBarcodeData>> groupedScannedBarcodeDataList =
                scannedBarcodeDataList.stream()
                        .collect(Collectors.groupingBy(e -> generateZhilinkBarcodeDataGroupKey(e)));
        // 按分组条件求出qty的sum。
        Map<String, Long> groupedSumCollect = scannedBarcodeDataList.stream().collect(
                Collectors.groupingBy(e -> generateZhilinkBarcodeDataGroupKey(e),
                        Collectors.summingLong(ZhilinkBarcodeData::getQty)));

        // 查询工单信息
        ZhilinkWoData zhilinkWoData =
                this.getWoDataInfo(apiRequestSubmit, groupedScannedBarcodeDataList);
        if (null == zhilinkWoData) {
            logger.debug("getWoDataInfo returned null...update process aborted...");
            return updateResult;
        }
        // 更新订单信息粘贴标签数量和粘贴状态
        updateResult = this.updateWoInfoInPasteTask(apiRequestSubmit, groupedScannedBarcodeDataList,
                groupedSumCollect, zhilinkWoData);

        // 将查询到的已扫描的标签数据，【替换】原有提交数据的data中，schema使用action.submitType.schema
        this.updateDataToSubmitRequestInPasteTask(apiRequestSubmit, scannedBarcodeDataList);

        return updateResult;
    }

    @Override
    public boolean updateWoInfoBeforeSubmitToAtmcInCheckoutTask(ApiRequestSubmit apiRequestSubmit) {
        boolean updateResult = false;
        // 查询已扫描的标签数据
        List<ZhilinkBarcodeData> scannedBarcodeDataList =
                this.getScannedBarcodeDataInCheckoutTask(apiRequestSubmit);
        if (null == scannedBarcodeDataList) {
            logger.debug(
                    "getScannedBarcodeDataInCheckoutTask returned null...update process aborted...");
            return updateResult;
        }
        // 按照 工单号（wo_no）,订单号(source_no) ,项次(seq_no), 维度进行合并，数量累加sum(qty)
        Map<String, List<ZhilinkBarcodeData>> groupedScannedBarcodeDataList =
                scannedBarcodeDataList.stream()
                        .collect(Collectors.groupingBy(e -> generateZhilinkBarcodeDataGroupKey(e)));
        // 按分组条件求出qty的sum。
        Map<String, Long> groupedSumCollect = scannedBarcodeDataList.stream().collect(
                Collectors.groupingBy(e -> generateZhilinkBarcodeDataGroupKey(e),
                        Collectors.summingLong(ZhilinkBarcodeData::getQty)));

        // 查询工单信息
        ZhilinkWoData zhilinkWoData =
                this.getWoDataInfo(apiRequestSubmit, groupedScannedBarcodeDataList);
        if (null == zhilinkWoData) {
            logger.debug("getWoDataInfo returned null...update process aborted...");
            return updateResult;
        }
        // 更新订单信息出厂数量
        updateResult = this.updateWoInfoInCheckoutTask(apiRequestSubmit, groupedScannedBarcodeDataList,
                groupedSumCollect, zhilinkWoData);

        // 将查询到的已扫描的标签数据，【替换】原有提交数据的data中，schema使用action.submitType.schema
        this.updateDataToSubmitRequestInCheckoutTask(apiRequestSubmit, scannedBarcodeDataList);

        return updateResult;
    }

    @Override
    public List<ZhilinkWoData> getWoDataListInCheckoutTask(ApiRequest apiRequest,
                                                           UiBotModel pcUiBotModel, List<Map<String, Object>> bizData) {
        String dataSchema = "wo_data";

        JSONObject parameter = new JSONObject();
        JSONArray dataArray = new JSONArray();
        parameter.put(dataSchema, dataArray);

        for (Map<String, Object> bizDataItem : bizData) {
            JSONObject tempJsonObj = new JSONObject();
            tempJsonObj.put("source_no", bizDataItem.get("source_no"));

            dataArray.add(tempJsonObj);
        }

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("zhilink.wo.info.get", parameter, pcUiBotModel);
        List<ZhilinkWoData> zhilinkWoDataList =
                this.digiwinAtdmProxyService.getWoInfoData(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequest.getTenantId());
        return zhilinkWoDataList;
    }

    @Override
    public AsnHeaderResponse getAsnHeaderByTaskNo(String taskNo, String tenantId, String locale, String iamUserToken) {
        /**
         * 获取单头信息
         */
        Map<String, Object> params = new HashMap<>(1);
        params.put("task_no", taskNo);
        Map<String, Object> asnHeaderMaps = digiwinEspProxyService.getAsnHeader(iamUserToken, tenantId, locale, params);
        AsnHeaderResponse asnHeaderResponse = JsonUtil.jsonStringToObject(
                JsonUtil.javaObjectToJsonString(asnHeaderMaps), AsnHeaderResponse.class);
        return asnHeaderResponse != null ? asnHeaderResponse : null;
    }

    @Override
    public InputWindowSingleSelect getDriverVehicle(UiBotLayout uiBotLayout, UiBotPageData pageData, String locale) {
        return InputWindowSingleSelect.create(uiBotLayout, pageData, AppContext.getBaseUrl() + "/mobile/v1/proxy/window/driver/list", locale, new HashMap<>(0), true);
    }

    @Override
    public Logistics getLogisticsByTaskNo(AsnHeaderResponse asnHeaderResponse, String locale, String schema) {
        return Logistics.create(schema, locale, asnHeaderResponse, false);
    }

    @Override
    public PageableListData getAsnBodyByTaskNo(Integer page_no, Integer page_size, Boolean use_has_next, Map<String, Object> parameter, ApiRequest apiRequest) {
        /**
         * 获取单身信息
         */
        Map<String, Object> asnBodyMaps = digiwinEspProxyService.getAsnBody(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                page_no, page_size, use_has_next, parameter);
        Integer totalResults = null == asnBodyMaps.get("total_results") ? 0 :
                (Integer) asnBodyMaps.get("total_results");
        Boolean hasNext = null == asnBodyMaps.get("has_next") ? true :
                (Boolean) asnBodyMaps.get("has_next");
        List<Map<String, Object>> deliveryDetail = (List<Map<String, Object>>) asnBodyMaps.get("delivery_detail");
        PageableListData asnBodyResponse = PageableListData.create(totalResults, hasNext, deliveryDetail);
        return asnBodyResponse != null ? asnBodyResponse : null;
    }

    @Override
    public Map<String, Object> joinTenant(String iamUserToken, String locale, String taskNo, String userId) {
        Map<String, Object> data = new HashMap<>(2);
        //调用在途宝接口，加入租户，授权应用

        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.ztbJsonTenant(iamUserToken, locale, taskNo, userId);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            Action action = new Action();
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg("error: driver.join.tenant.process  code: "
                    + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
            data.put("action", action);
            data.put("isSuccess", false);
        } else {
            data.put("isSuccess", true);
        }
        return data;
    }

    @Override
    public Map<String, Object> buildDriverCodeResultMap(Map<String, Object> resultMap,
                                                        Map<String, Object> buttonRawData,
                                                        Map<String, Object> codeScan,
                                                        Map<String, Object> driverVehicles,
                                                        Object cargoInformation) {
        String size = String.valueOf(buttonRawData.get("ztbCargoUnloadingSize") == null ? 0 : buttonRawData.get("ztbCargoUnloadingSize"));
        String licensePlateNo = (String) driverVehicles.get("license_plate_no");
        String vehicleType = (String) driverVehicles.get("vehicle_type");
        String vehicleLength = (String) driverVehicles.get("vehicle_length");
        String driverMobile = (String) driverVehicles.get("driver_mobile");

        GraphicDisplay graphicDisplay = new GraphicDisplay();
        graphicDisplay.setTitle(licensePlateNo);
        graphicDisplay.setStyle(2);
        String fileId = (String) driverVehicles.get("pic_file_id");
        if (StringUtils.hasLength(fileId)) {
            ShareInfo shareInfo = digiwinDmcProxyService.shareFile(fileId, DigiwinDmcConfig.SRM_LOADING_BUCKET);
            graphicDisplay.setPics(Collections.singletonList(new Pic().setPicUrl(shareInfo.getUrl())));
        }
        List<SmartPreciseSearchField> fields = new ArrayList<>(3);
        fields.add(SmartPreciseSearchField.create(vehicleType, 2));
        fields.add(SmartPreciseSearchField.create(vehicleLength, 2));
        if (StringUtils.hasLength(driverMobile)) {
            fields.add(SmartPreciseSearchField.create(driverMobile, 2, 58908));
        }
        graphicDisplay.setFields(fields);
        Map<String, Object> result = new HashMap<>(3);
        result.put("GRAPHIC_DISPLAY", graphicDisplay);
        result.put("ztbCargoUnloadingSize", StringUtils.hasLength(size) ? size : 0);
        result.put("cargo_information", cargoInformation == null ? Collections.emptyList() : cargoInformation);
        result.put("type", 1);
        resultMap.put("result", result);
        Action action = new Action();
        action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/car/loading/submit");
        action.setJumpPageId(AppBasePageNameEnum.MOBILE_ZTB_DRIVER_CAR_QR_CODE.getValue());
        action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        Map<String, Object> actionRawData = new HashMap<>(5);
        actionRawData.putAll(codeScan);
        buttonRawData.put("bizType", QrCodeContentMsg.BIZ_TYPE_BAR_CODE);
        actionRawData.putAll(buttonRawData);
        action.setRawData(actionRawData);
        resultMap.put("action", action);

        return resultMap;
    }

    /**
     * 在粘贴任务的提交逻辑中，获取已扫码的数据
     *
     * @param apiRequestSubmit
     * @return
     */
    private List<ZhilinkBarcodeData> getScannedBarcodeDataInPasteTask(
            ApiRequestSubmit apiRequestSubmit) {
        String submitDataSchema = "wo_data";
        String requestDataSchema = "barcode_data";

        JSONObject rawDataData = apiRequestSubmit.getRawData().getJSONObject("data");
        // 实际的物料数据数组
        JSONArray rawDataDataSchemaData = rawDataData.getJSONArray(submitDataSchema);
        // 最终请求API的工单数据数组
        JSONArray rawDataDataSchemaDataWoData = new JSONArray();

        for (int i = 0; i < rawDataDataSchemaData.size(); i++) {
            JSONObject tempJsonObj = rawDataDataSchemaData.getJSONObject(i);
            rawDataDataSchemaDataWoData.addAll(tempJsonObj.getJSONArray(submitDataSchema));
        }

        JSONObject parameter = new JSONObject();
        JSONArray dataArray = new JSONArray();

        parameter.put(requestDataSchema, dataArray);

        for (int i = 0; i < rawDataDataSchemaDataWoData.size(); i++) {
            JSONObject woDataJsonObj = rawDataDataSchemaDataWoData.getJSONObject(i);
            JSONObject dataForRequest = new JSONObject();
            dataForRequest.put("wo_no", woDataJsonObj.getString("wo_no"));
            dataForRequest.put("operation_type", "2");

            dataArray.add(dataForRequest);
        }

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create(
                "zhilink.barcode.temp.info.get", parameter, apiRequestSubmit);
        List<ZhilinkBarcodeData> scannedBarcodeDataList =
                this.digiwinAtdmProxyService.getBarcodeData(apiRequestSubmit.getLocale(),
                        apiRequestSubmit.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequestSubmit.getTenantId());

        return scannedBarcodeDataList;
    }

    /**
     * 在出厂任务的提交逻辑中，获取已扫码的数据
     *
     * @param apiRequestSubmit
     * @return
     */
    private List<ZhilinkBarcodeData> getScannedBarcodeDataInCheckoutTask(ApiRequestSubmit apiRequestSubmit) {
        String submitDataSchema = "wo_data";
        String requestDataSchema = "barcode_data";

        JSONObject rawDataData = apiRequestSubmit.getRawData().getJSONObject("data");
        // 实际的物料数据数组
        JSONArray rawDataDataSchemaData = rawDataData.getJSONArray(submitDataSchema);
        // 最终请求API的工单数据数组
        JSONArray rawDataDataSchemaDataWoData = new JSONArray();

        for (int i = 0; i < rawDataDataSchemaData.size(); i++) {
            JSONObject tempJsonObj = rawDataDataSchemaData.getJSONObject(i);
            rawDataDataSchemaDataWoData.addAll(tempJsonObj.getJSONArray(submitDataSchema));
        }

        JSONObject parameter = new JSONObject();
        JSONArray dataArray = new JSONArray();

        parameter.put(requestDataSchema, dataArray);

        for (int i = 0; i < rawDataDataSchemaDataWoData.size(); i++) {
            JSONObject woDataJsonObj = rawDataDataSchemaDataWoData.getJSONObject(i);
            JSONObject dataForRequest = new JSONObject();
            dataForRequest.put("wo_no", woDataJsonObj.getString("wo_no"));
            dataForRequest.put("source_no", woDataJsonObj.getString("so_no"));
            dataForRequest.put("operation_type", "3");

            dataArray.add(dataForRequest);
        }

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create(
                "zhilink.barcode.temp.info.get", parameter, apiRequestSubmit);
        List<ZhilinkBarcodeData> scannedBarcodeDataList =
                this.digiwinAtdmProxyService.getBarcodeData(apiRequestSubmit.getLocale(),
                        apiRequestSubmit.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequestSubmit.getTenantId());

        return scannedBarcodeDataList;
    }

    private ZhilinkWoData getWoDataInfo(ApiRequestSubmit apiRequestSubmit,
                                        Map<String, List<ZhilinkBarcodeData>> groupedScannedBarcodeDataList) {
        String dataSchema = "wo_data";

        JSONObject parameter = new JSONObject();
        JSONArray dataArray = new JSONArray();

        parameter.put(dataSchema, dataArray);

        for (String s : groupedScannedBarcodeDataList.keySet()) {
            // 参考本类方法：generateZhilinkBarcodeDataGroupKey
            String[] spilttedKey = s.split(GROUP_KEY);
            JSONObject dataForRequest = new JSONObject();
            dataForRequest.put("wo_no", spilttedKey[0]);
            dataForRequest.put("source_no", spilttedKey[1]);
            dataForRequest.put("source_seq", spilttedKey[2]);

            dataArray.add(dataForRequest);
        }

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("zhilink.wo.info.get", parameter, apiRequestSubmit);
        List<ZhilinkWoData> zhilinkWoDataList =
                this.digiwinAtdmProxyService.getWoInfoData(apiRequestSubmit.getLocale(),
                        apiRequestSubmit.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequestSubmit.getTenantId());
        if (null == zhilinkWoDataList || zhilinkWoDataList.isEmpty()) {
            return null;
        }

        return zhilinkWoDataList.get(0);
    }

    /**
     * 粘贴任务中，更新工单信息
     *
     * @param apiRequestSubmit
     * @param groupedScannedBarcodeDataList 分组后的数据
     * @param groupedSumCollect             分组后求和的数据
     * @param zhilinkWoData                 查询到的工单数据
     * @return
     */
    private boolean updateWoInfoInPasteTask(ApiRequestSubmit apiRequestSubmit,
                                            Map<String, List<ZhilinkBarcodeData>> groupedScannedBarcodeDataList,
                                            Map<String, Long> groupedSumCollect, ZhilinkWoData zhilinkWoData) {
        String dataSchema = "wo_data";

        JSONObject parameter = new JSONObject();
        JSONArray woDataArray = new JSONArray();
        parameter.put(dataSchema, woDataArray);

        for (String key : groupedScannedBarcodeDataList.keySet()) {
            // 取第1个是因为做了分组后，属性都相同
            ZhilinkBarcodeData barcodeDataForRequest =
                    groupedScannedBarcodeDataList.get(key).get(0);
            JSONObject woDataForRequest = new JSONObject();
            woDataForRequest.put("wo_no", barcodeDataForRequest.getWoNo());
            woDataForRequest.put("source_no", barcodeDataForRequest.getSourceNo());
            woDataForRequest.put("source_seq", barcodeDataForRequest.getSeqNo());
            woDataForRequest.put("qty", groupedSumCollect.get(key));
            woDataForRequest.put("type", "2");
            woDataForRequest.put("id", zhilinkWoData.getId());

            woDataArray.add(woDataForRequest);
        }

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("zhilink.wo.info.update", parameter, apiRequestSubmit);
        DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse =
                this.digiwinAtdmProxyService.dataQueryByActionId(apiRequestSubmit.getLocale(),
                        apiRequestSubmit.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequestSubmit.getTenantId());

        return athenaApiResponse.getStatus() == HttpStatus.OK.value();
    }

    /**
     * 出厂任务中，更新工单信息
     *
     * @param apiRequestSubmit
     * @param groupedScannedBarcodeDataList 分组后的数据
     * @param groupedSumCollect             分组后求和的数据
     * @param zhilinkWoData                 查询到的工单数据
     * @return
     */
    private boolean updateWoInfoInCheckoutTask(ApiRequestSubmit apiRequestSubmit,
                                               Map<String, List<ZhilinkBarcodeData>> groupedScannedBarcodeDataList,
                                               Map<String, Long> groupedSumCollect, ZhilinkWoData zhilinkWoData) {
        String dataSchema = "wo_data";

        JSONObject parameter = new JSONObject();
        JSONArray woDataArray = new JSONArray();
        parameter.put(dataSchema, woDataArray);

        for (String key : groupedScannedBarcodeDataList.keySet()) {
            // 取第1个是因为做了分组后，属性都相同
            ZhilinkBarcodeData barcodeDataForRequest =
                    groupedScannedBarcodeDataList.get(key).get(0);
            JSONObject woDataForRequest = new JSONObject();
            woDataForRequest.put("wo_no", barcodeDataForRequest.getWoNo());
            woDataForRequest.put("source_no", barcodeDataForRequest.getSourceNo());
            woDataForRequest.put("source_seq", barcodeDataForRequest.getSeqNo());
            woDataForRequest.put("qty", groupedSumCollect.get(key));
            woDataForRequest.put("type", "3");
            woDataForRequest.put("id", zhilinkWoData.getId());

            woDataArray.add(woDataForRequest);
        }

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create(
                "zhilink.wo.info.update", parameter, apiRequestSubmit);
        DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse =
                this.digiwinAtdmProxyService.dataQueryByActionId(apiRequestSubmit.getLocale(),
                        apiRequestSubmit.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequestSubmit.getTenantId());

        return athenaApiResponse.getStatus() == HttpStatus.OK.value();
    }

    private boolean updateWoInfoBeforePrint(ApiRequest apiRequest) {
        JSONObject executeContextJsonObj = apiRequest.getRawData().getJSONObject("executeContext");
        JSONObject dataJsonObj = apiRequest.getRawData().getJSONObject("data");
        String dataSchema = "wo_data";
        JSONArray dataDataJsonArray = dataJsonObj.getJSONArray(dataSchema);

        JSONObject parameter = new JSONObject();
        JSONArray woDataArray = new JSONArray();
        parameter.put(dataSchema, woDataArray);

        for (int i = 0; i < dataDataJsonArray.size(); i++) {
            JSONObject tempJsonObj = dataDataJsonArray.getJSONObject(i);

            JSONObject woDataForRequest = new JSONObject();
            woDataForRequest.put("id", tempJsonObj.getIntValue("id"));
            woDataForRequest.put("wo_no", tempJsonObj.getString("wo_no"));
            woDataForRequest.put("source_no", tempJsonObj.getString("source_no"));
            woDataForRequest.put("source_seq", tempJsonObj.getString("source_seq"));
            woDataForRequest.put("qty", tempJsonObj.getIntValue("source_qty"));
            woDataForRequest.put("type", "0");

            woDataArray.add(woDataForRequest);
        }


        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("zhilink.wo.info.update",
                parameter,
                executeContextJsonObj.toJavaObject(Map.class),
                executeContextJsonObj.getJSONObject("businessUnit").toJavaObject(Map.class)
        );
        DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse =
                this.digiwinAtdmProxyService.dataQueryByActionId(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequest.getTenantId());

        return athenaApiResponse.getStatus() == HttpStatus.OK.value();
    }

    private ZhilinkBarcodeDataResponse generateBarcode(ApiRequest apiRequest) {
        JSONObject executeContextJsonObj = apiRequest.getRawData().getJSONObject("executeContext");
        JSONObject dataJsonObj = apiRequest.getRawData().getJSONObject("data");
        String dataSchema = "wo_data";
        JSONArray dataDataJsonArray = dataJsonObj.getJSONArray(dataSchema);

        JSONObject parameter = new JSONObject();
        JSONArray barcodeDataArray = new JSONArray();
        parameter.put("barcode_data", barcodeDataArray);

        for (int i = 0; i < dataDataJsonArray.size(); i++) {
            JSONObject tempJsonObj = dataDataJsonArray.getJSONObject(i);

            JSONObject barcodeDataForRequest = new JSONObject();
            barcodeDataForRequest.put("barcode_url",
                    executeContextJsonObj.getJSONObject("taskWithBacklogData").getJSONObject("bpmData")
                            .getString("barcode_url"));
            barcodeDataForRequest.put("barcode_type", "3");
            barcodeDataForRequest.put("barcode_rule", "");
            barcodeDataForRequest.put("item_no", tempJsonObj.getString("item_no"));
            barcodeDataForRequest.put("item_name", tempJsonObj.getString("item_name"));
            barcodeDataForRequest.put("item_spec", tempJsonObj.getString("item_spec"));
            barcodeDataForRequest.put("item_feature_no", "");
            barcodeDataForRequest.put("qty", tempJsonObj.getIntValue("source_qty"));
            barcodeDataForRequest.put("package_qty", 1);
            barcodeDataForRequest.put("unit_no", tempJsonObj.getString("unit_no"));
            barcodeDataForRequest.put("unit_name", tempJsonObj.getString("unit_name"));
            barcodeDataForRequest.put("customer_no", tempJsonObj.getString("customer_no"));
            barcodeDataForRequest.put("customer_name", tempJsonObj.getString("customer_name"));
            barcodeDataForRequest.put("source_type", "1");
            barcodeDataForRequest.put("source_no", tempJsonObj.getString("wo_no"));
            barcodeDataForRequest.put("source_seq", tempJsonObj.getIntValue("source_seq"));
            barcodeDataForRequest.put("so_no", tempJsonObj.getString("source_no"));
            barcodeDataForRequest.put("production_date", DateTimeUtil.getTodayUseSpecifiedPattern("yyyyMMdd"));
            barcodeDataForRequest.put("plan_out_factory_date", tempJsonObj.getString("plan_delivery_date"));
            barcodeDataForRequest.put("sn_warehouse_no", tempJsonObj.getString("warehouse_no"));
            barcodeDataForRequest.put("sn_warehouse_name", tempJsonObj.getString("warehouse_name"));
            barcodeDataForRequest.put("sn_barcode_status",
                    this.getSnBarcodeStatusByExecuteCtx(apiRequest.getRawData().getJSONObject("executeContext")));
            barcodeDataForRequest.put("eoc_company_id", tempJsonObj.getString("eoc_company_id"));
            barcodeDataForRequest.put("eoc_site_id", tempJsonObj.getString("eoc_site_id"));

            barcodeDataArray.add(barcodeDataForRequest);
        }


        DigiwinAtdmRequest request =
                DigiwinAtdmRequest.create("bm.bcsc.auto.generate.barcode.process",
                        parameter,
                        executeContextJsonObj.toJavaObject(Map.class),
                        executeContextJsonObj.getJSONObject("businessUnit").toJavaObject(Map.class)
                );
        DigiwinAthenaApiResponse<Map<String, Object>> response =
                this.digiwinAtdmProxyService.dataQueryByActionId(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequest.getTenantId());

        return JsonUtil.objectToJavaObject(response.getResponse(),
                ZhilinkBarcodeDataResponse.class);
    }

    /**
     * 补打功能数据接口。通过查询bm.bcsc.barcode.get接口，获取已经生成的条码数据。
     * 注意不同任务类型，调用该接口的sn_barcode_status不同
     *
     * @param apiRequest
     * @return
     */
    private ZhilinkBarcodeDataResponse getBarcode(ApiRequest apiRequest) {
        JSONObject executeContextJsonObj = apiRequest.getRawData().getJSONObject("executeContext");
        JSONObject dataJsonObj = apiRequest.getRawData().getJSONObject("data");
        String dataSchema = "wo_data";
        JSONArray dataDataJsonArray = dataJsonObj.getJSONArray(dataSchema);

        JSONObject parameter = new JSONObject();
        JSONArray barcodeDataArray = new JSONArray();
        parameter.put("barcode_data", barcodeDataArray);

        for (int i = 0; i < dataDataJsonArray.size(); i++) {
            JSONObject tempJsonObj = dataDataJsonArray.getJSONObject(i);

            JSONObject barcodeDataForRequest = new JSONObject();
            barcodeDataForRequest.put("barcode_url",
                    executeContextJsonObj.getJSONObject("taskWithBacklogData").getJSONObject("bpmData")
                            .getString("barcode_url"));
            barcodeDataForRequest.put("source_no", tempJsonObj.getString("wo_no"));
            barcodeDataForRequest.put("item_no", tempJsonObj.getString("item_no"));
            barcodeDataForRequest.put("sn_barcode_status",
                    this.getSnBarcodeStatusByExecuteCtx(apiRequest.getRawData().getJSONObject("executeContext")));
            barcodeDataForRequest.put("eoc_company_id", tempJsonObj.getString("eoc_company_id"));
            barcodeDataForRequest.put("eoc_site_id", tempJsonObj.getString("eoc_site_id"));

            barcodeDataArray.add(barcodeDataForRequest);
        }

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.bcsc.barcode.get",
                parameter,
                executeContextJsonObj.toJavaObject(Map.class),
                executeContextJsonObj.getJSONObject("businessUnit").toJavaObject(Map.class)
        );
        DigiwinAthenaApiResponse<Map<String, Object>> response =
                this.digiwinAtdmProxyService.dataQueryByActionId(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequest.getTenantId());

        return JsonUtil.objectToJavaObject(response.getResponse(),
                ZhilinkBarcodeDataResponse.class);
    }


    /**
     * 根据PC的上下文数据，判断当前的任务类型，返回对应的sn_barcode_status的值
     *
     * @param executeContextJsonObj
     * @return
     */
    private String getSnBarcodeStatusByExecuteCtx(JSONObject executeContextJsonObj) {
        String snBarcodeStatus = "";
        if (null == executeContextJsonObj) {
            return snBarcodeStatus;
        }
        String tmProjectId = executeContextJsonObj.getString("tmProjectId");
        String tmActivityId = executeContextJsonObj.getString("tmActivityId");
        if (TaskStringUtil.isZhilinkBarCodePrint(tmProjectId, tmActivityId)) {
            snBarcodeStatus = "0";
        } else if (TaskStringUtil.isZhilinkBarCodePaste(tmProjectId, tmActivityId)) {
            snBarcodeStatus = "10";
        } else if (TaskStringUtil.isZhilinkBarCodeCheckout(tmProjectId, tmActivityId)) {
            snBarcodeStatus = "20";
        }

        return snBarcodeStatus;
    }

    /**
     * 粘贴任务中，将查询到的已扫描的标签数据，替换原有提交数据的data中，schema使用action.submitType.schema
     *
     * @param apiRequestSubmit
     * @param data
     */
    private void updateDataToSubmitRequestInPasteTask(ApiRequestSubmit apiRequestSubmit, Object data) {
        JSONObject rawDataData = apiRequestSubmit.getRawData().getJSONObject("data");
        JSONObject rawDataAction = apiRequestSubmit.getRawData().getJSONObject("action");
        String submitRequestDataSchema = rawDataAction.getJSONObject("submitType").getString("schema");

        rawDataData.clear();
        rawDataData.put(submitRequestDataSchema, data);

        logger.debug("updateDataToSubmitRequestInPasteTask done...submitRequestDataSchema is {}",
                submitRequestDataSchema);
    }

    /**
     * 出厂任务中，将查询到的已扫描的标签数据，替换原有提交数据的data中，schema使用action.submitType.schema
     *
     * @param apiRequestSubmit
     * @param data
     */
    private void updateDataToSubmitRequestInCheckoutTask(ApiRequestSubmit apiRequestSubmit, Object data) {
        JSONObject rawDataData = apiRequestSubmit.getRawData().getJSONObject("data");
        JSONObject rawDataAction = apiRequestSubmit.getRawData().getJSONObject("action");
        String submitRequestDataSchema = rawDataAction.getJSONObject("submitType").getString("schema");

        rawDataData.clear();
        rawDataData.put(submitRequestDataSchema, data);

        logger.debug("updateDataToSubmitRequestInCheckoutTask done...submitRequestDataSchema is {}",
                submitRequestDataSchema);
    }
}
