package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.floating.FloatingLayer;
import com.digiwin.mobile.mobileuibot.core.component.floating.FloatingLayerData;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild.UiBotModelBuildZTBCarCodeStrategy;
import com.digiwin.mobile.mobileuibot.task.model.TaskExtraParameter;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 在途宝相关接口
 *
 * @author zhangjj
 * @date 2022/11/24 10:32
 */
@Slf4j
@RestController
@RequestMapping(value = "/mobile/v1/ztb")
public class ZhilinkZTBController {

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Autowired
    private UiBotModelBuildZTBCarCodeStrategy uiBotModelBuildZTBCarCodeStrategy;

    @Autowired
    private TaskService taskService;

    @Autowired
    private PageTaskRelationService pageTaskRelationService;

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private ActivityFilterService activityFilterService;

    /**
     * 获取货物信息
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @PostMapping(value = "/cargo/information")
    public ApiResponse<Map<String, Object>> getCargoInformation(
            @RequestBody ApiRequest apiRequest) throws IOException {
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        //当前页，默认1
        Integer pageNo = null == apiRequest.getPageNum() ? 1 : apiRequest.getPageNum();
        //请求笔数，默认10
        Integer pageSize = null == apiRequest.getPageSize() ? 10 : apiRequest.getPageSize();
        Map<String, Object> parameter = new HashMap<>();
        List<Map<String, Object>> dataList;
        Boolean hasNext;
        Integer total;
        //任务编号，必要参数
        String taskNo = (String) rawData.get("task_no");
        String transportNo = (String) rawData.get("transport_no");
        //品号
        String itemNo;
        //品名
        String itemName;
        //规格
        String itemSpec;
        //数量
        String itemQty;
        //单位
        String itemUnit;
        String qtyLabel;
        if (rawData.get("type") != null && "isTransport".equalsIgnoreCase((String) rawData.get("type"))) {
            Map<String, Object> cargoInformation = digiwinEspProxyService.getTransportCargoInfo(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), locale, transportNo, pageNo, pageSize, true);
            hasNext = (Boolean) cargoInformation.get("has_next");
            total = (Integer) cargoInformation.get("total_results");
            dataList = (List<Map<String, Object>>) cargoInformation.get("cargo_information");
//            itemNo = "item_no";
//            itemName = "item_name";
//            itemSpec = "item_spec";
//            itemQty = "item_qty";
//            itemUnit = "item_unit";
            itemNo = "item_no";
            itemName = "item_name";
            itemSpec = "item_spec";
//            itemQty = "delivery_qty";
            itemQty = "transport_qty";
            itemUnit = "unit_name";
            qtyLabel = "装车数量";
        } else {
            parameter.put("task_no", taskNo);
            //true：只获取未装车货物；false：获取所有货物
            parameter.put("is_filter_load_car", rawData.get("isLoadCar"));
            //根据请求获取api数据
            Map<String, Object> asnBodyMaps = digiwinEspProxyService.getAsnBody(
                    apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                    pageNo, pageSize, true, parameter);
            dataList = (List) asnBodyMaps.get("delivery_detail");
            hasNext = (Boolean) asnBodyMaps.get("has_next");
            total = (Integer) asnBodyMaps.get("total_results");
            itemNo = "item_no";
            itemName = "item_name";
            itemSpec = "item_spec";
            itemQty = "delivery_qty";
            itemUnit = "unit_name";
            qtyLabel = "数量";
        }

        Map<String, Object> resultData = new HashMap<>(3);
        resultData.put("total", total);
        resultData.put("hasNext", hasNext);
        List<Map<String, Object>> resultdataList = new ArrayList<>(dataList.size());
        resultData.put("dataList", resultdataList);
        if (CollectionUtils.isEmpty(dataList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        dataList.forEach(delivery -> {
            Map<String, Object> map = new HashMap<>();
            resultdataList.add(map);
            map.put("dataId", String.valueOf(delivery.get(itemNo)));
            map.put("title", delivery.get(itemName));
            List<Map<String, Object>> content = new ArrayList<>();
            map.put("content", content);
//            Map<String, Object> itemSpecMap = new HashMap<>();
//            //规格
//            itemSpecMap.put("label", localeService.getLanguageValue(locale, "规格"));
//            itemSpecMap.put("value", StringUtils.hasLength((String) delivery.get(itemSpec)) ? (String) delivery.get(itemSpec) : "-");
//            content.add(itemSpecMap);
            //数量
            Map<String, Object> qtyMap = new HashMap<>();
            qtyMap.put("label", localeService.getLanguageValue(locale, qtyLabel));
            Double deliveryQtyDouble = 0.0;
            if (delivery.get(itemQty) != null) {
                deliveryQtyDouble = Double.parseDouble(delivery.get(itemQty).toString());
            }
            String qty = deliveryQtyDouble.toString() + (delivery.get(itemUnit) == null ? "" : (String) delivery.get(itemUnit));
            qtyMap.put("value", qty);
            // 0：一行显示...  1：换行显示
            qtyMap.put("valueStyleType", 1);
            content.add(qtyMap);
            Map<String, Object> detail = new HashMap<>(5);
            if (StringUtils.hasLength(taskNo)) {
                detail.put("task_no", taskNo);
                detail.put("item_no", delivery.get("item_no"));
                detail.put("delivery_no", delivery.get("delivery_no"));
                detail.put("delivery_seq", delivery.get("delivery_seq"));
                detail.put("delivery_qty", delivery.get("delivery_qty"));
            }
            map.put("detail", detail);
        });
        return ApiResponse.buildOK().setData(resultData);
    }

    /**
     * 获取车辆信息
     *
     * @param apiRequest
     * @return
     */
    @PostMapping(value = "/vehicle/information")
    public ApiResponse<Map<String, Object>> getVehicleInformation(@RequestBody ApiRequest apiRequest) {
        //todo 要区分获取全部车辆还是未装车的车辆,支持搜索
        Map<String, Object> resultData = new HashMap<>();
        String locale = apiRequest.getLocale();
        String queryCondition = apiRequest.getQueryCondition();
        String taskNo = (String) apiRequest.getRawData().get("task_no");
        Boolean isLoadCar = (Boolean) apiRequest.getRawData().get("is_load_car");
        List<Map<String, Object>> vehicleList = digiwinEspProxyService.getVehicleInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), taskNo, isLoadCar, queryCondition);
        if (CollectionUtils.isEmpty(vehicleList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        List<Map<String, Object>> dataList = new ArrayList<>();
        resultData.put("dataList", dataList);
        if (CollectionUtils.isEmpty(vehicleList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        for (Map<String, Object> vehicle : vehicleList) {
            Map<String, Object> map = new HashMap<>();
            dataList.add(map);
            map.put("title", vehicle.get("license_plate_no"));
            map.put("dataId", String.valueOf(vehicle.get("vehicle_info_id")));
            List<Map<String, Object>> content = new ArrayList<>();
            map.put("content", content);
            //车辆类型
            Map<String, Object> vehicleTypeMap = new HashMap<>();
            vehicleTypeMap.put("label", localeService.getLanguageValue(locale, "车辆类型"));
            vehicleTypeMap.put("value", vehicle.get("vehicle_type"));
            content.add(vehicleTypeMap);
            //载货长度
            Map<String, Object> vehicleLengthMap = new HashMap<>();
            vehicleLengthMap.put("label", localeService.getLanguageValue(locale, "载货长度"));
            vehicleLengthMap.put("value", vehicle.get("vehicle_length"));
            content.add(vehicleLengthMap);
            Map<String, Object> detail = new HashMap<>();
            detail.put("license_plate_no", vehicle.get("license_plate_no"));
            detail.put("vehicle_type", vehicle.get("vehicle_type"));
            detail.put("vehicle_length", vehicle.get("vehicle_length"));
            map.put("detail", detail);
        }
        return ApiResponse.buildOK().setData(resultData);
    }

    /**
     * 获取我的车辆列表
     *
     * @param apiRequest
     * @return
     */
    @PostMapping(value = "/vehicle/list")
    public ApiResponse<Map<String, Object>> carListGet(@RequestBody ApiRequest apiRequest) {
        Map<String, Object> resultData = new HashMap<>();
        String locale = apiRequest.getLocale();
        List<Map<String, Object>> vehicleList = digiwinEspProxyService
                .getDriverVehicle(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, null);
        if (CollectionUtils.isEmpty(vehicleList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        List<Map<String, Object>> dataList = new ArrayList<>();
        resultData.put("dataList", dataList);
        if (CollectionUtils.isEmpty(vehicleList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        for (Map<String, Object> vehicle : vehicleList) {
            Map<String, Object> map = new HashMap<>();
            if ("true".equals(StringUtil.valueOf(vehicle.get("is_default")))) {
                dataList.add(0, map);
            } else {
                dataList.add(map);
            }
            List<Field> content = new ArrayList<>();
            map.put("content", content);
            // 车牌号码
            Field licensePlateNoField =
                    Field.createLabelValueLeftField("", StringUtil.valueOf(vehicle.get("license_plate_no")));
            Action<Map<String, Object>> editAction = new Action<>();
            editAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "更新车辆信息"));
            editAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_CAR_MESSAGE.name());
            editAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            Map<String, Object> editRawData = new HashMap<>(1);
            editRawData.put("editId", StringUtil.valueOf(vehicle.get("vehicle_info_id")));
            editAction.setRawData(editRawData);
            licensePlateNoField.setAction(editAction);
            content.add(licensePlateNoField);
            //车辆类型
            content.add(Field.createLabelValueLeftField(localeService.getLanguageValue(locale, "车辆类型"),
                    StringUtil.valueOf(vehicle.get("vehicle_type"))));
            //载货长度
            content.add(Field.createLabelValueLeftField(localeService.getLanguageValue(locale, "载货长度"),
                    StringUtil.valueOf(vehicle.get("vehicle_length"))));
            String picFileId = StringUtil.valueOf(vehicle.get("pic_file_id"));
            map.put("fileId", picFileId);
            if (StringUtils.hasLength(picFileId)) {
                ShareInfo shareInfo = digiwinDmcProxyService.shareFile(picFileId, DigiwinDmcConfig.SRM_LOADING_BUCKET);
                map.put("picUrl", shareInfo.getUrl());
            }
            Button carCodeButton = new Button();
            Action<Map<String, Object>> action = new Action<>();
            action.setType(ActionTypeEnum.POP_PROMPT_REQUEST.getValue());
            action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/ztb/vehicle/qrCode");
            Map<String, Object> carCodeRawData = new HashMap<>(1);
            editRawData.put("editId", StringUtil.valueOf(vehicle.get("vehicle_info_id")));
            action.setRawData(carCodeRawData);
            carCodeButton.setAction(action);
            map.put("carCodeButton", carCodeButton);
            map.put("isDefault", vehicle.get("is_default"));
        }
        return ApiResponse.buildOK().setData(resultData);
    }


    /**
     * 获取电子围栏列表
     *
     * @param apiRequest
     * @return
     */
    @PostMapping(value = "/electronicFence/list")
    public ApiResponse<Map<String, Object>> electronicFenceListGet(@RequestBody ApiRequest apiRequest) {
        Map<String, Object> resultData = new HashMap<>();
        String locale = apiRequest.getLocale();
        List<Map<String, Object>> electronicFenceFactoryList = digiwinEspProxyService
                .getElectronicFenceFactoryList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, null);
        if (CollectionUtils.isEmpty(electronicFenceFactoryList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        List<Map<String, Object>> dataList = new ArrayList<>();
        resultData.put("dataList", dataList);
        for (Map<String, Object> electronicFence : electronicFenceFactoryList) {
            Map<String, Object> map = new HashMap<>();
            dataList.add(map);
            List<Field> content = new ArrayList<>();
            map.put("content", content);
            // 工厂名称
            content.add(Field.createLabelValueLeftField("", StringUtil.valueOf(electronicFence.get("factory_name"))));
            // 区域半径
            content.add(Field.createLabelValueLeftField(localeService.getLanguageValue(locale, "区域半径"),
                    StringUtil.valueOf(electronicFence.get("radius")) + "KM"));

            Action<Map<String, Object>> editAction = new Action<>();
            editAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "编辑"));
            editAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_ELECTRONIC_FENCE_DETAIL.name());
            editAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            Map<String, Object> editRawData = new HashMap<>(4);
            editRawData.put("factory_id", StringUtil.valueOf(electronicFence.get("factory_id")));
            editRawData.put("factory_name", StringUtil.valueOf(electronicFence.get("factory_name")));
            editRawData.put("radius", StringUtil.valueOf(electronicFence.get("radius")));
            editRawData.put("start_flag", StringUtil.valueOf(electronicFence.get("start_flag")));
            editAction.setRawData(editRawData);
            map.put("cardAction", editAction);
        }
        return ApiResponse.buildOK().setData(resultData);
    }

    @PostMapping(value = "/vehicle/qrCode")
    public ApiResponse<Map<String, Object>> driverQrCode(@RequestBody ApiRequest apiRequest) {
        Map<String, Object> resultData = new HashMap<>();
        // 车辆信息Id
        String editId = apiRequest.getRawData().getString("editId") == null ?
                "" : apiRequest.getRawData().getString("editId");
        Map<String, Object> params = new HashMap<>(1);
        if (StringUtils.hasLength(editId)) {
            params.put("vehicle_info_id", editId);
        }
        List<Map<String, Object>> driverVehicles =
                digiwinEspProxyService.getDriverVehicle(apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale(), params);
        GraphicDisplay graphicDisplay = uiBotModelBuildZTBCarCodeStrategy.createGraphicDisplay(editId, driverVehicles);
        QrCode qrCode = uiBotModelBuildZTBCarCodeStrategy.createQrCode(apiRequest.getLocale(), editId, driverVehicles);
        resultData.put("carMessage", graphicDisplay);
        resultData.put("qrCode", qrCode);

        return ApiResponse.buildOK().setData(resultData);
    }

    /**
     * 在途宝应用+ 司机 角色 我的页面车辆码是否显示
     * 在途宝应用+ 司机 角色 我的页面我的车辆菜单
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @PostMapping(value = "/vehicle/show")
    public ApiResponse<Map<String, Object>> driverCodeShow(@RequestBody ApiRequest apiRequest) {
        Map<String, Object> resultData = new HashMap<>();
        // 在途宝应用+ 司机 角色 我的页面车辆码是否显示
        resultData.put("carCodeShow", false);
        // 在途宝应用+ 司机 角色 我的页面我的车辆菜单
        resultData.put("vehicleShow", false);
        resultData.put("electronicFenceShow", false);
//        try {
//            resultData.put("vehicleShow", true);
//            // 因bug单：https://athena-devops-zentao.digiwincloud.com.cn/bug-view-138786.html，暂时屏蔽此功能
////            resultData.put("electronicFenceShow", digiwinEspProxyService
////                    .getElectronicFenceShowFlag(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
////                            apiRequest.getLocale(), null));
//            // 是否有默认车辆
//            List<Map<String, Object>> driverVehicles = digiwinEspProxyService
//                    .getDriverVehicle(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
//                            apiRequest.getLocale(), null);
//            if (CollectionUtils.isEmpty(driverVehicles)) {
//                return ApiResponse.buildOK().setData(resultData);
//            }
//            Optional<Map<String, Object>> optional = driverVehicles.stream()
//                    .filter(v -> "true".equals(StringUtil.valueOf(v.get("is_default"))))
//                    .findFirst();
//
//            resultData.put("carCodeShow", optional.isPresent());
//            if (optional.isPresent()) {
//                long flag = taskService.getZtbTransportTaskCardCount(apiRequest);
//                resultData.put("positionFlag", flag > 0);
//            }
//        } catch (Exception e) {
//            log.error("ZhilinkZTBController[driverCodeShow] error: ", e);
//        }

        return ApiResponse.buildOK().setData(resultData);
    }

    /**
     * 获取发车任务卡/在途卡
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @PostMapping(value = "/task/card/float")
    public ApiResponse<Map<String, Object>> getFloatTaskCard(@RequestBody ApiRequest apiRequest) throws IOException {
        Map<String, Object> dataMap = new HashMap<>();
        List<ZTBTaskCard> myBacklogs = taskService.getZtbFloatTaskCard(apiRequest);
        if (CollectionUtils.isEmpty(myBacklogs)) {
            return ApiResponse.buildOK().setData(dataMap);
        }
        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List<PageTaskRelation> pageTaskRelationList =
                this.activityFilterService.listAthenaOfPageTaskRelations(apiRequest.getTenantId(), tenantVersion);
        // 过滤发车任务卡
        List<ZTBTaskCard> departures = myBacklogs.stream()
                .filter(r -> Integer.valueOf(0).equals(r.getTaskCardType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(departures)) {
            // 如果发车任务卡>=1 显示浮层
            dataMap.put("action", null);
            dataMap.put("data", this.buildZtbDepartureTaskCardFloat(apiRequest.getLocale(), departures, 0, pageTaskRelationList));
            return ApiResponse.buildOK().setData(dataMap);
        }

        // 过滤在途卡
        List<ZTBTaskCard> transitList = myBacklogs.stream()
                .filter(r -> Integer.valueOf(1).equals(r.getTaskCardType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(transitList)) {
            return ApiResponse.buildOK().setData(dataMap);
        }
//        if (transitList.size() == 1) {
//            // 如果在途卡==1 跳转到详情页
//            dataMap.put("action", this.buildZtbTaskDetailAction(transitList.get(0), pageTaskRelationList));
//            dataMap.put("data", null);
//            return ApiResponse.buildOK().setData(dataMap);
//        }
        // 如果在途卡>1 显示浮层
        dataMap.put("action", null);
        dataMap.put("data", this.buildZtbDepartureTaskCardFloat(apiRequest.getLocale(), transitList, 1, pageTaskRelationList));
        return ApiResponse.buildOK().setData(dataMap);
    }

    /**
     * 轮询保存定位接口
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @PostMapping(value = "/task/card/saveDriverPosition")
    public ApiResponse<Map<String, Object>> saveDriverPosition(@RequestBody ApiRequest apiRequest) throws IOException {
        Map<String, Object> dataMap = new HashMap<>();
        ApiRawData rawData = apiRequest.getRawData();
        Map<String, Object> position = (Map<String, Object>) rawData.get("positionMap");
        //调用敏态应用接口
        digiwinEspProxyService.saveDriverPosition(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), position);
        long flag = taskService.getZtbTransportTaskCardCount(apiRequest);
        dataMap.put("positionFlag", flag > 0);
        return ApiResponse.buildOK().setData(dataMap);
    }

    private Action<Map<String, Object>> buildZtbTaskDetailAction(ZTBTaskCard card,
                                                                 List<PageTaskRelation> pageTaskRelationList) {
        Action<Map<String, Object>> action = new Action<>();
        String jumpPageId = pageTaskRelationList.stream().filter(
                        pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                card.getTmTaskId(), card.getTmActivityId()))
                .map(PageTaskRelation::getPageId)
                .findFirst().orElse("");
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setDataId(StringUtil.valueOf(card.getBacklogId()));
        action.setJumpPageId(jumpPageId);
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("digi-proxy-token", card.getProxyToken());
        action.setRawData(rawData);
        action.setExtraParameter(new TaskExtraParameter(
                card.getAppCode(),
                card.getTmActivityId(), card.getTmCategory(),
                card.getTmPattern(), card.getTmTaskId()));
        return action;
    }

    private FloatingLayer buildZtbDepartureTaskCardFloat(String locale, List<ZTBTaskCard> departures,
                                                         int taskCardType, List<PageTaskRelation> pageTaskRelationList) {
        List<FloatingLayerData> cardList = new ArrayList<>();
        FloatingLayer floatingLayer = new FloatingLayer().setDefaultSelect(0).setShowLength(3)
                .setShowCloseButton(true).setCardList(cardList);

        departures.forEach(card -> {
            DigiwinTransportResponse transportMainInfo = card.getTransport();

            FloatingLayerData layerData = new FloatingLayerData()
                    .setSubject(localeService.getLanguageValue(locale, "待办"))
                    .setTitle(card.getName())
                    .setSubTitle(localeService.getLanguageValue(locale, "项目") + "：" + card.getProjectName())
                    .setTaskCardType(card.getTaskCardType());
            String[] address = this.getAddress(locale, card.getSummary());
            layerData.setStartAddress(address[0]).setEndAddress(address[1]).setSendOrReceiveTitle("")
                    .setCompleteAddress(transportMainInfo.getReceiptAddress())
                    .setAddressMap(null).setMapIcon(58948).setContactName(transportMainInfo.getReceiverName());
            if (StringUtils.hasLength(transportMainInfo.getReceiverMobile())) {
                layerData.setMobile(transportMainInfo.getReceiverMobile());
                layerData.setPhoneIcon(58908);
            } else {
                layerData.setMobile("-");
            }
            if (taskCardType == 0) {
                layerData.setMainButtonList(this.createStartTrainButton(locale, card)).setSubButtonList(null);
            } else {
                List<List<BottomButtonDigiwinAthena>> list = this.createTransportButton(locale, card, pageTaskRelationList);
                layerData.setMainButtonList(list.get(0)).setSubButtonList(list.get(1));
            }
            layerData.setAction(this.buildZtbTaskDetailAction(card, pageTaskRelationList));
            cardList.add(layerData);
        });
        return floatingLayer;
    }

    private List<List<BottomButtonDigiwinAthena>> createTransportButton(String locale, ZTBTaskCard card, List<PageTaskRelation> pageTaskRelationList) {
        PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT.name());
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotLayout layout = uiBotModel.getLayout().stream()
                .filter(o -> BottomButtonDigiwinAthena.COMPONENT_TYPE.equals(o.getType()))
                .collect(Collectors.toList()).get(0);
        List<BottomButtonDigiwinAthena> bottomButtonList =
                ModuleUtils.listMapToListObject((List) pageData.get(layout.getSchema()), BottomButtonDigiwinAthena.class);

        bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
            String buttonName = bottomButtonDigiwinAthena.getName();
            if (StringUtils.hasLength(buttonName)) {
                bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(locale, buttonName));
            }
            Action action = bottomButtonDigiwinAthena.getAction();
            if (action != null) {
                if (action.getConfirmPop() != null && StringUtils.hasLength(action.getConfirmPop().getContent())) {
                    action.getConfirmPop().setContent(localeService.getLanguageValue(locale, action.getConfirmPop().getContent()));
                } else if (StringUtils.hasLength(action.getJumpPageTitle())) {
                    action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                }
            }
            Map<String, Object> buttonRawData = new HashMap<>();
            if (action.getRawData() != null) {
                buttonRawData = (Map<String, Object>) action.getRawData();
            }
            buttonRawData.put("task_no", card.getTaskNo());
            buttonRawData.put("transport_no", card.getTransportNo());
            buttonRawData.put("digi-proxy-token", card.getProxyToken());
            //rawData里存提交接口所需参数
            UiBotAction uiBotAction = getSubmitAction(card.getPcUiBotModel(), "submit-data");
            if (null != uiBotAction) {
                buttonRawData.put("action", uiBotAction);
                Map<String, Object> data = new HashMap<>();
                String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                data.put(actionDataScheme, card.getPcUiBotModel().getPageData().get(actionDataScheme));
                buttonRawData.put("data", data);
            }
            action.setRawData(buttonRawData);

            List<BottomButtonDigiwinAthena> children = bottomButtonDigiwinAthena.getChildren();
            if (!CollectionUtils.isEmpty(children)) {
                for (BottomButtonDigiwinAthena button : children) {
                    if (StringUtils.hasLength(button.getName())) {
                        button.setName(localeService.getLanguageValue(locale, button.getName()));
                    }
                    if (StringUtils.hasLength(button.getSubName())) {
                        button.setSubName(localeService.getLanguageValue(locale, button.getSubName()));
                    }
                    Action action1 = button.getAction();
                    if (action1 != null) {
                        if (StringUtils.hasLength(action1.getJumpPageTitle())) {
                            action1.setJumpPageTitle(localeService.getLanguageValue(locale, action1.getJumpPageTitle()));
                        }
                        if (StringUtils.hasLength(action1.getToastMsg())) {
                            action1.setToastMsg(localeService.getLanguageValue(locale, action1.getToastMsg()));
                        }
                        Map<String, Object> childButtonRawData = new HashMap<>();
                        if (action1.getRawData() != null) {
                            childButtonRawData = (Map<String, Object>) action1.getRawData();
                        }
                        childButtonRawData.put("task_no", card.getTaskNo());
                        childButtonRawData.put("transport_no", card.getTransportNo());
                        childButtonRawData.put("digi-proxy-token", card.getProxyToken());
                        if (StrUtil.equals(StrUtil.toString(childButtonRawData.get("action_id")), "receive_scan")) {
                            QrCodeContentMsg qrCodeContentMsg = new QrCodeContentMsg(QrCodeContentMsg.BIZ_TYPE_TRANSPORT_RECEIVE);
                            qrCodeContentMsg.put("transport_no", card.getTransportNo());
                            QrCode qrCode = QrCode.create(qrCodeContentMsg, LocaleUtil.getMobileTextByKey(locale, "请扫码运单二维码"));
                            childButtonRawData.put("qrCode", qrCode);
                        }
                        if (null != uiBotAction) {
                            childButtonRawData.put("action", uiBotAction);
                            Map<String, Object> data = new HashMap<>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, card.getPcUiBotModel().getPageData().get(actionDataScheme));
                            childButtonRawData.put("data", data);
                        }
                        action1.setRawData(childButtonRawData);
                        if (StringUtils.hasLength(action1.getRequestUrl())) {
                            action1.setRequestUrl(AppContext.getBaseUrl() + action1.getRequestUrl());
                        }
                    }
                }
            }
        });

        // wjw TODO: 2023/5/26  S5 因在途宝司机到达详情页面到达按钮变成多个按钮的组合，故首页浮层卡到达按钮，点击进入详情页面，不做到达处理
//        List<BottomButtonDigiwinAthena> mainButtons = bottomButtonList.stream().filter(button -> {
//            Map<String, Object> rawData = (Map<String, Object>) button.getAction().getRawData();
//            return !("transfer".equals(StringUtil.valueOf(rawData.get("action_id")))
//                    || "abnormal".equals(StringUtil.valueOf(rawData.get("action_id"))));
//        }).collect(Collectors.toList());
        BottomButtonDigiwinAthena mainButton = new BottomButtonDigiwinAthena();
        mainButton.setName(localeService.getLanguageValue(locale, "到达"));
        mainButton.setType(BottomButtonStyleEnum.STRESS.getValue());
        mainButton.setAction(this.buildZtbTaskDetailAction(card, pageTaskRelationList));
        List<BottomButtonDigiwinAthena> mainButtons = Collections.singletonList(mainButton);

        // 次要按钮
        List<BottomButtonDigiwinAthena> subButtons = bottomButtonList.stream().filter(button -> {
            Map<String, Object> rawData = (Map<String, Object>) button.getAction().getRawData();
            return "transfer".equals(StringUtil.valueOf(rawData.get("action_id")))
                    || "abnormal".equals(StringUtil.valueOf(rawData.get("action_id")));
        }).collect(Collectors.toList());
        List<List<BottomButtonDigiwinAthena>> list = new ArrayList<>();
        list.add(mainButtons);
        list.add(subButtons);
        return list;
    }

    private List<BottomButtonDigiwinAthena> createStartTrainButton(String locale, ZTBTaskCard card) {
        PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_DEPARTURE.name());
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotLayout layout = uiBotModel.getLayout().stream()
                .filter(o -> BottomButtonDigiwinAthena.COMPONENT_TYPE.equals(o.getType()))
                .collect(Collectors.toList()).get(0);
        List<BottomButtonDigiwinAthena> bottomButtonList =
                ModuleUtils.listMapToListObject((List) pageData.get(layout.getSchema()), BottomButtonDigiwinAthena.class);
        bottomButtonList.forEach(bottomButton -> {
            bottomButton.setName(localeService.getLanguageValue(locale, bottomButton.getName()));
            bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            Action action = bottomButton.getAction();
            if (action.getConfirmPop() != null) {
                ConfirmPop confirmPop = action.getConfirmPop();
                confirmPop.setContent(localeService.getLanguageValue(locale, confirmPop.getContent()));
            }
            action.setType(ActionTypeEnum.CALL_API.getValue());
            Map<String, Object> buttonRawData = new HashMap<>();
            buttonRawData.put("task_no", card.getTaskNo());
            buttonRawData.put("transport_no", card.getTransportNo());
            buttonRawData.put("biz_id", "ZTB");
            buttonRawData.put("digi-proxy-token", card.getProxyToken());
            buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_DEPARTURE.toString());
            //rawData里存提交接口所需参数
            UiBotAction uiBotAction = getSubmitAction(card.getPcUiBotModel(), "submit-data");
            if (null != uiBotAction) {
                buttonRawData.put("action", uiBotAction);
                Map<String, Object> data = new HashMap<>();
                String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                data.put(actionDataScheme, card.getPcUiBotModel().getPageData().get(actionDataScheme));
                buttonRawData.put("data", data);
            }
            action.setRawData(buttonRawData);
            bottomButton.setAction(action);
        });
        return bottomButtonList;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List<UiBotLayout> layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty(layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<>();
        outer:
        for (UiBotLayout layout : layoutList) {
            List<UiBotAction> actions = layout.getActions();
            if (CollectionUtils.isEmpty(actions)) {
                continue;
            }
            for (UiBotAction action : actions) {
                if (actionId.equalsIgnoreCase(action.getActionId())) {
                    uiBotAction.set(action);
                    break outer;
                }
            }
        }
        return uiBotAction.get();
    }

    private String[] getAddress(String locale, String summary) {
        String[] address = new String[2];
        if (!StringUtils.hasLength(summary)) {
            return address;
        }
        String chStr = "物流地址";
        String twStr = localeService.getLanguageValue(locale, chStr);
        String logistics = Arrays.stream(summary.split("<br>")).filter(s -> s.contains(chStr) || s.contains(twStr)).findFirst().orElse("");
        if (!StringUtils.hasLength(logistics)) {
            return address;
        }
        String[] split = logistics.split("：");
        if (split.length == 1) {
            return address;
        }
        String[] split1 = split[1].split("->");
        if (split1.length == 1) {
            return address;
        }
        return new String[]{split1[0].trim(), split1[1].trim()};
    }

}
