package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequestPosition;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.*;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeDistrict;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.standardentry.InputStandardEntryColumn;
import com.digiwin.mobile.mobileuibot.core.component.input.standardentry.ZtbCargoInfoEntry;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.logistics.Logistics;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.file.FileService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogSubmitResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspStdData;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 在途宝提交处理类
 *
 * @author zhangjj
 * @date 2022/9/28 13:46
 */
@Slf4j
@Component
public class ZhilinkZTBSubmitHandler {
    public static final String SUCCESS_CODE = "200";

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private ComponentParamAnalyzerFactory componentParamAnalyzerFactory;

    @Autowired
    private FileService fileService;

    private static final Logger logger = LoggerFactory.getLogger(ZhilinkZTBSubmitHandler.class);

    public ActionSubmitResult submit(ApiRequestSubmit apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        String pageId = (String) rawData.get("page_id");
        String actionId1 = (String) rawData.get("action_id");
        log.debug("pageId:" + pageId);
        log.debug("actionId:" + actionId1);
        String taskNo = (String) rawData.get("task_no");
        String transportNo = (String) rawData.get("transport_no");
        if (!StringUtils.hasLength(pageId)) {
            return ActionSubmitResult.create(false,
                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "数据预处理异常") + ","
                            + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交中止"));
        }
        ApiRequestPosition position = apiRequest.getPosition();
        String actionId = (String) rawData.get("action_id");
        switch (PageSettingIdPresetEnum.getEnumByName(pageId)) {
            case MOBILE_ZTB_SHIPPING_TASK:
                //出货任务--下一步按钮
                return shippingNextStep(taskNo, apiRequest);
            case MOBILE_ZTB_SHIPPING_TASK_VEHICLE_INFO:
                //出货任务--提交按钮
                return shippingSubmit(taskNo, apiRequest);
            case MOBILE_ZTB_SCAN_RECEIVE_ORDER:
                // 扫码接单任务--提交按钮
                return scanReceiveOrderSubmit(taskNo, apiRequest);
            case MOBILE_ZTB_GOODS_LOADING:
                // 货物装车任务--提交按钮
                return goodsLoadingSubmit(taskNo, apiRequest);
            case MOBILE_ZTB_GOODS_LOADING_VEHICLE_INFO:
                return goodsLoadingVehicleInfoSubmit(taskNo, apiRequest);
            case MOBILE_ZTB_GOODS_DEPARTURE:
                // 货物发车任务--提交按钮
                Map<String, Object> params = new HashMap<>(4);
                params.put("transport_no", transportNo);
                if (position != null) {
                    params.put("province", position.getProvince());
                    params.put("city", position.getCity());
                    params.put("area", position.getArea());
                    params.put("complete_address", position.getCompleteAddress());
                    params.put("detail_address", position.getDetailAddress());
                    params.put("longitude", position.getLongitude());
                    params.put("latitude", position.getLatitude());
                    params.put("address", position.getCompleteAddress());
                }
                return goodsDepartureSubmit(params, apiRequest);
            case MOBILE_ZTB_TRANSPORT:
                //运输在途
                return transport(taskNo, transportNo, actionId, apiRequest);
            case MOBILE_ZTB_TRANSPORT_VEHICLE_INFO:
                //运输在途-转运提交
                return transportVehicleInfo(transportNo, actionId, apiRequest);
            case MOBILE_ZTB_TRANSPORT_ABNORMAL_ALARM:
                //运输在途-报警
                return tansportAlarm(transportNo, apiRequest);
            case MOBILE_ZTB_MODIFICATION_RECEIPT_SCHEDULE:
                //排程信息更改处理
                return modificationReceiptSchedule(apiRequest);
            case MOBILE_ZTB_RECEIPT_PREPARATION:
                //收货准备--提交按钮
                return receiptPreparation(transportNo, apiRequest);
            case MOBILE_ZTB_TRANSPORT_COMING_SOON:
                //收货准备--提交按钮
                return transportComingSoon(transportNo, apiRequest);
            case MOBILE_ZTB_CONFIRMATION_RECEIPT_PREPARATION:
                //收货准备确认--提交按钮
                return confirmationReceiptPreparation(transportNo, apiRequest);
            case MOBILE_ZTB_RECEIPT_CONFIRMATION:
            case MOBILE_ZTB_RECEIPT_CONFIRMATION_REJECTION:
                //收货确认--提交/拒收按钮
                return receiptConfirmation(transportNo, apiRequest);
            case MOBILE_PROJECT_CREATE:
                if ("manual_freightage_start".equalsIgnoreCase((String) rawData.get("dataId"))) {
                    return projectCreateManualFreightageStart(apiRequest);
                } else if ("scan_freightage_start".equalsIgnoreCase(rawData.getString("dataId"))) {
                    return projectCreateScanFreightageStart(apiRequest);
                }
                //跳转到收货排程修改页面
                return projectCreateReceiptScheduleChange(apiRequest);
            case MOBILE_ZTB_MODIFIY_ADDRESS:
                //新增或者更新在地址
                return modifiyAddress(apiRequest);
            case MOBILE_ZTB_ADDRESS_BOOK:
                String addressId = rawData.getString("address_id");
                return deleteAddress(addressId, apiRequest);
            case MOBILE_ZTB_RECEIPT_SIGNATURE_UPLOAD:
            case MOBILE_ZTB_RECEIPT_SIGNATURE_SIGN:
                //回单签字
                return receiptSignature(transportNo, apiRequest);
            case MOBILE_ZTB_TRANSPORT_SHIFTING_ABNORMAL_ALARM:
            case MOBILE_ZTB_TRANSPORT_STOP_ABNORMAL_ALARM:
                //处理预警消息
                return processAlarmMsg(transportNo, actionId, apiRequest);
            case MOBILE_ZTB_TRANSPORT_FORWARDING_ALARM:
                //处理运输转运代理
                commitAlarm(transportNo, apiRequest);
                return pcUiBotSubmit(apiRequest);
            case MOBILE_ZTB_TRANSPORT_FORWARDING_AGENT:
                return pcUiBotSubmit(apiRequest);
            default:
                break;
        }
        return ActionSubmitResult.create(false,
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "数据预处理异常") + ","
                        + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交中止"));
    }

    private void commitAlarm(String transportNo, ApiRequestSubmit apiRequest) {
        //提交异常信息
        Map<String, Object> rawData = new HashMap<>(4);
        rawData.put("transport_no", transportNo);
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            switch (submitParam.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    SingleSelectList singleSelect = (SingleSelectList) submitParam.getParams();
                    rawData.put(schema, singleSelect.getSelectId());
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText text = (InputMultiText) submitParam.getParams();
                    rawData.put(schema, text.getText());
                    break;
                case Picture.COMPONENT_TYPE:
                    Picture picture = (Picture) submitParam.getParams();
                    List<AttachmentFile> fileList = picture.getFileList();
                    List<String> pics = new ArrayList<>(3);
                    if (!CollectionUtils.isEmpty(fileList)) {
                        for (AttachmentFile file : fileList) {
                            pics.add(file.getFileId());
                        }
                    }
                    rawData.put(schema, pics);
                default:
                    break;
            }
        }
        ApiRequestPosition position = apiRequest.getPosition();
        if (position != null) {
            rawData.put("province", position.getProvince());
            rawData.put("city", position.getCity());
            rawData.put("area", position.getArea());
            rawData.put("complete_address", position.getCompleteAddress());
            rawData.put("detail_address", position.getDetailAddress());
            rawData.put("longitude", position.getLongitude());
            rawData.put("latitude", position.getLatitude());
            rawData.put("address", position.getCompleteAddress());
        }
        digiwinEspProxyService.transportAbnormalAlarmProcess(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), rawData);
    }


    private ActionSubmitResult projectCreateScanFreightageStart(ApiRequestSubmit apiRequest) {
        Map<String, Object> rawData = (Map<String, Object>) apiRequest.getRawData().get("data");
        return returnSubmit(digiwinEspProxyService.deliveryHeadInfoSubmit(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale());
    }

    /**
     * 在途宝签字回单
     *
     * @param transportNo
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult receiptSignature(String transportNo, ApiRequestSubmit apiRequest) {
        Map<String, Object> params = new HashMap<>(2);
        params.put("transport_no", transportNo);
        for (ActionSubmitParam submitParam : apiRequest.getSubmitParams()) {
            switch (submitParam.getType()) {
                case Picture.COMPONENT_TYPE:
                    Picture picture = (Picture) submitParam.getParams();
                    List<AttachmentFile> fileList = picture.getFileList();
                    List<String> pics = new ArrayList<>(3);
                    if (!CollectionUtils.isEmpty(fileList)) {
                        for (AttachmentFile file : fileList) {
                            pics.add(file.getFileId());
                        }
                    }
                    params.put(submitParam.getSchema(), pics);
                    break;
                case InputSign.COMPONENT_TYPE:
                    InputSign inputSign = (InputSign) submitParam.getParams();
                    String signData = inputSign.getSignData();
                    Map<String, Object> result = fileService.uploadFile(signData, "srm-loading", "driver_vehicle_img", true, apiRequest.getIamUserToken(), apiRequest.getTenantId());
                    log.debug(JSONUtil.toJsonStr(result));
                    if (!SUCCESS_CODE.equals(result.get("code"))) {
                        log.error("上传图片失败" + result.get("message"));
                        return returnSubmit(false, apiRequest.getLocale());
                    }
                    Object fileId = result.get("fileId");
                    List<String> signFileIds = new ArrayList<>();
                    signFileIds.add(StrUtil.toString(fileId));
                    params.put(submitParam.getSchema(), signFileIds);
                    break;
                default:
                    break;
            }

        }
        if (digiwinEspProxyService.transportPaperReceiptSubmit(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), params)) {
            return pcUiBotSubmit(apiRequest);
        } else {
            return returnSubmit(false, apiRequest.getLocale());
        }
    }

    private ActionSubmitResult projectCreateManualFreightageStart(ApiRequestSubmit apiRequest) {
        Map<String, Object> rawData = new HashMap<>();
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        for (ActionSubmitParam submitParam : submitParams) {
            switch (submitParam.getType()) {
                case Logistics.COMPONENT_TYPE:
                    List<LogisticsData> logisticsDataList = ModuleUtils.listMapToListObject((List<?>) submitParam.getParams(), LogisticsData.class);
                    for (LogisticsData data : logisticsDataList) {
                        if (LogisticsEnum.SEND.getValue().equals(data.getType())) {
                            rawData.put("delivery_address_id", data.getId());
                        } else if (LogisticsEnum.RECEIVER.getValue().equals(data.getType())) {
                            rawData.put("receipt_address_id", data.getId());
                        }
                    }
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTimePicker inputDateTimePicker = (InputDateTimePicker) submitParam.getParams();
                    InputDateTime inputDateTime = inputDateTimePicker.getDatetimeValue();
                    rawData.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType(
                            inputDateTime, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType()));
                    break;
                case ZtbCargoInfoEntry.COMPONENT_TYPE:
                    List<InputStandardEntryColumn> columns = ModuleUtils.listMapToListObject((List<?>) submitParam.getParams(), InputStandardEntryColumn.class);
                    List<Map<String, Object>> deliveryDetails;
                    if (!CollectionUtils.isEmpty(columns)) {
                        deliveryDetails = new ArrayList<>(columns.size());
                        for (InputStandardEntryColumn column : columns) {
                            Map<String, Object> deliveryDetail = new HashMap<>(4);
                            for (CardContent content : column.getColumn()) {
                                deliveryDetail.put(content.getSchema(), content.getValue());
                                if ("PRICE".equalsIgnoreCase(content.getType())) {
                                    deliveryDetail.put("unit_no", content.getUnitName());
                                }
                            }
                            deliveryDetails.add(deliveryDetail);
                        }
                    } else {
                        deliveryDetails = Collections.emptyList();
                    }
                    rawData.put(submitParam.getSchema(), deliveryDetails);
                    break;
                default:
                    break;
            }
        }
        return returnSubmit(digiwinEspProxyService.deliveryStartManualSubmit(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale());

    }

    private ActionSubmitResult modifiyAddress(ApiRequestSubmit apiRequest) {
        Map<String, Object> rawData = new HashMap<>(5);
        Boolean isAdd = apiRequest.getRawData().getBooleanValue("isAdd");
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        StringBuffer completeAddress = new StringBuffer();
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object analyzedParam = componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(submitParam.getParams());
            switch (submitParam.getType()) {
                case InputSingleText.COMPONENT_TYPE:
                    rawData.put(schema, analyzedParam);
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    completeAddress = completeAddress.append(" ").append(analyzedParam);
                    rawData.put(schema, analyzedParam);
                    break;
                case InputCascadeDistrict.COMPONENT_TYPE:
                    InputCascadeDistrict district = (InputCascadeDistrict) submitParam.getParams();
                    completeAddress = completeAddress.append(district.getProvince()).append(" ").
                            append(district.getCity()).append(" ").append(district.getArea());
                    rawData.put(schema, analyzedParam);
                    break;
                default:
                    break;
            }
        }
        rawData.put("complete_address", completeAddress);
        if (isAdd) {
            return returnSubmit(digiwinEspProxyService.createUserAddress(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale());
        } else {
            return returnSubmit(digiwinEspProxyService.updateUserAddress(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale());
        }
    }

    private ActionSubmitResult deleteAddress(String addressId, ApiRequestSubmit apiRequest) {
        return returnSubmit(digiwinEspProxyService.deleteUserAddress(
                apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), addressId), apiRequest.getLocale());
    }

    private ActionSubmitResult projectCreateReceiptScheduleChange(ApiRequestSubmit apiRequest) {
        Map<String, Object> rawData = new HashMap<>();
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        for (ActionSubmitParam submitParam : submitParams) {
            switch (submitParam.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) submitParam.getParams();
                    Map<String, Object> detail = inputWindowSingleSelect.getDetail();
                    rawData.put("data", detail);
                    break;
                default:
                    break;
            }
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_RECEIPT_SCHEDULE_CHANGE.toString());
        action.setJumpPageTitle(localeService.getLanguageValue(apiRequest.getLocale(), "收货排程更改"));
        rawData.put("pcUibotModel", apiRequest.getRawData().get("pcUibotModel"));
        action.setRawData(rawData);
        return ActionSubmitResult.create(true, action);
    }

    private ActionSubmitResult modificationReceiptSchedule(ApiRequestSubmit apiRequest) {
        Boolean isCancel = (Boolean) apiRequest.getRawData().get("isCancel");
        ApiRawData rawData = apiRequest.getRawData();
        String transportNo = (String) rawData.get("transport_no");
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        Map<String, Object> params = new HashMap<>(9);
        params.put("transport_no", transportNo);
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            Object analyzedParam = componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(paramObj);
            switch (submitParam.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    SingleSelectList selectList = (SingleSelectList) paramObj;
                    if (SingleSelectTypeEnum.SINGLE_SELECT.getValue().equals(selectList.getType())) {
                        if ("plan_unload_time".equalsIgnoreCase(schema)) {
                            params.put(schema, selectList.getText());
                        } else {
                            params.put(schema, analyzedParam);
                        }

                    } else {
                        List<String> selectIds = selectList.getSelectIdList();
                        List<Map<String, String>> timeSolts = new ArrayList<>(selectIds.size());
                        for (String selectId : selectIds) {
                            Map<String, String> timeSolt = new HashMap<>(2);
                            String[] splits = selectId.split("~");
                            timeSolt.put("appointment_delivery_time_start", splits[0]);
                            timeSolt.put("appointment_delivery_time_end", splits[1]);
                            timeSolts.add(timeSolt);
                        }
                        params.put(schema, timeSolts);
                    }
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                case InputSingleText.COMPONENT_TYPE:
                    if ("unloader_name".equalsIgnoreCase(schema)) {
                        InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) paramObj;
                        inputWindowSingleSelect.getSelectId();
                        params.put("unloader_id", ((InputWindowSingleSelect) paramObj).getSelectId());
                    } else if ("platform_no".equalsIgnoreCase(schema)) {
                        InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) paramObj;
                        Map<String, Object> detail = inputWindowSingleSelect.getDetail();
                        params.put(schema, detail.get(schema));
                        params.put("platform_name", detail.get("platform_name"));
                    }
                    params.put(schema, analyzedParam);
                    break;
                default:
                    break;
            }
        }
        if (isCancel) {
            return pcUiBotSubmit(apiRequest);
        } else {
            return resultSubimtInPcUibotSubmit(digiwinEspProxyService.scheduleInfo(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), apiRequest.getLocale(), params), apiRequest);
        }
    }

    private ActionSubmitResult receiptConfirmation(String transportNo, ApiRequestSubmit apiRequest) {
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        if (apiRequest.getRawData().get("submitParams") != null) {
            submitParams.addAll(ModuleUtils.listMapToListObject(
                    (List<?>) apiRequest.getRawData().get("submitParams"), ActionSubmitParam.class));
        }
        Boolean hasReject = false;
        Map<String, Object> params = new HashMap<>(3);
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            Object analyzedParam = new Object();
            if (!submitParam.getType().equalsIgnoreCase(Picture.COMPONENT_TYPE) &&
                    !submitParam.getType().equalsIgnoreCase(MultiFunctionList.COMPONENT_TYPE)
            ) {
                analyzedParam = componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(paramObj);
            }
            switch (submitParam.getType()) {
                case MultiFunctionList.COMPONENT_TYPE:
                    MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(submitParam.getParams(), MultiFunctionList.class);
                    List<Map<String, Object>> mapList = multiFunctionList.getSelectDetailList();
                    if (!CollectionUtils.isEmpty(mapList)) {
                        mapList.forEach(map -> {
                            map.put("receipt_qty", map.get("ztb_mobile_number"));
                        });
                    }
                    params.put("receipt_list", mapList);
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    hasReject = true;
                    params.put(schema, analyzedParam);
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    params.put(schema, analyzedParam);
                    break;
                case Picture.COMPONENT_TYPE:
                    Picture picture = (Picture) submitParam.getParams();
                    List<AttachmentFile> fileList = picture.getFileList();
                    List<String> pics = new ArrayList<>(3);
                    if (!CollectionUtils.isEmpty(fileList)) {
                        for (AttachmentFile file : fileList) {
                            pics.add(file.getFileId());
                        }
                    }
                    params.put(schema, pics);
                    break;
                default:
                    break;
            }
        }
        params.put("transport_no", transportNo);
        params.put("is_rejected", hasReject);
        DigiwinEspStdData data = digiwinEspProxyService.confirmCargoReceiptInfo(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), params);
        if (!"0".equals(data.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "cargo.arrival.info.process 返回 code " + data.getExecution().getCode() + ":" + data.getExecution().getDescription());
        }
        if (data.getParameter().get("is_receipt_completed") != null && (Boolean) data.getParameter().get("is_receipt_completed")) {
            if (hasReject) {
                ActionSubmitResult result = pcUiBotSubmit(apiRequest, localeService.getLanguageValue(apiRequest.getLocale(), "货物已拒收"));
                Action action = result.getAction();
                if (action == null) {
                    action = new Action();
                }
                action.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
                return result;
            } else {
                ActionSubmitResult result = pcUiBotSubmit(apiRequest, localeService.getLanguageValue(apiRequest.getLocale(), "货物已签收"));
                Action action = result.getAction();
                if (action == null) {
                    action = new Action();
                }
                action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
                return result;
            }
        } else {
            Map<String, Object> rawData = new HashMap<>(1);
            rawData.put("hasReject", hasReject);
            if (hasReject) {
                ActionSubmitResult result = returnSubmit(true, apiRequest.getLocale(), "货物已拒收");
                Action action = result.getAction();
                if (action == null) {
                    action = new Action();
                }
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_RECEIPT_CONFIRMATION.toString());
                action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                action.setRawData(rawData);
                return result;
            } else {
                ActionSubmitResult result = returnSubmit(true, apiRequest.getLocale(), "货物已签收");
                Action action = result.getAction();
                if (action == null) {
                    action = new Action();
                }
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_RECEIPT_CONFIRMATION.toString());
                action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                action.setRawData(rawData);
                return result;
            }
        }
    }

    private ActionSubmitResult receiptPreparation(String transportNo, ApiRequestSubmit apiRequest) {
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        Map<String, Object> params = new HashMap<>(5);
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            Object analyzedParam = new Object();
            if (!Attachment.COMPONENT_TYPE.equals(submitParam.getType())) {
                analyzedParam =
                        componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(paramObj);
            }
            switch (submitParam.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) paramObj;
                    params.put("unloader_id", inputWindowSingleSelect.getSelectId());
                    params.put("unloader_name", inputWindowSingleSelect.getTitle());
                    break;
                case InputSingleText.COMPONENT_TYPE:
                case SingleSelectList.COMPONENT_TYPE:
                    params.put(schema, analyzedParam);
                    break;
                default:
                    break;
            }
        }

        return resultSubimtInPcUibotSubmit(digiwinEspProxyService.receiptPreparationInfo(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), transportNo, params), apiRequest);
    }

    private ActionSubmitResult transportComingSoon(String transportNo, ApiRequestSubmit apiRequest) {
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        Map<String, Object> params = new HashMap<>(5);
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            Object analyzedParam = new Object();
            if (!Attachment.COMPONENT_TYPE.equals(submitParam.getType())) {
                analyzedParam =
                        componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(paramObj);
            }
            switch (submitParam.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) paramObj;
                    params.put("unloader_id", inputWindowSingleSelect.getSelectId());
                    params.put("unloader_name", inputWindowSingleSelect.getTitle());
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTimePicker inputDateTimePicker = (InputDateTimePicker) paramObj;
                    InputDateTime inputDateTime = inputDateTimePicker.getDatetimeValue();
                    params.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType(
                            inputDateTime, InputDateTimePickerTypeEnum.HOUR_MINUTE.getType()));
                    break;
                case InputSingleText.COMPONENT_TYPE:
                case InputNumeric.COMPONENT_TYPE:
                    params.put(schema, analyzedParam);
                    break;
                default:
                    break;
            }
        }
        return resultSubimtInPcUibotSubmit(digiwinEspProxyService.transportComingSoonProcess(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), transportNo, params), apiRequest);
    }

    private ActionSubmitResult confirmationReceiptPreparation(String transportNo, ApiRequestSubmit apiRequest) {
        return resultSubimtInPcUibotSubmit(digiwinEspProxyService.completeReceiptPreparationInfo(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), transportNo), apiRequest);
    }

    /**
     * 运输在途提交
     *
     * @param transportNo
     * @param actionId
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult transport(String taskNo, String transportNo, String actionId, ApiRequestSubmit apiRequest) {
        if (!StringUtils.hasLength(actionId)) {
            return ActionSubmitResult.create(false,
                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "数据预处理异常") + ","
                            + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交中止"));
        }
        if ("transfer".equalsIgnoreCase(actionId)) {
            //转运
            return transportTransfer(transportNo, apiRequest);
        } else if ("abnormal".equalsIgnoreCase(actionId)) {
            //异常报警
            return transportAbnormal(transportNo, apiRequest);
        } else if ("transport_arrival".equalsIgnoreCase(actionId)) {
            //到达
            return transportValidArrival(taskNo, transportNo, apiRequest);
        } else if ("arrive_scan".equalsIgnoreCase(actionId) || "arrive_online".equalsIgnoreCase(actionId) || "arrive_offline".equalsIgnoreCase(actionId)) {
            //签收:到达 线上 线下
            return transportArrive(actionId, transportNo, apiRequest);
        }
        return ActionSubmitResult.create(false,
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "数据预处理异常") + ","
                        + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交中止"));

    }

    /**
     * 运输在途-到达
     *
     * @param transportNo
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult transportArrive(String actionId, String transportNo, ApiRequestSubmit apiRequest) {
        String receiverName = ObjectUtil.isEmpty(apiRequest.getRawData().get("receiver_name")) ? "" : StrUtil.toString(apiRequest.getRawData().get("receiver_name"));
        String receiverMobile = ObjectUtil.isEmpty(apiRequest.getRawData().get("receiver_mobile")) ? "" : StrUtil.toString(apiRequest.getRawData().get("receiver_mobile"));
        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.cargoArrival(actionId, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo, receiverName, receiverMobile, apiRequest.getPosition());
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "cargo.arrival.info.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        Map<String, Object> dataMap = (Map<String, Object>) apiRequest.getRawData().get("data");
        Map<String, String> carInfo = new HashMap<>(1);
        if (CollectionUtils.isEmpty(dataMap)) {
            dataMap = new HashMap<>(1);
            if ("arrive_scan".equalsIgnoreCase(actionId) || "arrive_online".equalsIgnoreCase(actionId)) {
                carInfo.put("submit_type", "1");
            } else if ("arrive_offline".equalsIgnoreCase(actionId)) {
                carInfo.put("submit_type", "3");
            }
            List<Map> list = new ArrayList<>(1);
            list.add(carInfo);
            dataMap.put("cargo_information", list);
        } else {
            List<Map<String, Object>> cargoInformations = (List<Map<String, Object>>) dataMap.get("cargo_information");
            for (Map<String, Object> cargoInformation : cargoInformations) {
                if ("arrive_scan".equalsIgnoreCase(actionId) || "arrive_online".equalsIgnoreCase(actionId)) {
                    cargoInformation.put("submit_type", "1");
                } else if ("arrive_offline".equalsIgnoreCase(actionId)) {
                    cargoInformation.put("submit_type", "3");
                }
            }
            dataMap.put("cargo_information", cargoInformations);
        }
        apiRequest.getRawData().put("data", dataMap);
        return pcUiBotSubmit(apiRequest, localeService.getLanguageValue(apiRequest.getLocale(), "已到达目的地"));
    }

    /**
     * 运输在途-转运提交
     *
     * @param transportNo
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult transportVehicleInfo(String transportNo, String actionId, ApiRequestSubmit apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        String vehicleInfoId = String.valueOf(apiRawData.get("vehicle_info_id"));
        ApiRequestPosition position = apiRequest.getPosition();
        DigiwinEspStdData digiwinEspStdData;
        String msgType = "3";
        if (StrUtil.equalsAny(actionId, "stop", "shifting")) {
            Map<String, Object> params = new HashMap<>();
            params.put("transport_no", transportNo);
            params.put("vehicle_info_id", vehicleInfoId);
            params.put("msg_type", msgType);
            digiwinEspStdData = digiwinEspProxyService.commitDriverMsg(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                    apiRequest.getLocale(), params, position);
        } else {
            digiwinEspStdData = digiwinEspProxyService.oldDriverProcess(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                    apiRequest.getLocale(), transportNo, vehicleInfoId, position);
        }
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "old.driver.transport.twist.info.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        Map<String, Object> dataMap = (Map<String, Object>) apiRequest.getRawData().get("data");
        Map<String, String> carInfo = new HashMap<>(1);
        if (CollectionUtils.isEmpty(dataMap)) {
            dataMap = new HashMap<>(1);
            carInfo.put("submit_type", "2");
            List<Map> list = new ArrayList<>(1);
            list.add(carInfo);
            dataMap.put("cargo_information", list);
        } else {
            List<Map<String, Object>> cargoInformations = (List<Map<String, Object>>) dataMap.get("cargo_information");
            for (Map<String, Object> cargoInformation : cargoInformations) {
                cargoInformation.put("submit_type", "2");
            }
            dataMap.put("cargo_information", cargoInformations);
        }
        apiRequest.getRawData().put("data", dataMap);
        return pcUiBotSubmit(apiRequest, localeService.getLanguageValue(apiRequest.getLocale(), "转运成功"));
    }

    /**
     * 运输在途-处理消息预警
     *
     * @param transportNo
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult processAlarmMsg(String transportNo, String actionId, ApiRequestSubmit apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        String buttonActionId = (String) apiRawData.get("button_action_id");
        Map<String, Object> params = new HashMap<>();
        String msgType = StrUtil.equals(actionId, "stop") ? "3" : "2";
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        String licensePlateNo = "";
        if (ObjectUtil.isNotEmpty(submitParams) && submitParams.size() > 0 && StrUtil.equals(buttonActionId, "confirm")) {
            for (ActionSubmitParam submitParam : submitParams) {
                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(submitParam.getType());
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                switch (submitParam.getType()) {
                    case InputSingleText.COMPONENT_TYPE:
                        switch (schema) {
                            case "licensePlateNo":
                                params.put("license_plate_no", analyzedParam);
                                licensePlateNo = ObjectUtil.isEmpty(analyzedParam) ? "" : StrUtil.toString(analyzedParam);
                                break;
                            case "driverPhone":
                                params.put("driver_phone", analyzedParam);
                                break;
                            default:
                                break;
                        }
                        break;
                    case InputMultiText.COMPONENT_TYPE:
                        if (StrUtil.equals(schema, "remark") && ObjectUtil.isNotEmpty(analyzedParam)) {
                            if (StrUtil.equals(msgType, "3")) {
                                params.put("stop_reason", analyzedParam);
                            } else {
                                params.put("shifting_reason", analyzedParam);
                            }
                        }
                        break;
                    case ButtonSingleSelect.COMPONENT_TYPE:
                        String value = ObjectUtil.isEmpty(analyzedParam) ? "" : StrUtil.toString(analyzedParam);
                        if (StrUtil.equals(msgType, "3")) {
                            switch (value) {
                                case "0":
                                    params.put("stop_reason", "休息");
                                    break;
                                case "1":
                                    params.put("stop_reason", "车辆维修");
                                    break;
                                default:
                                    break;
                            }
                        }
                        break;
                    default:
                        break;
                }
            }
        }

        params.put("transport_no", transportNo);
        params.put("msg_type", msgType);
        ApiRequestPosition position = apiRequest.getPosition();
        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.commitDriverMsg(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), params, position);

        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "transport.driver.msg.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        if (StrUtil.isNotBlank(licensePlateNo)) {
            Map<String, Object> dataMap = (Map<String, Object>) apiRequest.getRawData().get("data");
            Map<String, String> carInfo = new HashMap<>(1);
            if (CollectionUtils.isEmpty(dataMap)) {
                dataMap = new HashMap<>(1);
                carInfo.put("submit_type", "2");
                List<Map> list = new ArrayList<>(1);
                list.add(carInfo);
                dataMap.put("cargo_information", list);
            } else {
                List<Map<String, Object>> cargoInformations = (List<Map<String, Object>>) dataMap.get("cargo_information");
                for (Map<String, Object> cargoInformation : cargoInformations) {
                    cargoInformation.put("submit_type", "2");
                }
                dataMap.put("cargo_information", cargoInformations);
            }
            apiRequest.getRawData().put("data", dataMap);
            return pcUiBotSubmit(apiRequest, localeService.getLanguageValue(apiRequest.getLocale(), "转运成功"));
        }
        return ActionSubmitResult.create(true, "提交成功");
    }

    private ActionSubmitResult tansportAlarm(String transportNo, ApiRequestSubmit apiRequest) {
        Map<String, Object> rawData = new HashMap<>(4);
        rawData.put("transport_no", transportNo);
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParams();
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            switch (submitParam.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    SingleSelectList singleSelect = (SingleSelectList) submitParam.getParams();
                    rawData.put(schema, singleSelect.getSelectId());
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText text = (InputMultiText) submitParam.getParams();
                    rawData.put(schema, text.getText());
                    break;
                case Picture.COMPONENT_TYPE:
                    Picture picture = (Picture) submitParam.getParams();
                    List<AttachmentFile> fileList = picture.getFileList();
                    List<String> pics = new ArrayList<>(3);
                    if (!CollectionUtils.isEmpty(fileList)) {
                        for (AttachmentFile file : fileList) {
                            pics.add(file.getFileId());
                        }
                    }
                    rawData.put(schema, pics);
                default:
                    break;
            }
        }
        ApiRequestPosition position = apiRequest.getPosition();
        if (position != null) {
            rawData.put("province", position.getProvince());
            rawData.put("city", position.getCity());
            rawData.put("area", position.getArea());
            rawData.put("complete_address", position.getCompleteAddress());
            rawData.put("detail_address", position.getDetailAddress());
            rawData.put("longitude", position.getLongitude());
            rawData.put("latitude", position.getLatitude());
            rawData.put("address", position.getCompleteAddress());
        }
        return returnSubmit(digiwinEspProxyService.transportAbnormalAlarmProcess(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale(), localeService.getLanguageValue(apiRequest.getLocale(), "异常报警成功"));
    }


    /**
     * 提交后走任务引擎
     *
     * @param digiwinEspStdData
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult resultSubimtInPcUibotSubmit(DigiwinEspStdData digiwinEspStdData, ApiRequestSubmit apiRequest) {
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "cargo.arrival.info.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        return pcUiBotSubmit(apiRequest);
    }

    /**
     * 运输在途-异常报警
     *
     * @param transportNo
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult transportAbnormal(String transportNo, ApiRequestSubmit apiRequest) {
        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.abnormalAlertCheck(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "abnormal.alert.check 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        Map<String, Object> dataMap = (Map<String, Object>) apiRequest.getRawData().get("data");
        Map<String, String> carInfo = new HashMap<>(1);
        if (CollectionUtils.isEmpty(dataMap)) {
            dataMap = new HashMap<>(1);
            carInfo.put("submit_type", "2");
            List<Map> list = new ArrayList<>(1);
            list.add(carInfo);
            dataMap.put("cargo_information", list);
        } else {
            List<Map<String, Object>> cargoInformations = (List<Map<String, Object>>) dataMap.get("cargo_information");
            for (Map<String, Object> cargoInformation : cargoInformations) {
                cargoInformation.put("submit_type", "2");
            }
            dataMap.put("cargo_information", cargoInformations);
        }
        apiRequest.getRawData().put("data", dataMap);
        return pcUiBotSubmit(apiRequest);
    }

    /**
     * 运输在途-到达
     *
     * @param transportNo
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult transportValidArrival(String taskNo, String transportNo, ApiRequestSubmit apiRequest) {
        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.validArrival(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), taskNo, transportNo, apiRequest.getPosition());
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "transport.arrival.valid.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        } else {
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        }
    }

    /**
     * 运输在途-转运
     *
     * @param transportNo
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult transportTransfer(String transportNo, ApiRequestSubmit apiRequest) {
        ActionSubmitResult actionSubmitResult = new ActionSubmitResult();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData apiRawData = apiRequest.getRawData();
        List<Map<String, Object>> mapList = digiwinEspProxyService.getTransportDriver(iamUserToken, tenantId, locale, transportNo);
        if (CollectionUtils.isEmpty(mapList)) {
            //还没有车辆，弹窗提示
            Action action = new Action();
            action.setType(ActionTypeEnum.POP_PROMPT.getValue());
            PopPromptMsg popPromptMsg = new PopPromptMsg();
            popPromptMsg.setTitle(LocaleUtil.getMobileTextByKey(locale, "提示"));
            popPromptMsg.setContent(LocaleUtil.getMobileTextByKey(locale, "待司机扫描运单二维码转运处理"));
            List<Button> popButtonList = new ArrayList<>();
            Button popButton = new Button();
            popButton.setName(LocaleUtil.getMobileTextByKey(locale, "确定"));
            popButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            Action popAction = new Action();
            popAction.setType(ActionTypeEnum.BACK.getValue());
            popButton.setAction(popAction);
            popButtonList.add(popButton);
            popPromptMsg.setButtonList(popButtonList);
            action.setPopPromptMsg(popPromptMsg);
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        //有车辆，跳转车辆信息开窗页面
        Action action = new Action();
        action.setDataId(transportNo);
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_VEHICLE_INFO.toString());
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "转运车辆信息"));
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("vehicle_info", mapList.get(0));
        rawData.put("transport_no", transportNo);
        rawData.put("action", apiRawData.get("action"));
        rawData.put("data", apiRawData.get("data"));
        rawData.put("digi-proxy-token", apiRawData.get("digi-proxy-token"));
        action.setRawData(rawData);
        actionSubmitResult.setAction(action);
        return actionSubmitResult;
    }

    /**
     * 出货任务--提交按钮
     *
     * @param apiRequest
     * @param taskNo
     * @return
     */
    private ActionSubmitResult shippingSubmit(String taskNo, ApiRequestSubmit apiRequest) {
        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.ztbSubmit(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), taskNo, "2");
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "delivery.task.status.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        return pcUiBotSubmit(apiRequest);
    }

    /**
     * 出货任务--下一步按钮
     *
     * @param taskNo
     */
    private ActionSubmitResult shippingNextStep(String taskNo, ApiRequestSubmit apiRequest) {
        ActionSubmitResult actionSubmitResult = new ActionSubmitResult();
        ApiRawData apiRawData = apiRequest.getRawData();
        String locale = apiRequest.getLocale();
        List<Map<String, Object>> mapList = digiwinEspProxyService.getVehicleInfo(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), taskNo, false, null);
        if (CollectionUtils.isEmpty(mapList)) {
            //还没有车辆，弹窗提示
            Action action = new Action();
            action.setType(ActionTypeEnum.POP_PROMPT.getValue());
            PopPromptMsg popPromptMsg = new PopPromptMsg();
            popPromptMsg.setTitle(LocaleUtil.getMobileTextByKey(locale, "提示"));
            popPromptMsg.setContent(LocaleUtil.getMobileTextByKey(locale, "待司机扫描货运二维码接单处理"));
            List<Button> popButtonList = new ArrayList<>();
            Button popButton = new Button();
            popButton.setName(LocaleUtil.getMobileTextByKey(locale, "确定"));
            popButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            Action popAction = new Action();
            popAction.setType(ActionTypeEnum.BACK.getValue());
            popButton.setAction(popAction);
            popButtonList.add(popButton);
            popPromptMsg.setButtonList(popButtonList);
            action.setPopPromptMsg(popPromptMsg);
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        //有车辆，底部弹窗页面展示车辆信息
        Action action = new Action();
        action.setDataId(taskNo);
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK_VEHICLE_INFO.toString());
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "车辆信息"));
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("vehicle_infos", mapList);
        rawData.put("task_no", taskNo);
        rawData.put("action", apiRawData.get("action"));
        rawData.put("data", apiRawData.get("data"));
        rawData.put("digi-proxy-token", apiRawData.get("digi-proxy-token"));
        action.setRawData(rawData);
        actionSubmitResult.setAction(action);
        return actionSubmitResult;
    }

    /**
     * 扫码接单操作--提交按钮
     *
     * @param taskNo
     */
    private ActionSubmitResult scanReceiveOrderSubmit(String taskNo, ApiRequestSubmit apiRequestSubmit) {

        ApiRawData apiRawData = apiRequestSubmit.getRawData();
        String transportNo = (String) apiRawData.get("transport_no");
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        ActionSubmitParam driverMessageParam = submitParams.stream().filter(
                item -> item.getSchema().equalsIgnoreCase("driverMessage")
        ).findFirst().orElse(new ActionSubmitParam());
        InputWindowSingleSelect data_info = JsonUtil.objectToJavaObject(driverMessageParam.getParams(), InputWindowSingleSelect.class);
        Map<String, Object> detail = data_info.getDetail();
        Map<String, Object> params = new HashMap<>();
        params.put("brand_model_no", detail.get("brand_model_no"));
        params.put("vehicle_type", detail.get("vehicle_type"));
        params.put("license_plate_no", detail.get("license_plate_no"));
        params.put("vehicle_info_id", detail.get("vehicle_info_id"));
        params.put("task_no", taskNo);
        //当有transportNo时为转运车辆，否则为出库接单
        DigiwinEspStdData digiwinEspStdData;
        if (StringUtils.hasLength(transportNo)) {
            digiwinEspStdData = digiwinEspProxyService.newDriverProcess(apiRequestSubmit.getIamUserToken(),
                    apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), transportNo, detail.get("vehicle_info_id"));
            if ("0".equals(digiwinEspStdData.getExecution().getCode())) {
                String promptMessage =
                        LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), "提交成功");
                return ActionSubmitResult.create(true, promptMessage);
            } else {
                return ActionSubmitResult.create(false,
                        "new.driver.transport.twist.info.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
            }
        }
        digiwinEspStdData = digiwinEspProxyService.driverCurrentVehicleUpdate(apiRequestSubmit.getIamUserToken(),
                apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), params);
        if ("0".equals(digiwinEspStdData.getExecution().getCode())) {
            //扫码接口因为不需要生成任务卡，只需要调在途宝 delivery.task.status.process接口
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false,
                    "driver.current.vehicle.update 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
    }

    /**
     * 货物发车--提交按钮
     *
     * @param params
     */
    private ActionSubmitResult goodsDepartureSubmit(Map<String, Object> params, ApiRequestSubmit apiRequestSubmit) {
        List<String> fileList = new ArrayList<>(6);
        apiRequestSubmit.getSubmitParams().forEach(submit -> {
            if (Picture.COMPONENT_TYPE.equalsIgnoreCase(submit.getType())) {
                Picture picture = (Picture) submit.getParams();
                if (picture != null && !CollectionUtils.isEmpty(picture.getFileList())) {
                    picture.getFileList().forEach(file -> {
                        fileList.add(file.getFileId());
                    });
                }
            }
        });
        params.put("depart_pic_file_list", fileList);
        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.cargoDepart(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(),
                apiRequestSubmit.getLocale(), params);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "cargo.depart.info.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        Map<String, Object> dataMap = (Map<String, Object>) apiRequestSubmit.getRawData().get("data");
        Map<String, String> carInfo = new HashMap<>(1);
        if (CollectionUtils.isEmpty(dataMap)) {
            dataMap = new HashMap<>(1);
            carInfo.put("submit_type", "1");
            List<Map> list = new ArrayList<>(1);
            list.add(carInfo);
            dataMap.put("cargo_information", list);
        } else {
            List<Map<String, Object>> cargoInformations = (List<Map<String, Object>>) dataMap.get("cargo_information");
            for (Map<String, Object> cargoInformation : cargoInformations) {
                cargoInformation.put("submit_type", "1");
            }
            dataMap.put("cargo_information", cargoInformations);
        }
        apiRequestSubmit.getRawData().put("data", dataMap);
        return pcUiBotSubmit(apiRequestSubmit);
    }

    /**
     * 货物装车--提交按钮
     *
     * @param taskNo
     */
    private ActionSubmitResult goodsLoadingSubmit(String taskNo, ApiRequestSubmit apiRequestSubmit) {
        ActionSubmitResult actionSubmitResult = new ActionSubmitResult();
        ApiRawData rawData = apiRequestSubmit.getRawData();
        //把货物信息放到rawData中
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        List<ActionSubmitParam> deliveryInfoParams = submitParams.stream().filter(submitParam -> MultiFunctionList.COMPONENT_TYPE.equalsIgnoreCase(submitParam.getType())).collect(Collectors.toList());
        if (deliveryInfoParams.isEmpty()) {
            Action action = new Action();
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "请先选择货物"));
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(deliveryInfoParams.get(0).getParams(), MultiFunctionList.class);
        //货物信息id-list
        List<Map<String, Object>> deliveryDetailList = multiFunctionList.getSelectDetailList();
        rawData.put("deliveryDetailList", deliveryDetailList);
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData(rawData);
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_LOADING_VEHICLE_INFO.toString());
        action.setJumpPageTitle(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "车辆信息"));

        actionSubmitResult.setAction(action);
        return actionSubmitResult;
    }

    /**
     * 货物装车车辆信息弹窗页面--提交按钮
     *
     * @param taskNo
     * @param apiRequestSubmit
     * @return
     */
    private ActionSubmitResult goodsLoadingVehicleInfoSubmit(String taskNo, ApiRequestSubmit apiRequestSubmit) {
        ActionSubmitResult actionSubmitResult = new ActionSubmitResult();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();
        String locale = apiRequestSubmit.getLocale();
        ApiRawData rawData = apiRequestSubmit.getRawData();
        //货物信息
        List<Map<String, Object>> deliveryDetailList = (List<Map<String, Object>>) rawData.get("deliveryDetailList");
        //车辆信息
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        List<ActionSubmitParam> vehicleParams = submitParams.stream().filter(submitParam -> MultiFunctionList.COMPONENT_TYPE.equalsIgnoreCase(submitParam.getType())).collect(Collectors.toList());
        if (vehicleParams.isEmpty()) {
            Action action = new Action();
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "请先选择车辆"));
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(vehicleParams.get(0).getParams(), MultiFunctionList.class);
        List<Map<String, Object>> vehicleDetailList = multiFunctionList.getSelectDetailList();
        //车辆信息
        Map<String, Object> vehicleDetail = vehicleDetailList.get(0);
        //todo 货物信息和车辆信息需提交，提交格式还没有
        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.ztbLoadingSubmit(iamUserToken, tenantId, locale,
                deliveryDetailList, vehicleDetail);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create(false,
                    "cargo.loading.info.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        //是否全部已装车
        Boolean isLoadCar = (Boolean) digiwinEspStdData.getParameter().get("is_load_car");
        String transportNo = (String) digiwinEspStdData.getParameter().get("transport_no");
        //todo 根据返回数据，判断是否还有未装货货物，没有则返回选择货物页面，否则返回选择货物的上一页
        Map<String, Object> rawDataData = (Map<String, Object>) rawData.get("data");
        if (!CollectionUtils.isEmpty(rawDataData)) {
            List<Map<String, Object>> deliveryDetailMapList = (List<Map<String, Object>>) rawDataData.get("delivery_detail");
            if (!CollectionUtils.isEmpty(deliveryDetailMapList)) {
                deliveryDetailMapList.forEach(deliveryDetailMap -> deliveryDetailMap.put("transport_no", transportNo));
            }
        }
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                this.digiwinAtmcProxyService.actionSubmit(locale, iamUserToken, tenantId, rawData);
        if (null != atmcSubmitResult.getRequestData()) {
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(locale, "提交成功");
            actionSubmitResult = ActionSubmitResult.create(true, promptMessage);
            Action action = new Action();
            if (isLoadCar != null && isLoadCar) {
                //货物已全部装车，返回上上页
                action.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
            } else {
                //货物未全部装车，返回上页
                action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            }
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        return ActionSubmitResult.create(false, atmcSubmitResult.getErrorMessage());

    }

    /**
     * pcUibot任务引擎提交
     *
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult pcUiBotSubmit(ApiRequestSubmit apiRequest) {
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                this.digiwinAtmcProxyService.actionSubmit(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getRawData());
        if (null != atmcSubmitResult.getRequestData()) {
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false, atmcSubmitResult.getErrorMessage());
        }
    }

    /**
     * pcUibot任务引擎提交
     *
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult pcUiBotSubmit(ApiRequestSubmit apiRequest, String promptMessage) {
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                this.digiwinAtmcProxyService.actionSubmit(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getRawData());
        if (null != atmcSubmitResult.getRequestData()) {
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false, atmcSubmitResult.getErrorMessage());
        }
    }

    private ActionSubmitResult returnSubmit(Boolean submit, String locale) {
        if (submit) {
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(locale, "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false,
                    LocaleUtil.getMobileTextByKey(locale, "提交异常"));
        }
    }

    private ActionSubmitResult returnSubmit(Boolean submit, String locale, String promptMessage) {
        if (submit) {
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false,
                    LocaleUtil.getMobileTextByKey(locale, "提交异常"));
        }
    }
}
