package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.apposition.Apposition;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbUserAddress;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：在途宝地址簿策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: uiBotModelBuildZTBAddressBookStrategy
 * @Author: wuyang
 * @Date: 20230221
 */
@Component("uiBotModelBuildZTBAddressBookStrategy")
public class UiBotModelBuildZTBAddressBookStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBAddressBookStrategy.class);

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildAddressBook");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        Map<String, Object> rawData = apiRequest.getRawData();
        UiBotPageData pageData = uiBotModel.getPageData();
        //TODO 请求地址簿数据
        if (CollectionUtils.isEmpty(rawData)) {
            rawData = new HashMap<>(2);
            rawData.put("pageNo", "1");
            rawData.put("pageSize", "9999");
        }
        List<ZtbUserAddress> ztbUserAddressList = digiwinEspProxyService.getuserAddressList(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), rawData);
        if (CollectionUtils.isEmpty(ztbUserAddressList)) {
            return UiBotModel.emptyUibotModel(apiRequest.getLocale());
        }
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case Apposition.COMPONENT_TYPE:
                    Apposition apposition = JsonUtil.objectToJavaObject(
                            pageData.get(uiBotLayout.getSchema()), Apposition.class);
                    pageData.put(uiBotLayout.getSchema(), buildAddressBookApposition(apposition, ztbUserAddressList, apiRequest));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageData.get(uiBotLayout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(button -> {
                        Action action = button.getAction();
                        if (action == null) {
                            action = new Action();
                            action.setType(ActionTypeEnum.CALL_API.getValue());
                        }
                        Map<String, Object> actionRawData = new HashMap<>(2);
                        actionRawData.put("page_id", apiRequest.getPageId());
                        actionRawData.put("biz_id", "ZTB");
                        action.setRawData(actionRawData);
                    });
                    pageData.put(uiBotLayout.getSchema(), bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private Apposition buildAddressBookApposition(Apposition apposition, List<ZtbUserAddress> districts, ApiRequest apiRequest) {
        List<AppositionData> datas = apposition.getDatas();
        for (ZtbUserAddress userAddress : districts) {
            datas.add(AppositionData.create(userAddress, localeService, apiRequest));
        }
        return apposition;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/addressBook.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
