package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.component.search.Pic;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 功能: 车辆码
 *
 * @author: wjw
 * @date: created at 2023/3/7
 */
@Component("uiBotModelBuildZTBCarCodeStrategy")
public class UiBotModelBuildZTBCarCodeStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return this.doActually(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        // 车辆信息Id
        String editId = apiRequest.getRawData().getString("editId") == null ?
                "" : apiRequest.getRawData().getString("editId");
        Map<String, Object> params = new HashMap<>(1);
        if (StringUtils.hasLength(editId)) {
            params.put("vehicle_info_id", editId);
        }
        List<Map<String, Object>> driverVehicles =
                digiwinEspProxyService.getDriverVehicle(apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale(), params);
        for (UiBotLayout layout : layoutList) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case GraphicDisplay.COMPONENT_TYPE:
                    pageData.put(schema, this.createGraphicDisplay(editId, driverVehicles));
                    break;
                case QrCode.COMPONENT_TYPE:
                    pageData.put(schema, this.createQrCode(apiRequest.getLocale(), editId, driverVehicles));
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    public GraphicDisplay createGraphicDisplay(String editId, List<Map<String, Object>> driverVehicles) {
        if (CollectionUtils.isEmpty(driverVehicles)) {
            return new GraphicDisplay();
        }
        Map<String, Object> vehicle;
        if (StringUtils.hasLength(editId)) {
            // 获取当前车辆码
            vehicle = driverVehicles.get(0);
        } else {
            // 获取默认车辆码
            vehicle = driverVehicles.stream().filter(v -> "true".equals(StringUtil.valueOf(v.get("is_default"))))
                    .findFirst().orElse(driverVehicles.get(0));
        }
        GraphicDisplay graphicDisplay = new GraphicDisplay();
        graphicDisplay.setTitle(StringUtil.valueOf(vehicle.get("license_plate_no")));
        graphicDisplay.setStyle(2);
        String picFileId = StringUtil.valueOf(vehicle.get("pic_file_id"));
        if (StringUtils.hasLength(picFileId)) {
            ShareInfo shareInfo = digiwinDmcProxyService.shareFile(picFileId, DigiwinDmcConfig.SRM_LOADING_BUCKET);
            graphicDisplay.setPics(Collections.singletonList(new Pic().setPicUrl(shareInfo.getUrl())));
        }
        return graphicDisplay;
    }

    public QrCode createQrCode(String locale, String editId, List<Map<String, Object>> driverVehicles) {
        if (CollectionUtils.isEmpty(driverVehicles)) {
            return new QrCode();
        }
        QrCodeContentMsg qrCodeContentMsg = new QrCodeContentMsg(QrCodeContentMsg.BIZ_TYPE_DRIVER_CODE);
        if (StringUtils.hasLength(editId)) {
            // 获取当前车辆码
            qrCodeContentMsg.put("vehicle_info_id", StringUtil.valueOf(driverVehicles.get(0).get("vehicle_info_id")));
        } else {
            // 获取默认车辆码
            Map<String, Object> map = driverVehicles.stream()
                    .filter(vehicle -> "true".equals(StringUtil.valueOf(vehicle.get("is_default"))))
                    .findFirst()
                    .orElse(driverVehicles.get(0));
            qrCodeContentMsg.put("vehicle_info_id", StringUtil.valueOf(map.get("vehicle_info_id")));
        }
        return QrCode.create(qrCodeContentMsg,
                localeService.getLanguageValue(locale, "扫一扫上面的二维码图案，派单给我"));
    }
}
