package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * 功能: 我的车辆列表
 *
 * @author: wjw
 * @date: created at 2023/3/7
 */
@Component("uiBotModelBuildZTBCarListStrategy")
public class UiBotModelBuildZTBCarListStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return this.doActually(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case BlankArea.COMPONENT_TYPE:
                    BlankArea blankArea = JsonUtil.objectToJavaObject(pageData.get(schema), BlankArea.class);
                    pageData.put(schema, blankArea);
                    break;
                case MultiFunctionList.COMPONENT_TYPE:
                    MultiFunctionList multiFunctionList =
                            JsonUtil.objectToJavaObject(pageData.get(schema), MultiFunctionList.class);
                    pageData.put(schema, multiFunctionList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageData.get(schema), BottomButtonList.class);
                    bottomButtonList.initSetting(localeService, locale);
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }
}
