package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：在途宝车辆信息新增/编辑生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildZTBCarMessageStrategy
 * @Author: Liux
 * @Date: 2022年7月19日10点34分
 */
@Component("uiBotModelBuildZTBCarMessageStrategy")
public class UiBotModelBuildZTBCarMessageStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBCarMessageStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildCarMessage");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        //新增样式需要外面包一层CustomGroup
        List<UiBotLayout> mobileUiBotLayouts = new ArrayList<>(2);
        UiBotModel mobileUibotModel = new UiBotModel(mobileUiBotLayouts);
        UiBotLayout mobileUibitLayout = new UiBotLayout();
        String customGroupSchema = UUIDUtil.getUuid();
        mobileUibitLayout.setSchema(customGroupSchema);
        mobileUibitLayout.setType(CustomGroup.COMPONENT_TYPE);
        mobileUiBotLayouts.add(mobileUibitLayout);
        UiBotPageData mobilePageData = new UiBotPageData();

        // 是否从首页进入
        boolean isIndexEnter = "true".equals(StringUtil.valueOf(apiRequest.getRawData().get("isIndexEnter")));

        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> driverVehicle = new HashMap<>(1);
        String editId = apiRequest.getRawData().get("editId") == null ? "" : String.valueOf(apiRequest.getRawData().get("editId"));
        Map<String, Object> params = new HashMap<>(1);
        if (StringUtils.hasLength(editId)) {
            params.put("vehicle_info_id", editId);
        }
        List<Map<String, Object>> driverVehicles = digiwinEspProxyService.getDriverVehicle(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), params);
        if (StringUtils.hasLength(editId) && !CollectionUtils.isEmpty(driverVehicles)) {
            driverVehicle = driverVehicles.get(0);
        }

        // 拼成最终数据
        stopWatch.start("Build CarMessage Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = new UiBotPageData();
        Boolean add = true;
        for (UiBotLayout layout : uiBotLayouts) {
            String value = driverVehicle.get(layout.getSchema()) == null ? "" : String.valueOf(driverVehicle.get(layout.getSchema()));
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    if (StringUtils.hasLength(value)) {
                        pageData.put(schema, Field.create(layout.getmLabelText().get(locale),
                                value, FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue(), 1, true));
                        add = false;
                    }
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    SingleSelectList single =
                            JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), SingleSelectList.class);
                    if (add) {
                        pageData.put(schema, SingleSelectList.create(layout.getmLabelText().get(locale), AppContext.getBaseUrl() + "/mobile/v1/proxy/get/inputSingleSelectOptions",
                                single.getIsShowDesc(), single.getDescPics()));
                    } else {
                        pageData.put(schema, SingleSelectList.create(layout.getmLabelText().get(locale), AppContext.getBaseUrl() + "/mobile/v1/proxy/get/inputSingleSelectOptions",
                                value, single.getIsShowDesc(), single.getDescPics()));
                    }
                    break;
                case InputSingleText.COMPONENT_TYPE:
                    pageData.put(schema, InputSingleText.create(layout, locale, value, InputTypeEnum.INPUT_LICENSE_PLAT.getValue()));
                    break;
                case Picture.COMPONENT_TYPE:
                    Picture pic =
                            JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), Picture.class);
                    Picture picture = Picture.createZtbVehiclePic(schema, layout.getmLabelText().get(locale),
                            AttachmentTypeEnum.READ_AND_WRITE.getValue(), pic.getSchematicPics(), pic.getLimit());
                    picture.setPlaceholder(localeService.getLanguageValue(locale, "确认车牌号码清晰，包括车头和车身"));
                    if (StringUtils.hasLength(value)) {
                        ShareInfo shareInfo = digiwinDmcProxyService.shareFile(value, DigiwinDmcConfig.SRM_LOADING_BUCKET);
                        picture.setFileList(Collections.singletonList(AttachmentFile
                                .create(null, value, shareInfo.getFileName(), 1L, shareInfo.getUrl(), null, null)));
                    }
                    pageData.put(schema, picture);
                    break;
                case InputSwitch.COMPONENT_TYPE:
                    // 新增状态下，车辆为空，则设置成默认选中
                    if (add && CollectionUtils.isEmpty(driverVehicles)) {
                        pageData.put(schema, InputSwitch.create(true, layout.getmLabelText().get(locale), true));
                    } else {
                        pageData.put(schema, InputSwitch.create("true".equals(value), layout.getmLabelText().get(locale), false));
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    mobileUiBotLayouts.add(layout);
                    List<Map<String, Object>> bottomButtons = (List<Map<String, Object>>) uiBotModel.getPageData().get("bottomButtons");
                    List<BottomButtonDigiwinAthena> buttonDigiwinAthenas = new ArrayList<>(1);
                    for (Map<String, Object> button : bottomButtons) {
                        //更新或者新增按钮
                        if ("submit".equals(button.get("id"))) {
                            BottomButtonDigiwinAthena bottomButtonDigiwinAthena = new BottomButtonDigiwinAthena();
                            bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByKey(locale, "保存"));
                            Action<Map<String, Object>> action = new Action<>();
                            if (isIndexEnter) {
                                action = JsonUtil.objectToJavaObject(button.get("action"),
                                        new TypeReference<Action<Map<String, Object>>>() {
                                        });
                                if (action.getJumpPageTitle() != null) {
                                    action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                                }
                                if (StringUtils.hasLength(action.getRequestUrl())) {
                                    action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
                                }
                            } else {
                                Map<String, Object> rawData = (Map<String, Object>) ((Map<String, Object>) button.get("action")).get("rawData");
                                action.setType(ActionTypeEnum.CALL_API.getValue());
                                action.setRawData(rawData);
                            }

                            action.getRawData().put("data", driverVehicle);
                            bottomButtonDigiwinAthena.setAction(action);
                            bottomButtonDigiwinAthena.setId((String) button.get("id"));
                            if (add) {
                                action.getRawData().put("driverCarType", "add");
                                buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                                break;
                            } else {
                                action.getRawData().put("driverCarType", "update");
                                buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                            }
                        } else {
                            if (!add) {
                                Map<String, Object> rawData = new HashMap<>(2);
                                rawData.put("data", driverVehicle);
                                BottomButtonDigiwinAthena bottomButtonDigiwinAthena = new BottomButtonDigiwinAthena();
                                bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, (String) button.get("name")));
                                bottomButtonDigiwinAthena.setType((Integer) button.get("type"));
                                Action action1 = JsonUtil.objectToJavaObject(button.get("action"), Action.class);
                                PopPromptMsg popPromptMsg = action1.getPopPromptMsg();
                                popPromptMsg.setContent(LocaleUtil.getMobileTextByDatabaseKey(locale, popPromptMsg.getContent()));
                                List<Button> buttonList = popPromptMsg.getButtonList();
                                for (Button button1 : buttonList) {
                                    button1.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, button1.getName()));
                                    Action action = button1.getAction();
                                    if (action == null) {
                                        action = new Action();
                                    }
                                    action.setRawData(rawData);
                                }
                                bottomButtonDigiwinAthena.setIsCheckButton(false);
                                rawData.put("driverCarType", "delete");
                                action1.setRawData(rawData);
                                bottomButtonDigiwinAthena.setAction(action1);
                                buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                            }
                        }
                    }
                    mobilePageData.put(schema, buttonDigiwinAthenas);
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setPageData(pageData);
        stopWatch.stop();
        CustomGroup customGroup = CustomGroup.create(LocaleUtil.getMobileTextByKey(locale, "车辆信息"), uiBotModel);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        mobilePageData.put(customGroupSchema, customGroup);
        mobileUibotModel.setPageData(mobilePageData);
        mobileUibotModel.setPageBackgroudColor(uiBotModel.getPageBackgroudColor());
        return mobileUibotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/CarMessage.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
