package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbTransportReceiptStatusCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @desc 在途宝回单签字-货物清单展示策略
 */
@Component("uiBotModelBuildZTBCargoInformationListStrategy")
public class UiBotModelBuildZTBCargoInformationListStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBCargoInformationListStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build ZTBCargoInformationList");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        Map<String, Object> rawData = apiRequest.getRawData();
        String locale = apiRequest.getLocale();
        List<ZtbTransportReceiptStatusCount> counts =
                ModuleUtils.listMapToListObject((List<?>) rawData.get("informationCounts"), ZtbTransportReceiptStatusCount.class);
        Map<String, Object> cargoInfoMaps = (Map<String, Object>) rawData.get("informationMaps");
        if (CollectionUtils.isEmpty(counts) || CollectionUtils.isEmpty(cargoInfoMaps)) {
            return UiBotModel.emptyUibotModel(locale);
        }
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomTabs.COMPONENT_TYPE:
                    //货物清单
                    CustomTabs customTabs = JsonUtil.objectToJavaObject(pageData.get(schema), CustomTabs.class);
                    customTabs.detailMessage(customTabs, counts, cargoInfoMaps, locale, localeService);
                    pageData.put(schema, customTabs);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
