package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：在途宝已收货详情页策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: uiBotModelBuildZTBAddressBookStrategy
 * @Author: wuyang
 * @Date: 20230306
 */
@Component("uiBotModelBuildZTBDeliveryLoadEditItemStrategy")
public class UiBotModelBuildZTBDeliveryLoadEditItemStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBDeliveryLoadEditItemStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Ztb handel Bottom");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        logger.debug(JSONUtil.toJsonStr(uiBotModel));
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        UiBotPageData newPageData = new UiBotPageData();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(fieldSchema), Card.class);
                    newPageData.put(fieldSchema, card.detailMessage(rawData, card, localeService, locale));
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    UiBotModel customUiBot = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), UiBotModel.class);
                    UiBotPageData customPageData = customUiBot.getPageData();
                    for (UiBotLayout uiBotLayout : customUiBot.getLayout()) {
                        String title = localeService.getLanguageValue(locale, uiBotLayout.getLabel());
                        String data = (String) rawData.get(uiBotLayout.getSchema());
                        switch (uiBotLayout.getType()) {
                            case InputSingleText.COMPONENT_TYPE:
                                customPageData.put(uiBotLayout.getSchema(), InputSingleText.create(uiBotLayout.getSchema(), title,
                                        true, true, locale, data, false));
                                break;
                            case InputNumeric.COMPONENT_TYPE:
                                InputNumeric inputNumeric = null;
                                //添加应发数量校验规则
                                if (StrUtil.equals(uiBotLayout.getSchema(), "item_qty")) {
                                    Button button = new Button();
                                    button.setName(localeService.getLanguageValue(locale, "一并汇入"));
                                    button.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());

                                    ParseFieldData fieldData = new ParseFieldData();
                                    fieldData.setLabel(localeService.getLanguageValue(locale, "装车数量"));

                                    List<UiBotRule> uiBotRuleList = new ArrayList<>();
//                                    BigDecimal item_qty = new BigDecimal(data);
                                    BigDecimal unLoadingQty = new BigDecimal(StrUtil.toString(rawData.get("un_loading_qty")));
//                                    BigDecimal subtract = unLoadingQty.subtract(item_qty);
                                    String str = NumberUtil.toStr(NumberUtil.parseNumber(unLoadingQty.toString()));
                                    inputNumeric = InputNumeric.create(locale, fieldData, uiBotRuleList, button, str, true);
                                    inputNumeric.setText(data);
                                    List<ValidateRule> validateRuleList = new ArrayList<>();
                                    ValidateRule validateRule = new ValidateRule();
                                    validateRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                                    validateRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
                                    String un_loading_qty = (String) rawData.get("un_loading_qty");
                                    validateRule.setParameter(un_loading_qty);
                                    validateRule.setOperatorType(4);
                                    validateRule.setErrorMessage(localeService.getLanguageValue(locale, "输入数量不能大于应发数量:" + un_loading_qty));
                                    validateRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                                    validateRuleList.add(validateRule);
                                    ValidateRule validateRule2 = new ValidateRule();
                                    validateRule2.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                                    validateRule2.setType(ValidateRuleTypeEnum.APPOINT.getType());
                                    validateRule2.setParameter("0");
                                    validateRule2.setOperatorType(5);
                                    validateRule2.setErrorMessage(localeService.getLanguageValue(locale, "输入数量应大于0"));
                                    validateRule2.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                                    validateRuleList.add(validateRule2);
                                    inputNumeric.setValidateRuleList(validateRuleList);
                                } else {
                                    inputNumeric = InputNumeric.create(999, 6, data, title,
                                            InputNumericTypeEnum.INTEGER.getValue());
                                    inputNumeric.setPlaceholder("请输入...");
                                    inputNumeric.setRequired(false);
                                }
                                customPageData.put(uiBotLayout.getSchema(), inputNumeric);
                                break;
                            default:
                                break;
                        }
                    }
                    CustomGroupContent content = new CustomGroupContent();
                    content.setLayout(customUiBot.getLayout());
                    content.setPageData(customUiBot.getPageData());
                    customGroup.setContent(content);
                    customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                    newPageData.put(fieldSchema, customGroup);
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
