package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseSizeRatioMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContentDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.image.Image;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：在途宝电子围栏编辑生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: uiBotModelBuildZTBElectronicFenceDetailStrategy
 * @Author: Liux
 * @Date: 2022年7月19日10点34分
 */
@Component("uiBotModelBuildZTBElectronicFenceDetailStrategy")
public class UiBotModelBuildZTBElectronicFenceDetailStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBElectronicFenceDetailStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        return this.doActually(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        //新增样式需要外面包一层CustomGroup
        List<UiBotLayout> mobileUiBotLayouts = new ArrayList<>(2);
        UiBotModel mobileUibotModel = new UiBotModel(mobileUiBotLayouts);
        UiBotLayout mobileUibitLayout = new UiBotLayout();
        String customGroupSchema = UUIDUtil.getUuid();
        mobileUibitLayout.setSchema(customGroupSchema);
        mobileUibitLayout.setType(CustomGroup.COMPONENT_TYPE);
        mobileUiBotLayouts.add(mobileUibitLayout);
        UiBotPageData mobilePageData = new UiBotPageData();

        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> electronicFence = new HashMap<>(4);
        String factoryId = String.valueOf(apiRequest.getRawData().get("factory_id"));
        String factoryName = String.valueOf(apiRequest.getRawData().get("factory_name"));
        String radius = String.valueOf(apiRequest.getRawData().get("radius"));
        String startFlag = String.valueOf(apiRequest.getRawData().get("start_flag"));
        electronicFence.put("factory_id", factoryId);
        electronicFence.put("factory_name", factoryName);
        electronicFence.put("radius", radius);
        electronicFence.put("start_flag", startFlag);

        boolean isIndexEnter = "true".equals(StringUtil.valueOf(apiRequest.getRawData().get("isIndexEnter")));

        // 拼成最终数据
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = new UiBotPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String value = electronicFence.get(layout.getSchema()) == null ? "" : String.valueOf(electronicFence.get(layout.getSchema()));
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    if (StringUtils.hasLength(value)) {
                        Field field = Field.createLabelValueLeftField(localeService.getLanguageValue(locale, layout.getLabel()), value);
                        field.setHidden(StrUtil.equals(schema, "factory_id"));
                        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue());
                        pageData.put(schema, field);
                    }
                    break;
                case InputNumeric.COMPONENT_TYPE:
                    InputNumeric inputNumeric = InputNumeric.create(6, 0, value, localeService.getLanguageValue(locale, layout.getLabel()),
                            InputNumericTypeEnum.INTEGER.getValue());
                    inputNumeric.setPlaceholder("请输入...");
                    inputNumeric.setHidden(!StrUtil.equals(startFlag, "Y"));
                    inputNumeric.setRequired(StrUtil.equals(startFlag, "Y"));
                    List<ValidateRule> validateRuleList = new ArrayList<>();
                    ValidateRule validateRule = new ValidateRule();
                    validateRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                    validateRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
                    validateRule.setParameter("20");
                    validateRule.setOperatorType(6);
                    validateRule.setErrorMessage(localeService.getLanguageValue(locale, "输入半径不能小于20"));
                    validateRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                    validateRuleList.add(validateRule);
                    inputNumeric.setValidateRuleList(validateRuleList);
                    pageData.put(schema, inputNumeric);
                    break;
                case Image.COMPONENT_TYPE:
                    Image image = new Image();
                    BaseSizeRatioMobileComponent.BaseSize baseSize = new BaseSizeRatioMobileComponent.BaseSize();
                    baseSize.setWidth(654);
                    baseSize.setHeight(470);
                    image.setBaseSize(baseSize);
                    BaseImageContent imageContent = new BaseImageContent();
                    imageContent.setDataType(BaseImageContentDataTypeEnum.NETWORK_HTTP_URL.getValue());
                    imageContent.setData("http://180.167.0.43:18086/staticDemo/athena/resources/ztb/drive_electronic_fence_example.png");
                    image.setContent(imageContent);
                    pageData.put(layout.getSchema(), image);
                    break;
                case InputSwitch.COMPONENT_TYPE:
                    pageData.put(schema, InputSwitch.createByZtbCondition(StrUtil.equals(value, "Y"), localeService.getLanguageValue(locale, layout.getLabel()), "radius", "设定电子围栏，可在车辆即将到达时，给司机发送入厂凭证，快速入厂"));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    mobileUiBotLayouts.add(layout);
                    List<Map<String, Object>> bottomButtons = (List<Map<String, Object>>) uiBotModel.getPageData().get("bottomButtons");
                    List<BottomButtonDigiwinAthena> buttonDigiwinAthenas = new ArrayList<>(1);
                    for (Map<String, Object> button : bottomButtons) {
                        //更新或者新增按钮
                        if ("submit".equals(button.get("id"))) {
                            BottomButtonDigiwinAthena bottomButtonDigiwinAthena = new BottomButtonDigiwinAthena();
                            bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByKey(locale, "保存"));
                            Action<Map<String, Object>> action = new Action<>();
                            if (isIndexEnter) {
                                action = JsonUtil.objectToJavaObject(button.get("action"),
                                        new TypeReference<Action<Map<String, Object>>>() {
                                        });
                                if (action.getJumpPageTitle() != null) {
                                    action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                                }
                                if (StringUtils.hasLength(action.getRequestUrl())) {
                                    action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
                                }
                            } else {
                                Map<String, Object> rawData = (Map<String, Object>) ((Map<String, Object>) button.get("action")).get("rawData");
                                action.setType(ActionTypeEnum.CALL_API.getValue());
                                action.setRawData(rawData);
                            }
                            action.getRawData().put("electronicFenceType", "update");
                            action.getRawData().put("data", electronicFence);
                            bottomButtonDigiwinAthena.setAction(action);
                            bottomButtonDigiwinAthena.setId((String) button.get("id"));
                            buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                        }
                    }
                    mobilePageData.put(schema, buttonDigiwinAthenas);
                default:
                    break;
            }
        }
        uiBotModel.setPageData(pageData);
        CustomGroup customGroup = CustomGroup.create(LocaleUtil.getMobileTextByKey(locale, ""), uiBotModel);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        mobilePageData.put(customGroupSchema, customGroup);
        mobileUibotModel.setPageData(mobilePageData);
        mobileUibotModel.setPageBackgroudColor(uiBotModel.getPageBackgroudColor());
        return mobileUibotModel;
    }
}
