package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.pageable.PageableList;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

/**
 * <p>功能描述：在途宝货物装车生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildZTBGoodsLoadingStrategy
 * @Author: Liux
 * @Date: 2022年9月16日13点27分
 */
@Component("uiBotModelBuildZTBGoodsLoadingStrategy")
public class UiBotModelBuildZTBGoodsLoadingStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBGoodsLoadingStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildZTBGoodsLoading");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();

        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = "";
        String tmActivityId = "";
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
            tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        }
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        //任务号
        String taskNo = "";
        List<Map<String, Object>> deliveryDetail = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("delivery_detail");
        if (!CollectionUtils.isEmpty(deliveryDetail)) {
            taskNo = String.valueOf(deliveryDetail.get(0).get("task_no"));
        }
        // 拼成最终数据
        stopWatch.start("Build ZTBGoodsLoading Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData newPageData = new UiBotPageData();
        //TODO 生成相关组件
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    titleBody.setLabelPosition(TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition());
                    newPageData.put(schema, titleBody);
                    List<Tag> tags = titleBody.getTags();
                    //二维码
                    Tag qrCodeTag = Tag.createBlueBgdWriteTextStateTag(LocaleUtil.getMobileTextByKey(locale, "货运二维码") + ">");
                    qrCodeTag.setLabelPosition(TitleLabelPositionEnum.RIGHT_TO_TITLE.getPosition());
                    Action qrCodeAction = new Action<>();
                    qrCodeAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    qrCodeAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK_QR_CODE.toString());
                    qrCodeAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "货运二维码"));
                    qrCodeAction.setDataId(taskNo);
                    qrCodeTag.setAction(qrCodeAction);
                    Map<String, Object> qrCodeActionRawData = new HashMap<>();
                    qrCodeActionRawData.put("task_no", taskNo);
                    qrCodeAction.setRawData(qrCodeActionRawData);
                    tags.add(qrCodeTag);
                    titleBody.setTags(tags);
                    break;
                case MultiFunctionList.COMPONENT_TYPE:
                    MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(pageData.get(schema), MultiFunctionList.class);
                    multiFunctionList.setChoice(MultiFunctionListChoiceEnum.MULTIPLE_CHOICE.toString());
                    multiFunctionList.setPageable(true);
                    multiFunctionList.setTitle(localeService.getLanguageValue(locale, multiFunctionList.getTitle()));
                    multiFunctionList.setSearch(false);
                    multiFunctionList.setDataUrl("/mobile/v1/ztb/cargo/information");
                    multiFunctionList.setStyleType(MultiFunctionListStyleTypeEnum.CARD.toString());
                    ApiRawData rawData = new ApiRawData();
                    rawData.put("task_no", taskNo);
                    rawData.put("isLoadCar", true);
                    multiFunctionList.setRawData(rawData);
                    newPageData.put(schema, multiFunctionList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) pageData.get(schema), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(localeService.getLanguageValue(locale, bottomButton.getName()));
                        if (bottomButton.getAction() != null) {
                            Action action = bottomButton.getAction();
                            ApiRawData buttonRawData = new ApiRawData();
                            buttonRawData.put("task_no", taskNo);
                            buttonRawData.put("biz_id", "ZTB");
                            buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                            buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_LOADING.toString());
                            //rawData里存提交接口所需参数
                            UiBotAction uiBotAction = getSubmitAction(pcUiBotModel, "submit-data");
                            if (null != uiBotAction) {
                                buttonRawData.put("action", uiBotAction);
                                Map<String, Object> data = new HashMap<>();
                                String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                                data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                                buttonRawData.put("data", data);
                            }
                            action.setRawData(buttonRawData);
                        }
                    }
                    newPageData.put(schema, buttons);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }

    /**
     * 在途宝-车辆信息
     *
     * @param driverMessageUiBotModel
     * @param vehicleInfo
     * @param locale
     * @return
     */
    private CustomGroup buildDriverMessageGroup(String locale, List<Map<String, Object>> vehicleInfo, UiBotModel driverMessageUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> driverMessageLayouts = driverMessageUiBotModel.getLayout();
        UiBotPageData pageData = driverMessageUiBotModel.getPageData();
        UiBotPageData driverMessagePageData = new UiBotPageData();
        for (UiBotLayout driverMessageLayout : driverMessageLayouts) {
            String driverMessageSchema = driverMessageLayout.getSchema();
            Map<String, String> schemaPageData = (Map<String, String>) pageData.get(driverMessageSchema);
            switch (driverMessageLayout.getType()) {
                case Field.COMPONENT_TYPE:
                    Field driverMessageField = new Field();
                    //没有值默认给-
                    String value = "-";
                    if (!CollectionUtils.isEmpty(vehicleInfo)) {
                        value = String.valueOf(vehicleInfo.get(0).get(driverMessageSchema));
                    }
//                    driverMessageField = Field.create(schemaPageData.get("label"), "LABEL", value, driverMessageSchema);
                    driverMessageField = Field.create(driverMessageLayout.getmLabelText().get(locale), "LABEL", value, driverMessageSchema,
                            FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                    driverMessagePageData.put(driverMessageSchema, driverMessageField);
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent driverMessageContent = new CustomGroupContent();
        driverMessageContent.setLayout(driverMessageLayouts);
        driverMessageContent.setPageData(driverMessagePageData);
        customGroup.setContent(driverMessageContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey(locale, "车辆信息"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    /**
     * 在途宝-司机信息
     *
     * @param driverInfoUiBotModel
     * @param vehicleInfo
     * @param locale
     * @return
     */
    private CustomGroup buildDriverInfoGroup(String locale, List<Map<String, Object>> vehicleInfo, UiBotModel driverInfoUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> driverInfoLayouts = driverInfoUiBotModel.getLayout();
        UiBotPageData pageData = driverInfoUiBotModel.getPageData();
        UiBotPageData driverInfoPageData = new UiBotPageData();
        for (UiBotLayout driverInfoLayout : driverInfoLayouts) {
            String driverInfoSchema = driverInfoLayout.getSchema();
            Map<String, String> schemaPageData = (Map<String, String>) pageData.get(driverInfoSchema);
            switch (driverInfoLayout.getType()) {
                case Field.COMPONENT_TYPE:
                    Field driverInfoField = new Field();
                    //没有值默认给-
                    String value = "-";
                    if (!CollectionUtils.isEmpty(vehicleInfo)) {
                        value = String.valueOf(vehicleInfo.get(0).get(driverInfoSchema));
                    }
                    String fieldType = "LABEL";
                    if ("driver_mobile".equalsIgnoreCase(driverInfoSchema)) {
                        //在途宝 电话字段 类型变成PHONE
                        fieldType = "PHONE";
                    }
                    driverInfoField = Field.create(driverInfoLayout.getmLabelText().get(locale), fieldType, value, driverInfoSchema,
                            FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                    driverInfoPageData.put(driverInfoSchema, driverInfoField);
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent driverInfoContent = new CustomGroupContent();
        driverInfoContent.setLayout(driverInfoLayouts);
        driverInfoContent.setPageData(driverInfoPageData);
        customGroup.setContent(driverInfoContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey(locale, "司机信息"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    /**
     * 在途宝-货运信息
     *
     * @param freightUiBotModel
     * @param taskNo
     * @param locale
     * @return
     */
    private CustomGroup buildFreightGroup(String locale, String taskNo, UiBotModel freightUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> freightLayouts = freightUiBotModel.getLayout();
        UiBotPageData pageData = freightUiBotModel.getPageData();
        UiBotPageData freightPageData = new UiBotPageData();
        for (UiBotLayout freightLayout : freightLayouts) {
            String freightSchema = freightLayout.getSchema();
            Map<String, String> schemaPageData = (Map<String, String>) pageData.get(freightSchema);
            switch (freightLayout.getType()) {
                case PageableList.COMPONENT_TYPE:
                    PageableList freightPageableList = new PageableList();
                    Map<String, Object> rawData = new HashMap<>();
                    rawData.put("task_no", taskNo);
                    rawData.put("use_has_next", true);
                    freightPageableList = PageableList.create(rawData,
                            "/mobile/v1/uibot/component/pageablelist/data",
                            "");
//                            freightLayout.getmLabelText().get(locale));
                    freightPageData.put(freightSchema, freightPageableList);
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent freightContent = new CustomGroupContent();
        freightContent.setLayout(freightLayouts);
        freightContent.setPageData(freightPageData);
        customGroup.setContent(freightContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey(locale, "货物信息"));
        return customGroup;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List<UiBotLayout> layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty(layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<>();
        outer:
        for (UiBotLayout layout : layoutList) {
            List<UiBotAction> actions = layout.getActions();
            if (CollectionUtils.isEmpty(actions)) {
                continue;
            }
            for (UiBotAction action : actions) {
                if (actionId.equalsIgnoreCase(action.getActionId())) {
                    uiBotAction.set(action);
                    break outer;
                }
            }
        }
        return uiBotAction.get();
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
