package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.List;

/**
 * 货物装车-车辆选择底部弹窗界面
 *
 * @author zhangjj
 * @date 2022/11/24 17:37
 */
@Component("uiBotModelBuildZTBGoodsLoadingVehicleInfoStrategy")
public class UiBotModelBuildZTBGoodsLoadingVehicleInfoStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return this.doActually(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        String taskNo = (String) apiRawData.get("task_no");
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotPageData newPageData = new UiBotPageData();
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            String layoutType = layout.getType();
            String schema = layout.getSchema();
            switch (layoutType) {
                case MultiFunctionList.COMPONENT_TYPE:
                    MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(pageData.get(schema), MultiFunctionList.class);
                    multiFunctionList.setChoice(MultiFunctionListChoiceEnum.SINGLE_CHOICE.toString());
                    multiFunctionList.setPageable(false);
                    multiFunctionList.setSearch(true);
                    multiFunctionList.setDataUrl("/mobile/v1/ztb/vehicle/information");
                    multiFunctionList.setStyleType(MultiFunctionListStyleTypeEnum.SPLIT_LINE.toString());
                    ApiRawData rawData = new ApiRawData();
                    rawData.put("task_no", taskNo);
                    rawData.put("is_load_car", true);
                    multiFunctionList.setRawData(rawData);
                    newPageData.put(schema, multiFunctionList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) pageData.get(schema), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(localeService.getLanguageValue(locale, bottomButton.getName()));
                        if (bottomButton.getAction() != null && ActionTypeEnum.CALL_API_ONLY.getValue().equals(bottomButton.getAction().getType())) {
                            Action action = bottomButton.getAction();
                            apiRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_LOADING_VEHICLE_INFO.toString());
                            action.setRawData(apiRawData);
                            ConfirmPop confirmPop = action.getConfirmPop();
                            if (confirmPop != null && confirmPop.getNeedConfirm() != null && confirmPop.getNeedConfirm()) {
                                if (StringUtils.hasLength(confirmPop.getContent())) {
                                    confirmPop.setContent(localeService.getLanguageValue(locale, confirmPop.getContent()));
                                }
                                if (StringUtils.hasLength(confirmPop.getTitle())) {
                                    confirmPop.setTitle(localeService.getLanguageValue(locale, confirmPop.getTitle()));
                                }
                            }
                        }
                    }
                    newPageData.put(schema, buttons);
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }
}
