package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author wuyang
 * @desc 在途宝收货排程修改策略
 */
@Component("uiBotModelBuildZTBModificationReceiptScheduleStrategy")
public class UiBotModelBuildZTBModificationReceiptScheduleStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBModificationReceiptScheduleStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildModificationReceiptSchedule");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        //TODO 待确认是否还是一个地方取得
        String transportNo = "";
        String taskNo = "";
        String deliveryNo = "";
        List<Map<String, Object>> deliveryDetailList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("cargo_information");
        if (!CollectionUtils.isEmpty(deliveryDetailList)) {
            taskNo = String.valueOf(deliveryDetailList.get(0).get("task_no"));
            deliveryNo = String.valueOf(deliveryDetailList.get(0).get("delivery_no"));
            transportNo = String.valueOf(deliveryDetailList.get(0).get("transport_no"));
        }
        Map<String, Object> transportMainInfo = digiwinEspProxyService.
                getTransportMainInfoResponseMap(iamUserToken, tenantId, locale, transportNo);
        Map<String, Object> transportVehicleInfo = digiwinEspProxyService.
                getTransportVehicleInfo(iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    pageData.put(schema, titleBody);
                    break;
                case MessageBar.COMPONENT_TYPE:
                    MessageBar messageBar = JsonUtil.objectToJavaObject(pageData.get(schema), MessageBar.class);
                    messageBar.setContent(localeService.getLanguageValue(locale, messageBar.getContent()));
                    pageData.put(schema, messageBar);
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    //车辆信息和司机信息
                    if ("carMessage".equalsIgnoreCase(schema) || "driverMeaasge".equalsIgnoreCase(schema)) {
                        card.detailMessage(transportVehicleInfo, card, localeService, locale);
                    }
                    pageData.put(schema, card);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    UiBotModel customUiboModel = JsonUtil.objectToJavaObject(pageData.get(schema), UiBotModel.class);
                    //物流信息
                    if ("logisticsMessage".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale,
                                JsonUtil.objectToJavaObject(transportMainInfo, DigiwinTransportResponse.class),
                                customUiboModel, false);
                    } else if ("receiptPreparation".equalsIgnoreCase(schema)) {
                        if (StringUtils.hasLength((String) transportMainInfo.get("unloader_id"))) {
                            customGroup.setName(localeService.getLanguageValue(locale, customUiboModel.getName()));
                            customGroup.buildReceiptPreparation(customUiboModel,
                                    localeService, digiwinEspProxyService, apiRequest, transportMainInfo, transportNo, taskNo);
                            CustomGroupContent content = new CustomGroupContent();
                            content.setLayout(customUiboModel.getLayout());
                            content.setPageData(customUiboModel.getPageData());
                            customGroup.setContent(content);
                            customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                        } else {
                            CustomGroupContent content = new CustomGroupContent();
                            customGroup.setContent(content);
                        }
                    } else if ("platformMessage".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildPlatformMessage(transportMainInfo, customUiboModel,
                                apiRequest, localeService, deliveryNo);
                        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                    }
                    pageData.put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Map<String, Object> buttonRawData = new HashMap<>(3);
                        Action action = bottomButtonDigiwinAthena.getAction();
                        ConfirmPop confirmPop = action.getConfirmPop();
                        if (confirmPop != null) {
                            confirmPop.setContent(localeService.getLanguageValue(locale, confirmPop.getContent()));
                            buttonRawData.put("isCancel", true);
                        } else {
                            buttonRawData.put("isCancel", false);
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("page_id", apiRequest.getPageId());
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        UiBotAction uiBotAction = UiBotModel.getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            Map<String, Object> data = new HashMap<>(1);
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData(buttonRawData);
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
