package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeDistrict;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeDistrictTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：在途宝地址信息新增/编辑生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildZTBModifiyAddressStrategy
 * @Author: wuyang
 * @Date: 20230220
 */
@Component("uiBotModelBuildZTBModifiyAddressStrategy")
public class UiBotModelBuildZTBModifiyAddressStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBModifiyAddressStrategy.class);

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService espProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildAddressMessage");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        Map<String, Object> rawData = apiRequest.getRawData();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(
                            pageData.get(uiBotLayout.getSchema()), CustomGroup.class);
                    pageData.put(uiBotLayout.getSchema(), buildAddressCustomGroup(customGroup, rawData,
                            apiRequest, CollectionUtils.isEmpty(rawData)));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageData.get(uiBotLayout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(button -> {
                        Action action = button.getAction();
                        if (action == null) {
                            action = new Action();
                            action.setType(ActionTypeEnum.CALL_API.getValue());
                        }
                        Map<String, Object> actionRawData = new HashMap<>(2);
                        actionRawData.put("page_id", apiRequest.getPageId());
                        actionRawData.put("biz_id", "ZTB");
                        actionRawData.put("isAdd", CollectionUtils.isEmpty(rawData));
                        action.setRawData(actionRawData);
                    });
                    pageData.put(uiBotLayout.getSchema(), bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private CustomGroup buildAddressCustomGroup(CustomGroup customGroup, Map<String, Object> rawData,
                                                ApiRequest apiRequest, Boolean isAdd) {
        customGroup.setName(localeService.getLanguageValue(apiRequest.getLocale(), customGroup.getName()));
        CustomGroupContent content = customGroup.getContent();
        List<UiBotLayout> uiBotLayouts = content.getLayout();
        UiBotPageData pageData = content.getPageData();
        Map<String, Object> userAddress = new HashMap<>(16);
        if (!isAdd) {
            String addressId = (String) rawData.get("address_id");
            userAddress = espProxyService.getUserAddress(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                    apiRequest.getLocale(), addressId);
        }
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case InputSingleText.COMPONENT_TYPE:
                    pageData.put(layout.getSchema(), InputSingleText.create(layout.getSchema(),
                            localeService.getLanguageValue(apiRequest.getLocale(), layout.getLabel()),
                            true, true, apiRequest.getLocale(), isAdd ? "" :
                                    (String) userAddress.get(layout.getSchema()), false));
                    break;
                case InputCascadeDistrict.COMPONENT_TYPE:
                    pageData.put(layout.getSchema(), InputCascadeDistrict.create(layout.getSchema(),
                            localeService.getLanguageValue(apiRequest.getLocale(), layout.getLabel()),
                            apiRequest.getLocale(), isAdd ? Collections.emptyMap() : userAddress, true,
                            InputCascadeDistrictTypeEnum.ALL_PCA.getValue()));
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    pageData.put(layout.getSchema(), InputMultiText.create(layout.getSchema(),
                            localeService.getLanguageValue(apiRequest.getLocale(), layout.getLabel()),
                            isAdd ? "" : (String) userAddress.get(layout.getSchema()), true,
                            true, false, apiRequest.getLocale()));
                    break;
                default:
                    break;
            }
        }
        return customGroup;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/addressMessage.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
