package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Message;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageNode;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 在途宝项目，物流详情界面
 *
 * @author zhangjj
 * @date 2022/12/26 13:29
 */
@Component
public class UiBotModelBuildZTBProjectLogisticsStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        List<Map<String, Object>> logisticsDetailList = (List<Map<String, Object>>) apiRawData.get("data");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case MessageNode.COMPONENT_TYPE:
                    MessageNode messageNode = JsonUtil.objectToJavaObject(pageData.get(schema), MessageNode.class);
                    List<Message> messageList = messageNode.getMessageList();
                    if (!CollectionUtils.isEmpty(logisticsDetailList)) {
                        logisticsDetailList.stream().forEach(logisticsDetail -> {
                            Message message = new Message();
                            String logisticsTime = (String) logisticsDetail.get("logistics_time");
                            if (logisticsTime != null && logisticsTime.contains("-")) {
                                if (StringUtils.hasLength(logisticsTime)) {
                                    String[] datas = logisticsTime.split(" ");
                                    message.setDate(DateTimeUtil.getFullMonth(Integer.valueOf(datas[0].split("-")[1])) + "-" + DateTimeUtil.getFullDate(Integer.valueOf(datas[0].split("-")[2])));
                                    message.setTime(datas[1]);
                                }
                            } else {
                                message.setDate(DateTimeUtil.getFullMonth(Integer.valueOf(((String) logisticsDetail.get("logistics_date")).split("-")[1])) + "-" + DateTimeUtil.getFullDate(Integer.valueOf(((String) logisticsDetail.get("logistics_date")).split("-")[2])));
                                message.setTime(logisticsTime);
                            }

                            message.setMessage((String) logisticsDetail.get("logistics_desc"));
                            messageList.add(message);
                        });
                    }
                    Collections.reverse(messageList);
                    pageData.put(schema, messageNode);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageData.get(layout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String name = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(name)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), name));
                        }
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }
}
