package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;

/**
 * 收货准备-拒收页面
 *
 * @author 吴阳
 * @date 20230227
 */
@Component
public class UiBotModelBuildZTBReceiptConfirmationRejectionStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case SingleSelectList.COMPONENT_TYPE:
                    pageData.put(schema, SingleSelectList.createByZtbEnum(digiwinEspProxyService.getEnumerateInfo(
                            apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                            schema), localeService.getLanguageValue(locale, layout.getLabel()),
                            "", ""));
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText text = JsonUtil.objectToJavaObject(pageData.get(schema), InputMultiText.class);
                    text.setTitle(localeService.getLanguageValue(locale, text.getTitle()));
                    pageData.put(schema, text);
                    break;
                case Picture.COMPONENT_TYPE:
                    pageData.put(schema, Picture.createEmptyPic(schema, "",
                            AttachmentTypeEnum.READ_AND_WRITE.getValue(), false, "driver_vehicle_img"));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class
                    );
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                        if (ActionTypeEnum.CALL_API.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            ApiRawData buttonRawData = new ApiRawData();
                            buttonRawData.put("transport_no", rawData.get("transport_no"));
                            buttonRawData.put("biz_id", "ZTB");
                            buttonRawData.put("page_id", pageSetting.getPageId());
                            buttonRawData.put("action", rawData.get("action"));
                            buttonRawData.put("data", rawData.get("data"));
                            buttonRawData.put("submitParams", apiRequest.getSubmitParam());
                            action.setRawData(buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }
}
