package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbCargoUnloading;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbTransportReceiptStatusCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

/**
 * @author wuyang
 * @desc 在途宝收货确认
 */
@Component("uiBotModelBuildZTBReceiptConfirmationStrategy")
public class UiBotModelBuildZTBReceiptConfirmationStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBReceiptConfirmationStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build ReceiptConfirmation");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }
        Boolean hasReject = false;
        if (apiRawData.get("hasReject") != null && (Boolean) apiRawData.get("hasReject")) {
            hasReject = true;
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        //TODO 待确认是否还是一个地方取得
        String transportNo = "";
        String taskNo = "";
        List<Map<String, Object>> deliveryDetailList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("cargo_information");
        if (!CollectionUtils.isEmpty(deliveryDetailList)) {
            taskNo = String.valueOf(deliveryDetailList.get(0).get("task_no"));
            transportNo = String.valueOf(deliveryDetailList.get(0).get("transport_no"));
        }
        Boolean hasNoUnLoding = false;
        Map<String, Object> transportMainInfo = digiwinEspProxyService.
                getTransportMainInfoResponseMap(iamUserToken, tenantId, locale, transportNo);
        Map<String, Object> transportVehicleInfo = digiwinEspProxyService.getTransportVehicleInfo(
                iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    pageData.put(schema, titleBody);
                    break;
                case GraphicDisplay.COMPONENT_TYPE:
                    pageData.put(layout.getSchema(), GraphicDisplay.createNoSubTitle(JsonUtil.objectToJavaObject(
                            transportVehicleInfo, ZTBDriverVehicle.class), 1, digiwinDmcProxyService));
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    if ("platformMessage".equalsIgnoreCase(schema)) {
                        card.detailPlatformMessage(transportMainInfo, card, localeService, locale);
                    }
                    pageData.put(schema, card);
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    List<ZtbTransportReceiptStatusCount> counts = digiwinEspProxyService.getTransportReceiptStatusCount(iamUserToken, tenantId, locale, transportNo);
                    Map<String, List<ZtbCargoUnloading>> cargoInfoMaps = new HashMap<>(counts.size());
                    for (ZtbTransportReceiptStatusCount count : counts) {
                        Map<String, Object> params = new HashMap<>(2);
                        params.put("transport_no", transportNo);
                        params.put("receipt_status", count.getReceiptStatus());
                        List<ZtbCargoUnloading> cargoUnloadings = digiwinEspProxyService.getTransportReceiptItemInfo(iamUserToken, tenantId, locale, params);
                        if (CollectionUtils.isEmpty(cargoUnloadings)) {
                            if ("0".equalsIgnoreCase(count.getReceiptStatus())) {
                                hasNoUnLoding = true;
                            }
                            cargoUnloadings = Collections.emptyList();
                        }
                        cargoInfoMaps.put(count.getReceiptStatus(), cargoUnloadings);
                    }
                    CustomTabs customTabs = JsonUtil.objectToJavaObject(pageData.get(schema), CustomTabs.class);
                    customTabs.detailMessage(customTabs, cargoInfoMaps, counts, localeService, locale, hasReject);
                    pageData.put(schema, customTabs);
                    break;
                case MultiFunctionList.COMPONENT_TYPE:
                    //货物信息
                    MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(pageData.get(schema), MultiFunctionList.class);
                    ApiRawData rawData = new ApiRawData();
                    rawData.put("transport_no", transportNo);
                    rawData.put("type", "isTransport");
                    multiFunctionList.setRawData(rawData);
                    pageData.put(schema, multiFunctionList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    if (hasNoUnLoding) {
                        pageData.remove(schema);
                        continue;
                    }
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    Map<String, Object> buttonRawData = new HashMap<>(6);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Action action = bottomButtonDigiwinAthena.getAction();
                        String jumpPageTitle = action.getJumpPageTitle();
                        if (StringUtils.hasLength(jumpPageTitle)) {
                            action.setJumpPageTitle(localeService.getLanguageValue(locale, jumpPageTitle));
                        }
                        ConfirmPop confirmPop = action.getConfirmPop();
                        if (confirmPop != null) {
                            confirmPop.setContent(localeService.getLanguageValue(locale, confirmPop.getContent()));
                            buttonRawData.put("page_id", action.getJumpPageId());
                        } else {
                            buttonRawData.put("page_id", apiRequest.getPageId());
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        UiBotAction uiBotAction = UiBotModel.getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            Map<String, Object> data = new HashMap<>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData(buttonRawData);
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
