package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author wuyang
 * @desc 在途宝收货准备策略
 */
@Component("uiBotModelBuildZTBReceiptPreparationStrategy")
public class UiBotModelBuildZTBReceiptPreparationStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBReceiptPreparationStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("build UiBotModelBuildZTBReceiptPreparationStrategy");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //任务卡信息
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //TODO 待确认是否还是一个地方取得
        String transportNo = "";
        String taskNo = "";
        List<Map<String, Object>> deliveryDetailList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("cargo_information");
        if (!CollectionUtils.isEmpty(deliveryDetailList)) {
            taskNo = String.valueOf(deliveryDetailList.get(0).get("task_no"));
            transportNo = String.valueOf(deliveryDetailList.get(0).get("transport_no"));
        }

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    pageData.put(schema, titleBody);
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    if ("platformMessage".equalsIgnoreCase(schema)) {
                        card.detailPlatformMessage(digiwinEspProxyService.
                                getTransportMainInfoResponseMap(iamUserToken, tenantId,
                                        locale, transportNo), card, localeService, locale);
                    } else if ("carMessage".equalsIgnoreCase(schema)) {
                        card.detailMessage(digiwinEspProxyService.
                                getTransportVehicleInfo(iamUserToken, tenantId,
                                        locale, transportNo), card, localeService, locale);
                    }
                    pageData.put(schema, card);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    UiBotModel customUiboModel = JsonUtil.objectToJavaObject(pageData.get(schema), UiBotModel.class);
                    List<UiBotLayout> uiBotLayoutList = customUiboModel.getLayout();
                    UiBotPageData customPageData = customUiboModel.getPageData();
                    customGroup.setName(localeService.getLanguageValue(locale, customUiboModel.getName()));
                    if ("receiptPreparation".equalsIgnoreCase(schema)) {
                        customGroup.buildReceiptPreparation(customUiboModel,
                                localeService, digiwinEspProxyService, apiRequest,
                                new HashMap<>(0), transportNo, taskNo);
                    } else if ("cargoInformation".equalsIgnoreCase(schema)) {
                        //货运信息，不需要显示头信息
                        customGroup.setName("");
                        for (UiBotLayout uiBotLayout : uiBotLayoutList) {
                            switch (uiBotLayout.getType()) {
                                case PageButton.COMPONENT_TYPE:
                                    PageButton pageButton = new PageButton();
                                    pageButton.setName(localeService.getLanguageValue(locale, customUiboModel.getName()));
                                    Action pageButtonAction = JsonUtil.objectToJavaObject(customPageData.get("action"), Action.class);
                                    pageButtonAction.setJumpPageTitle(localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                                    pageButtonAction.setDataId(transportNo);
                                    pageButton.setAction(pageButtonAction);
                                    customPageData.put(uiBotLayout.getSchema(), pageButton);
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    CustomGroupContent content = new CustomGroupContent();
                    content.setLayout(uiBotLayoutList);
                    content.setPageData(customPageData);
                    customGroup.setContent(content);
                    customGroup.setHiddenConfig(new HiddenConfig());
                    customGroup.setUseExpand(false);
                    customGroup.setHasDetail(false);
                    customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                    pageData.put(schema, customGroup);
                    break;
                case PageButton.COMPONENT_TYPE:
                    PageButton pageButton = JsonUtil.objectToJavaObject(pageData.get(schema), PageButton.class);
                    pageButton.setName(localeService.getLanguageValue(locale, pageButton.getName()));
                    Action pageButtonAction = pageButton.getAction();
                    if ("cargoInformation".equalsIgnoreCase(schema)) {
                        pageButtonAction.setJumpPageTitle(localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                        pageButtonAction.setDataId(transportNo);
                    } else if ("shippingSchedule".equalsIgnoreCase(schema)) {
                        pageButtonAction.setJumpPageTitle(localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                        Map<String, Object> params = new HashMap<>(1);
                        params.put("module_type", "2");
                        String url = digiwinEspProxyService.getSrmLoadingWebUrl(iamUserToken, tenantId, locale, params) + "&userId=" + apiRequest.getUserId();
                        pageButtonAction.setRequestUrl(url);
                    }
                    pageButton.setAction(pageButtonAction);
                    pageData.put(schema, pageButton);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Action action = bottomButtonDigiwinAthena.getAction();
                        Map<String, Object> buttonRawData = new HashMap<>(3);
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("page_id", apiRequest.getPageId());
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        UiBotAction uiBotAction = UiBotModel.getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            Map<String, Object> data = new HashMap<>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData(buttonRawData);
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }

        return uiBotModel;
    }

    private String getValue(String value) {
        if (StringUtils.hasLength(value)) {
            return value;
        } else {
            return "-";
        }
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
