package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author wuyang
 * @desc 在途宝项目发起-收货排程修改策略
 */
@Component("uiBotModelBuildZTBReceiptScheduleChangeStrategy")
public class UiBotModelBuildZTBReceiptScheduleChangeStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBReceiptScheduleChangeStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildZTBReceiptScheduleChangeStrategy");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData rawData = apiRequest.getRawData();
        JSONObject data = rawData.getJSONObject("data");
        UiBotModel pcUiBotModel = JsonUtil.objectToJavaObject(rawData.get("pcUiBotModel"), UiBotModel.class);
        String transportNo = data.getString("transport_no");
        String taskNo = data.getString("task_no");

        Map<String, Object> transportMainInfo = digiwinEspProxyService.
                getTransportMainInfoResponseMap(iamUserToken, tenantId, locale, transportNo);
        Map<String, Object> transportVehicleInfo = digiwinEspProxyService.
                getTransportVehicleInfo(iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    pageData.put(schema, InputWindowSingleSelect.create(pcUiBotModel.getLayout().get(0), true,
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=ZtbReceiptScheduleChange",
                            pcUiBotModel, true,
                            data, apiRequest));
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    //车辆信息和司机信息
                    if ("carMessage".equalsIgnoreCase(schema) || "driverMeaasge".equalsIgnoreCase(schema)) {
                        card.detailMessage(transportVehicleInfo, card, localeService, locale);
                    }
                    pageData.put(schema, card);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    UiBotModel customUiboModel = JsonUtil.objectToJavaObject(pageData.get(schema), UiBotModel.class);
                    //物流信息
                    if ("logisticsMessage".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale,
                                JsonUtil.objectToJavaObject(transportMainInfo, DigiwinTransportResponse.class),
                                customUiboModel, false);
                    } else if ("receiptPreparation".equalsIgnoreCase(schema)) {
                        if (StringUtils.hasLength((String) transportMainInfo.get("unloader_id"))) {
                            customGroup.setName(localeService.getLanguageValue(locale, customUiboModel.getName()));
                            customGroup.buildReceiptPreparation(customUiboModel,
                                    localeService, digiwinEspProxyService, apiRequest, transportMainInfo, transportNo, taskNo);
                            CustomGroupContent content = new CustomGroupContent();
                            content.setLayout(customUiboModel.getLayout());
                            content.setPageData(customUiboModel.getPageData());
                            customGroup.setContent(content);
                            customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                        } else {
                            CustomGroupContent content = new CustomGroupContent();
                            customGroup.setContent(content);
                        }
                    } else if ("platformMessage".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildPlatformMessage(transportMainInfo, customUiboModel,
                                apiRequest, localeService, (String) transportMainInfo.get("delivery_no"));
                        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                    }
                    pageData.put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Map<String, Object> buttonRawData = new HashMap<>(3);
                        Action action = bottomButtonDigiwinAthena.getAction();
                        ConfirmPop confirmPop = action.getConfirmPop();
                        if (confirmPop != null) {
                            confirmPop.setContent(localeService.getLanguageValue(locale, confirmPop.getContent()));
                            buttonRawData.put("isCancel", true);
                        } else {
                            buttonRawData.put("isCancel", false);
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("page_id", apiRequest.getPageId());
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", "");
                        UiBotAction uiBotAction = UiBotModel.getSubmitAction(pcUiBotModel, "sd_manual.project.create");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            Map<String, Object> actionData = new HashMap<>(1);
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            actionData.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                            buttonRawData.put("data", actionData);
                        }
                        action.setRawData(buttonRawData);
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
