package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.pageable.PageableList;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbCargoUnloading;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbTransportReceiptStatusCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.TimeSlot;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;

/**
 * <p>功能描述：在途宝回单签字生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: uiBotModelBuildZTBReceiptSignatureStrategy
 * @Author: Liux
 * @Date: 2022年9月16日13点27分
 */
@Component("uiBotModelBuildZTBReceiptSignatureStrategy")
public class UiBotModelBuildZTBReceiptSignatureStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBReceiptSignatureStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildZTBReceiptSignature");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {

        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();

        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = "";
        String tmActivityId = "";
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
            tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        }
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        //任务号
        String taskNo = "";
        String transportNo = "";
        List<Map<String, Object>> deliveryDetailList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("cargo_information");
        if (!CollectionUtils.isEmpty(deliveryDetailList)) {
            taskNo = String.valueOf(deliveryDetailList.get(0).get("task_no"));
            transportNo = String.valueOf(deliveryDetailList.get(0).get("transport_no"));
        }

        Map<String, Object> transportMainInfoMap = digiwinEspProxyService.getTransportMainInfoResponseMap(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo);
        DigiwinTransportResponse transportMainInfo = JsonUtil.objectToJavaObject(transportMainInfoMap, DigiwinTransportResponse.class);
        Map<String, Object> vehicleInfo = digiwinEspProxyService.getTransportVehicleInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo);
        // 拼成最终数据
        stopWatch.start("Build ZTBGoodsDeparture Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData newPageData = new UiBotPageData();
        //TODO 生成相关组件
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    titleBody.setLabelPosition(TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition());
                    newPageData.put(schema, titleBody);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_LOGISTICS".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, transportMainInfo,
                                JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), UiBotModel.class), false);
                    }
//                    else if ("receipt_pic_file_list".equalsIgnoreCase(schema)) {
//                        customGroup = customGroup.buildZtbPictrue("回单上传", locale, localeService, schema, true, "请上传签字后的回单照片");
//                    }
                    else if ("cargo_information".equalsIgnoreCase(schema)) {
                        List<ZtbTransportReceiptStatusCount> counts = digiwinEspProxyService.getTransportReceiptStatusCount(iamUserToken, tenantId, locale, transportNo);
                        Map<String, List<ZtbCargoUnloading>> cargoInfoMaps = new HashMap<>(counts.size());
                        for (ZtbTransportReceiptStatusCount count : counts) {
                            Map<String, Object> params = new HashMap<>(2);
                            params.put("transport_no", transportNo);
                            params.put("receipt_status", count.getReceiptStatus());
                            List<ZtbCargoUnloading> cargoUnloadings = digiwinEspProxyService.getTransportReceiptItemInfo(iamUserToken, tenantId, locale, params);
                            if (CollectionUtils.isEmpty(cargoUnloadings)) {
                                cargoUnloadings = Collections.emptyList();
                            }
                            cargoInfoMaps.put(count.getReceiptStatus(), cargoUnloadings);
                        }
                        Map<String, Object> rawData = new HashMap<>(2);
                        rawData.put("informationCounts", counts);
                        rawData.put("informationMaps", cargoInfoMaps);
                        customGroup = customGroup.buildPageButton(schema, localeService.getLanguageValue(locale, "货物清单"), rawData);
                    }
                    newPageData.put(schema, customGroup);
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    newPageData.put(schema, Card.create(card, localeService, locale, transportNo, transportMainInfoMap));
                    break;
                case PageButton.COMPONENT_TYPE:
                    List<ZtbTransportReceiptStatusCount> counts = digiwinEspProxyService.getTransportReceiptStatusCount(iamUserToken, tenantId, locale, transportNo);
                    Map<String, List<ZtbCargoUnloading>> cargoInfoMaps = new HashMap<>(counts.size());
                    for (ZtbTransportReceiptStatusCount count : counts) {
                        Map<String, Object> params = new HashMap<>(2);
                        params.put("transport_no", transportNo);
                        params.put("receipt_status", count.getReceiptStatus());
                        List<ZtbCargoUnloading> cargoUnloadings = digiwinEspProxyService.getTransportReceiptItemInfo(iamUserToken, tenantId, locale, params);
                        if (CollectionUtils.isEmpty(cargoUnloadings)) {
                            cargoUnloadings = Collections.emptyList();
                        }
                        cargoInfoMaps.put(count.getReceiptStatus(), cargoUnloadings);
                    }
                    Map<String, Object> rawData = new HashMap<>(2);
                    rawData.put("informationCounts", counts);
                    rawData.put("informationMaps", cargoInfoMaps);
                    PageButton pageButton = new PageButton();
                    pageButton.setName(localeService.getLanguageValue(locale, "货物清单"));
                    Action action1 = new Action();
                    action1.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_CARGO_INFORMATION_LIST.toString());
                    action1.setJumpPageTitle(localeService.getLanguageValue(locale, "货物清单"));
                    action1.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                    action1.setRawData(rawData);
                    pageButton.setAction(action1);
                    newPageData.put(schema, pageButton);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = ModuleUtils.listMapToListObject((List) pageData.get(schema), BottomButtonDigiwinAthena.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    bottomButtonList.forEach(bottomButton -> {
//                        bottomButton.setName(localeService.getLanguageValue(locale, bottomButton.getName()));
//                        bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());
//                        Action action = bottomButton.getAction();
//                        if (action.getConfirmPop() != null) {
//                            ConfirmPop confirmPop = action.getConfirmPop();
//                            confirmPop.setContent(localeService.getLanguageValue(locale, confirmPop.getContent()));
//                        }
//                        action.setType(ActionTypeEnum.CALL_API.getValue());
//                        Map<String, Object> buttonRawData = new HashMap<>();
//                        buttonRawData.put("task_no", finalTaskNo);
//                        buttonRawData.put("transport_no", finalTransportNo);
//                        buttonRawData.put("biz_id", "ZTB");
//                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
//                        buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_RECEIPT_SIGNATURE.toString());
//                        //rawData里存提交接口所需参数
//                        UiBotAction uiBotAction = getSubmitAction(pcUiBotModel, "submit-data");
//                        if (null != uiBotAction) {
//                            buttonRawData.put("action", uiBotAction);
//                            Map<String, Object> data = new HashMap<>();
//                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
//                            data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
//                            buttonRawData.put("data", data);
//                        }
//                        action.setRawData(buttonRawData);
//                        bottomButton.setAction(action);
                        String buttonName = bottomButton.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButton.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Action action = bottomButton.getAction();
                        if (action != null) {
                            if (action.getConfirmPop() != null && StringUtils.hasLength(action.getConfirmPop().getContent())) {
                                action.getConfirmPop().setContent(localeService.getLanguageValue(locale, action.getConfirmPop().getContent()));
                            } else if (StringUtils.hasLength(action.getJumpPageTitle())) {
                                action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                            }
                        }
                        Map<String, Object> buttonRawData = new HashMap<>();
                        if (action.getRawData() != null) {
                            buttonRawData = (Map<String, Object>) action.getRawData();
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        //rawData里存提交接口所需参数
                        UiBotAction uiBotAction = getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            Map<String, Object> data = new HashMap<>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData(buttonRawData);

                    });
                    newPageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }


    /**
     * 在途宝展示月台信息
     *
     * @param locale
     * @param transportMainInfo
     * @param uiBotModel
     * @param name
     * @return
     */
    private CustomGroup buildPlatFormMessageGroup(String locale, DigiwinTransportResponse transportMainInfo, UiBotModel uiBotModel, String name) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(localeService.getLanguageValue(locale, name));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        Map<String, Object> dataMap = JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(transportMainInfo), Map.class);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    if ("appoint_time".equalsIgnoreCase(schema)) {
                        String date = StringUtils.hasLength(transportMainInfo.getAppointmentDeliveryDate()) ? transportMainInfo.getAppointmentDeliveryDate() : "-";
                        String[] values = date.split(" ");
                        String value = "";
                        if (values.length > 1) {
                            value = values[0];
                        } else {
                            value = date;
                        }
                        pageData.put(schema, Field.createLabelValueLeftFieldNoNewLine(
                                layout.getmLabelText().get(locale), value));
                    } else if ("time_slot".equalsIgnoreCase(schema)) {
                        List<TimeSlot> timeSlots = transportMainInfo.getTimeSlot();
                        if (timeSlots != null && timeSlots.size() > 0) {
                            String value = transportMainInfo.getTimeSlots(timeSlots);
                            pageData.put(schema, Field.createLabelValueLeftFieldNoNewLine(layout.getmLabelText().get(locale),
                                    value));
                        }
                    } else {
                        pageData.put(schema, Field.createLabelValueLeftFieldNoNewLine(
                                layout.getmLabelText().get(locale), (String) dataMap.get(schema)));
                    }
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent content = new CustomGroupContent();
        content.setPageData(pageData);
        content.setLayout(uiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        customGroup.setUseExpand(false);
        customGroup.setHasDetail(false);
        return customGroup;
    }


    /**
     * 在途宝-车辆信息
     *
     * @param driverMessageUiBotModel
     * @param vehicleInfo
     * @param locale
     * @return
     */
    private CustomGroup buildDriverMessageGroup(String locale, Map<String, Object> vehicleInfo, UiBotModel driverMessageUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> driverMessageLayouts = driverMessageUiBotModel.getLayout();
        UiBotPageData pageData = driverMessageUiBotModel.getPageData();
        UiBotPageData driverMessagePageData = new UiBotPageData();
        for (UiBotLayout driverMessageLayout : driverMessageLayouts) {
            String driverMessageSchema = driverMessageLayout.getSchema();
            Map<String, String> schemaPageData = (Map<String, String>) pageData.get(driverMessageSchema);
            switch (driverMessageLayout.getType()) {
                case Field.COMPONENT_TYPE:
                    Field driverMessageField = new Field();
                    //没有值默认给-
                    String value = "-";
                    if (!CollectionUtils.isEmpty(vehicleInfo)) {
                        value = String.valueOf(vehicleInfo.get(driverMessageSchema));
                    }
//                    driverMessageField = Field.create(schemaPageData.get("label"), "LABEL", value, driverMessageSchema);
                    driverMessageField = Field.create(driverMessageLayout.getmLabelText().get(locale), "LABEL", value, driverMessageSchema,
                            FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                    driverMessagePageData.put(driverMessageSchema, driverMessageField);
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent driverMessageContent = new CustomGroupContent();
        driverMessageContent.setLayout(driverMessageLayouts);
        driverMessageContent.setPageData(driverMessagePageData);
        customGroup.setContent(driverMessageContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey(locale, "车辆信息"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    /**
     * 在途宝-货运信息
     *
     * @param freightUiBotModel
     * @param taskNo
     * @param locale
     * @return
     */
    private CustomGroup buildFreightGroup(String locale, String taskNo, UiBotModel freightUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> freightLayouts = freightUiBotModel.getLayout();
        UiBotPageData pageData = freightUiBotModel.getPageData();
        UiBotPageData freightPageData = new UiBotPageData();
        for (UiBotLayout freightLayout : freightLayouts) {
            String freightSchema = freightLayout.getSchema();
            Map<String, String> schemaPageData = (Map<String, String>) pageData.get(freightSchema);
            switch (freightLayout.getType()) {
                case PageableList.COMPONENT_TYPE:
                    PageableList freightPageableList = new PageableList();
                    Map<String, Object> rawData = new HashMap<>();
                    rawData.put("task_no", taskNo);
                    rawData.put("use_has_next", true);
                    freightPageableList = PageableList.create(rawData,
                            "/mobile/v1/uibot/component/pageablelist/data",
                            "");
//                            freightLayout.getmLabelText().get(locale));
                    freightPageData.put(freightSchema, freightPageableList);
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent freightContent = new CustomGroupContent();
        freightContent.setLayout(freightLayouts);
        freightContent.setPageData(freightPageData);
        customGroup.setContent(freightContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey(locale, "货运信息"));
        return customGroup;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List<UiBotLayout> layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty(layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<>();
        outer:
        for (UiBotLayout layout : layoutList) {
            List<UiBotAction> actions = layout.getActions();
            if (CollectionUtils.isEmpty(actions)) {
                continue;
            }
            for (UiBotAction action : actions) {
                if (actionId.equalsIgnoreCase(action.getActionId())) {
                    uiBotAction.set(action);
                    break outer;
                }
            }
        }
        return uiBotAction.get();
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
