package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.*;

/**
 * 在途宝--货物出货任务
 *
 * @author zhangjj
 * @date 2022/9/23 17:03
 */
@Component
public class UiBotModelBuildZTBReceiptSignatureUploadStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBReceiptSignatureUploadStrategy.class);

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        UiBotPageData newPageData = new UiBotPageData();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    customGroup = customGroup.buildZtbPictrue("回单上传", locale, localeService, schema, true, "请上传签字后的回单照片");
                    newPageData.put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class
                    );
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                        if (ActionTypeEnum.CALL_API_BACK_TWO.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            ApiRawData buttonRawData = new ApiRawData();
                            buttonRawData.put("transport_no", rawData.get("transport_no"));
                            buttonRawData.put("biz_id", "ZTB");
                            buttonRawData.put("page_id", pageSetting.getPageId());
                            buttonRawData.put("action", rawData.get("action"));
                            buttonRawData.put("data", rawData.get("data"));
                            action.setRawData(buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    newPageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }

}
