package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.AsnHeaderResponse;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：在途宝扫码接单操作生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildZTBScanReceiveOrderStrategy
 * @Author: Liux
 * @Date: 2022年9月16日13点27分
 */
@Component("uiBotModelBuildZTBScanReceiveOrderStrategy")
public class UiBotModelBuildZTBScanReceiveOrderStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBScanReceiveOrderStrategy.class);

    @Autowired
    private ZhilinkService zhilinkService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildZTBScanReceiveOrder");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        //任务号
        String taskNo = (String) apiRequest.getRawData().get("task_no");
        String transportNo = (String) apiRequest.getRawData().get("transport_no");
        AsnHeaderResponse asnHeaderResponse = zhilinkService.getAsnHeaderByTaskNo(taskNo, apiRequest.getTenantId(), locale, apiRequest.getIamUserToken());
//        AsnHeaderResponse asnHeaderResponse = zhilinkService.getAsnHeaderByTaskNo("ASN2022090800001TESTLICENSENO", "1123456", "zh_CN", apiRequest.getIamUserToken());
        // 拼成最终数据
        stopWatch.start("Build ApcAbnormalReport Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = new UiBotPageData();
        // 生成相关组件
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(LocaleUtil.getMobileTextByKey(locale, "扫码接单"), null, new ArrayList<>());
                    pageData.put(schema, titleBody);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_ONE".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, asnHeaderResponse,
                                JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), UiBotModel.class), false);
                    } else if ("CUSTOM_GROUP_TWO".equalsIgnoreCase(schema)) {
                        customGroup = buildBasicInfoGroup(locale, asnHeaderResponse,
                                JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), UiBotModel.class));
                    } else if ("CUSTOM_GROUP_THREE".equalsIgnoreCase(schema)) {
                        customGroup = buildDriverMessageGroup(locale, asnHeaderResponse,
                                JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), UiBotModel.class));
                    }
                    pageData.put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    BottomButtonDigiwinAthena bottomButton = new BottomButtonDigiwinAthena();
                    bottomButton.setName(LocaleUtil.getMobileTextByKey(locale, "提交"));
                    bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());

                    Action action = new Action();
                    action.setType(ActionTypeEnum.CALL_API.getValue());
                    Map<String, Object> buttonRawData = new HashMap<>();
                    buttonRawData.put("task_no", taskNo);
                    if (StringUtils.hasLength(transportNo)) {
                        buttonRawData.put("transport_no", transportNo);
                    }
                    buttonRawData.put("biz_id", "ZTB");
                    buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_SCAN_RECEIVE_ORDER.toString());
                    //rawData里存提交接口所需参数
                    buttonRawData.put("action", apiRequest.getRawData().get("action"));
                    buttonRawData.put("data", apiRequest.getRawData().get("data"));
                    action.setRawData(buttonRawData);

                    bottomButton.setAction(action);
                    bottomButtonList.add(bottomButton);

                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        uiBotModel.setPageData(pageData);
        return uiBotModel;
    }


    /**
     * 在途宝-基本信息
     *
     * @param basicInfoUiBotModel
     * @param asnHeaderResponse
     * @param locale
     * @return
     */
    private CustomGroup buildBasicInfoGroup(String locale, AsnHeaderResponse asnHeaderResponse, UiBotModel basicInfoUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> basicInfoLayouts = basicInfoUiBotModel.getLayout();
        UiBotPageData pageData = basicInfoUiBotModel.getPageData();
        UiBotPageData basicInfoPageData = new UiBotPageData();
        for (UiBotLayout basicInfoLayout : basicInfoLayouts) {
            String basicInfoSchema = basicInfoLayout.getSchema();
            Map<String, String> schemaPageData = (Map<String, String>) pageData.get(basicInfoSchema);
            switch (basicInfoLayout.getType()) {
                case Field.COMPONENT_TYPE:
                    Field basicInfoField = new Field();
                    //没有值默认给-
                    String value = "-";
                    if ("plan_arrival_date".equalsIgnoreCase(basicInfoSchema)) {
                        value = asnHeaderResponse.getPlanArrivalDate() != null ? String.valueOf(asnHeaderResponse.getPlanArrivalDate()) : value;
//                        basicInfoField = Field.create(schemaPageData.get("label"), "LABEL", value, basicInfoSchema);
                        basicInfoField = Field.create(basicInfoLayout.getmLabelText().get(locale), "LABEL", value, basicInfoSchema,
                                FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue());
                    }
                    basicInfoPageData.put(basicInfoSchema, basicInfoField);
                    break;
                /*case TextMulti.COMPONENT_TYPE:
                    //TODO 目前api文档没有该字段，但是UX稿有设计，故临时写了个假数据。等api审核确定后再看最终字段来修改此处
                    TextMulti remakeTextMulti = new TextMulti();
                    remakeTextMulti.setTitle(basicInfoLayout.getmLabelText().get(locale));
                    remakeTextMulti.setTitleStyleType(1);
                    remakeTextMulti.setValue("*************");
                    basicInfoPageData.put(basicInfoSchema, remakeTextMulti);
                    break;*/
                default:
                    break;
            }
        }
        CustomGroupContent basicInfoContent = new CustomGroupContent();
        basicInfoContent.setLayout(basicInfoLayouts);
        basicInfoContent.setPageData(basicInfoPageData);
        customGroup.setContent(basicInfoContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey(locale, "时效信息"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    /**
     * 在途宝-车辆信息
     *
     * @param driverMessageUiBotModel
     * @param asnHeaderResponse
     * @param locale
     * @return
     */
    private CustomGroup buildDriverMessageGroup(String locale, AsnHeaderResponse asnHeaderResponse, UiBotModel driverMessageUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> driverMessageLayouts = driverMessageUiBotModel.getLayout();
        UiBotPageData driverMessagePageData = new UiBotPageData();
        for (UiBotLayout driverMessageLayout : driverMessageLayouts) {
            String driverMessageSchema = driverMessageLayout.getSchema();
            switch (driverMessageLayout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect driverMessage = zhilinkService.getDriverVehicle(driverMessageLayout, driverMessageUiBotModel.getPageData(), locale);
                    driverMessagePageData.put(driverMessageSchema, driverMessage);
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent driverMessageContent = new CustomGroupContent();
        driverMessageContent.setLayout(driverMessageLayouts);
        driverMessageContent.setPageData(driverMessagePageData);
        customGroup.setContent(driverMessageContent);
        return customGroup;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
