package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.List;

/**
 * 在途宝-出货任务-二维码页面
 *
 * @author zhangjj
 * @date 2022/10/8 14:29
 */
@Component
public class UiBotModelBuildZTBShippingTaskQrCodeStrategy implements UiBotModelBuildStrategy {
    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        ApiRawData apiRawData = apiRequest.getRawData();
        String taskNo = (String) apiRawData.get("task_no");
        String transportNo = (String) apiRawData.get("transport_no");
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case QrCode.COMPONENT_TYPE:
                    QrCodeContentMsg qrCodeContentMsg = new QrCodeContentMsg(QrCodeContentMsg.BIZ_TYPE_ZHILINK_ITM);
                    QrCode qrCode;
                    if (StringUtils.hasLength(transportNo)) {
                        qrCodeContentMsg.put("transport_no", transportNo);
                        qrCodeContentMsg.put("task_no", taskNo);
                        qrCode = QrCode.create(qrCodeContentMsg, LocaleUtil.getMobileTextByKey(locale, "请扫码运单二维码"));
                    } else {
                        qrCodeContentMsg.put("task_no", taskNo);
                        qrCode = QrCode.create(qrCodeContentMsg, LocaleUtil.getMobileTextByKey(locale, "请扫码货运二维码"));
                    }
                    pageData.put(schema, qrCode);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }
}
